/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           Painter.cpp
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifdef __GNUG__
	#pragma implementation "Painter.h"
#endif

#include "Painter.h"

#include "func.h"
#include "FontProvider.h"

#include <wx/dc.h>

/*****************************************************
**
**   Painter   ---   drawRectangle
**
******************************************************/
void Painter::drawRectangle( const wxRect &r )
{
	drawRectangle( r.GetLeft(), r.GetTop(), r.GetWidth(), r.GetHeight());
}

/*****************************************************
**
**   Painter   ---   drawLine
**
******************************************************/
void Painter::drawLine( const wxPoint &p1, const wxPoint &p2 )
{
	drawLine( p1.x, p1.y, p2.x, p2.y );
}

/*****************************************************
**
**   Painter   ---   drawSimpleText
**
******************************************************/
void Painter::drawSimpleText( const wxRect &r, const wxString &s )
{
	drawSimpleText( r.GetLeft(), r.GetTop(), r.GetWidth(), r.GetHeight(), s );
}

/*****************************************************
**
**   Painter   ---   drawSimpleText
**
******************************************************/
void Painter::drawSimpleText( const double &x, const double &y, const double &w, const double &h,
	const wxString &t )
{
	drawTextFormatted( wxRect( (int)x, (int)y, (int)w, (int)h ), t, Align::Center );
}

/*****************************************************
**
**   Painter   ---   drawTextFormatted
**
******************************************************/
void Painter::drawTextFormatted( const wxRect &r, const wxString &t, const int& align )
{
	drawTextFormatted( r.GetLeft(), r.GetTop(), r.GetWidth(), r.GetHeight(), t, align );
}

/*****************************************************
**
**   DcPainter   ---   Constructor
**
******************************************************/
DcPainter:: DcPainter( wxDC *d )
{
	dc = d;
}

/*****************************************************
**
**   DcPainter   ---   drawRectangle
**
******************************************************/
void DcPainter::drawRectangle( const double &x, const double &y, const double &w, const double &h )
{
	dc->DrawRectangle( (int)x, (int)y, (int)w, (int)h );
}

/*****************************************************
**
**   DcPainter   ---   drawLine
**
******************************************************/
void DcPainter::drawLine( const double &x1, const double &y1, const double &x2, const double &y2 )
{
	dc->DrawLine( (int)x1, (int)y1, (int)x2, (int)y2 );
}

/*****************************************************
**
**   DcPainter   ---   drawTextFormatted
**
******************************************************/
void DcPainter::drawTextFormatted( const double &x, const double &y, const double &w, const double &h,
	const wxString &t, const int& align )
{
	DcHelper( dc ).drawTextFormatted( wxRect( (int)x, (int)y, (int)w, (int)h ), t, align );
}

/*****************************************************
**
**   DcPainter   ---   getTextExtent
**
******************************************************/
void DcPainter::getTextExtent( const wxString &s, double *w, double *h )
{
	wxCoord w1, h1;
	dc->GetTextExtent( s, &w1, &h1 );
	*h = h1; 
	*w = w1;
}

/*****************************************************
**
**   DcPainter   ---   drawEllipse
**
******************************************************/
void DcPainter::drawEllipse( const double &x0, const double &y0, const double &xmax, const double &ymax )
{
	dc->DrawEllipse( a_rund(x0), a_rund(y0), a_rund(xmax), a_rund(ymax) );
}

/*****************************************************
**
**   DcPainter   ---   drawArc 
**
******************************************************/
void DcPainter::drawArc( const double &x0, const double &y0, const double &xmax, const double &ymax,
	const double &w1, const double &w2 )
{
	dc->DrawEllipticArc( a_rund(x0), a_rund(y0), a_rund(xmax), a_rund(ymax), a_rund(w1), a_rund( w2) );
}

/*****************************************************
**
**   DcPainter   ---   drawPoint 
**
******************************************************/
void DcPainter::drawPoint( const double &x, const double &y )
{
	dc->DrawPoint( a_rund(x), a_rund(y) );
}

/*****************************************************
**
**   DcPainter   ---   setTransparentBrush
**
******************************************************/
void DcPainter::setTransparentBrush()
{
	wxBrush b = dc->GetBrush();
	b.SetStyle( wxTRANSPARENT );
	dc->SetBrush( b );
}

/*****************************************************
**
**   DcPainter   ---   setBrushColor
**
******************************************************/
void DcPainter::setBrushColor( const wxColour &c )
{
	wxBrush b = dc->GetBrush();
	b.SetStyle( wxSOLID );
	b.SetColour( c );
	dc->SetBrush( b );
}

/*****************************************************
**
**   DcPainter   ---   getBrushColor
**
******************************************************/
wxColour DcPainter::getBrushColor()
{
	return dc->GetBackground().GetColour();
}

/*****************************************************
**
**   DcPainter   ---   setTransparentPen
**
******************************************************/
void DcPainter::setTransparentPen()
{
	wxPen p = dc->GetPen();
	p.SetStyle( wxTRANSPARENT );
	dc->SetPen( p );
}

/*****************************************************
**
**   DcPainter   ---   setPenColor
**
******************************************************/
void DcPainter::setPenColor( const wxColour &c )
{
	wxPen p = dc->GetPen();
	p.SetStyle( wxSOLID );
	p.SetColour( c );
	dc->SetPen( p );
}

/*****************************************************
**
**   DcPainter   ---   getPenColor
**
******************************************************/
wxColour DcPainter::getPenColor()
{
	return dc->GetPen().GetColour();
}

/*****************************************************
**
**   DcPainter   ---   setLineStyle
**
******************************************************/
void DcPainter::setLineStyle( const int &s )
{
	wxPen p = dc->GetPen();
	p.SetStyle( s );
	//p.SetWidth( 1 );
	dc->SetPen( p );
}

/*****************************************************
**
**   DcPainter   ---   setSymbolFont
**
******************************************************/
void DcPainter::setSymbolFont()
{
	FontProvider f;
	dc->SetFont( *f.getSymbolFont());
}

/*****************************************************
**
**   DcPainter   ---   setGraphicFont
**
******************************************************/
void DcPainter::setGraphicFont()
{
	FontProvider f;
	dc->SetFont( *f.getGraphicFont());
}

/*****************************************************
**
**   DcPainter   ---   setDevanagariFont
**
******************************************************/
void DcPainter::setDevanagariFont()
{
}


