/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           Painter.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifndef _PAINTER_H_
#define _PAINTER_H_

#ifdef __GNUG__
	#pragma interface "Painter.h"
#endif

#include "Base.h"
#include <wx/string.h>

class wxDC;

/*****************************************************
**
**   CLASS Painter  
**
******************************************************/
class Painter
{
public:

	virtual ~Painter() {}
	virtual void drawRectangle( const double &x, const double &y, const double &w, const double &h ) = 0;
  virtual void drawLine( const double &x1, const double &y1, const double &x2, const double &y2 ) = 0;
	virtual void drawTextFormatted( const double &x, const double &y, const double &w, const double &h,
		const wxString &t, const int& align ) = 0;
	virtual void getTextExtent( const wxString &s, double *w, double *h ) = 0;

	void drawRectangle( const wxRect & );
	void drawSimpleText( const wxRect &r, const wxString &s );
	virtual void drawSimpleText( const double &x, const double &y, const double &w, const double &h,
		const wxString &s );
	void drawTextFormatted( const wxRect &rect, const wxString &t, const int& align );
  void drawLine( const wxPoint &p1, const wxPoint &p2 );

	virtual void drawEllipse( const double &x0, const double &y0, const double &xmax, const double &ymax ) = 0;
	virtual void drawArc( const double &x0, const double &y0, const double &xmax, const double &ymax,
		const double &w1, const double &w2 ) = 0;
	virtual void drawPoint( const double &x, const double &y ) = 0;

	virtual void setTransparentBrush() = 0;
	virtual void setBrushColor( const wxColour& ) = 0;
	virtual void setTransparentPen() = 0;
	virtual void setPenColor( const wxColour& ) = 0;
	virtual wxColour getPenColor() = 0;
	virtual wxColour getBrushColor() = 0;
	virtual void setLineStyle( const int& ) = 0;
	virtual void setSymbolFont() {}
	virtual void setGraphicFont() {}
	virtual void setDevanagariFont() {}

protected:

private:

};

/*****************************************************
**
**   CLASS DcPainter  
**
******************************************************/
class DcPainter: public Painter
{
public:
	DcPainter( wxDC* );
	virtual void drawRectangle( const double &x, const double &y, const double &w, const double &h );
  virtual void drawLine( const double &x1, const double &y1, const double &x2, const double &y2 );
	virtual void drawTextFormatted( const double &x, const double &y, const double &w, const double &h,
		const wxString &t, const int& align );
	virtual void getTextExtent( const wxString &s, double *w, double *h );
	virtual void drawEllipse( const double &x0, const double &y0, const double &xmax, const double &ymax );
	virtual void drawArc( const double &x0, const double &y0, const double &xmax, const double &ymax,
		const double &w1, const double &w2 );
	virtual void drawPoint( const double &x, const double &y );
	virtual void setTransparentBrush();
	virtual void setBrushColor( const wxColour& );
	virtual void setTransparentPen();
	virtual void setPenColor( const wxColour& );
	virtual wxColour getPenColor();
	virtual wxColour getBrushColor();
	virtual void setLineStyle( const int& );
	virtual void setSymbolFont();
	virtual void setGraphicFont();
	virtual void setDevanagariFont();

protected:

private:
	wxDC *dc;
};


#endif

