/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           PartnerView.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifndef _PARTNERVIEW_H_
#define _PARTNERVIEW_H_

#ifdef __GNUG__
	#pragma interface "PartnerView.h"
#endif

#include "Base.h"
#include "Document.h"
#include "MView.h"

class ContextMenuInfo;
class CompositHoroscope;
class GraphicWidget;
class PartnerViewDocListener;
class PlanetaryPositionTextCtrl;

/*****************************************************
**
**   CLASS PartnerTextWidget
**
******************************************************/
class PartnerTextWidget : public TextWidget
{
public:
	PartnerTextWidget( wxWindow *parent, ChildWindow*, wxWindowID id = -1, const wxPoint& pos = wxDefaultPosition,
	    const wxSize& size = wxDefaultSize );
	void setCharts( Horoscope *h1, Horoscope *h2 ) { horoscope1 = h1; horoscope2 = h2; }
	void setPreferVedic( const bool &p ) { preferVedic = p; }

protected:
	Horoscope *horoscope1, *horoscope2;
	bool preferVedic;

private:
	DECLARE_CLASS( PartnerTextWidget )
	DECLARE_EVENT_TABLE()
};

/*****************************************************
**
**   CLASS PartnerView  
**
******************************************************/
class PartnerView : public MView 
{
	friend class PartnerViewDocListener;

public:
	PartnerView( MViewInfo, DocumentManager* );
	~PartnerView();

	virtual bool dispatchCommand( const int &command );
	int getHsSystem() { return hsSystem; }
	virtual void OnPreferVedic( bool f );
	virtual const wxChar *getWindowLabel( const bool shortname = false );
	virtual void postCreate();

protected:
	Horoscope *h1, *h2;
	CompositHoroscope *ch;

	DocumentManager *docmanager;
	PartnerViewDocListener *listener;

	TextWidget *textctrl1;
	PlanetaryPositionTextCtrl *pptext;
	MySplitter  *splitter;
	GraphicWidget *gwidget;

	void initClientView();
	void OnPartnerChoice( wxCommandEvent& );
	void setupCharts();
	void onDocChanged();
	void updateAllDocs();
	void documentListChanged();

	virtual void onChangeHsSystem( const int &hySystem );
	void OnToolbarCommand();
	void updateToolItems();
	void updatePartnerChoices();
	virtual void SetContextMenuInfo( ContextMenuInfo& );
	void updateClientView();
	virtual void initToolItems();

	virtual void writeStream( wxString& );
	int istyle, wstyle;
	int mode, hsSystem;
	int circle, orbis, filter, sortorder;

private:
	DECLARE_CLASS( PartnerView )
	DECLARE_EVENT_TABLE()
};

/*****************************************************
**
**   CLASS PartnerViewDocListener  
**
******************************************************/
class PartnerViewDocListener : public DocumentListener
{
public:
	PartnerViewDocListener( DocumentManager *manager, PartnerView *view );
	~PartnerViewDocListener();

protected:
	void updateAllDocs();
	void documentListChanged();

private:
	DocumentManager *manager;
	PartnerView *view;
	DECLARE_CLASS( PartnerViewDocListener )
};


#endif

