/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           PdfWriter.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifndef _PDFWRITER_H_
#define _PDFWRITER_H_

#ifdef __GNUG__
	#pragma interface "PdfWriter.h"
#endif

#include "Painter.h"
#include "PrintoutManager.h"
#include "Writer.h"

#include <wx/string.h>
#include "wx/pdfdoc.h"

class Horoscope;

/*****************************************************
**
**   CLASS PdfWriter  
**
******************************************************/
class PdfWriter : public Writer, Painter, wxPdfDocument
{
public:

	PdfWriter( Horoscope*, const int papersize );
	virtual ~PdfWriter();
	void Footer();
	virtual void beginWriting();
	virtual void endWriting();
	void setFilename( wxString f ) { filename = f; }
	virtual void writeHeader1( const wxString& );
	virtual void writeHeader2( const wxString& );
	virtual void writeHeader3( const wxString& );
	virtual void writeParagraph( const wxString& );
	virtual void writeLine( const wxString& );
	virtual void writeTable( Table& );
	virtual void writeListInColumns( const vector<wxString>, const int &colnr );
	virtual void writeMidpointDiagram( vector<MidpointDiagram> );

	virtual void drawRectangle( const double &x, const double &y, const double &w, const double &h );
  virtual void drawLine( const double &x1, const double &y1, const double &x2, const double &y2 );
	virtual void drawTextFormatted( const double &x, const double &y, const double &w, const double &h,
		const wxString &t, const int& align );
	virtual void getTextExtent( const wxString &s, double *w, double *h );

	virtual void drawEllipse( const double &x0, const double &y0, const double &xmax, const double &ymax );
	virtual void drawArc( const double &x0, const double &y0, const double &xmax, const double &ymax,
		const double &w1, const double &w2 );
	virtual void drawPoint( const double &x, const double &y );
	virtual void setTransparentBrush();
	virtual void setBrushColor( const wxColour& );
	virtual void setTransparentPen();
	virtual void setPenColor( const wxColour& );
	virtual wxColour getPenColor();
	virtual wxColour getBrushColor();
	virtual void setLineStyle( const int& );

	void printPageFrame();
	void writeVedicPair( const int &varga1, const int &varga2, int style = -1 );
	void writeWesternChart( int style = -1 );
	void setPrintInfo( const int& );
	void printItem( PrintItem *item );
	void print();
	void writeSbc();
	void writeTitle();
	void writeMidpoint();

private:
	wxString filename;
	PrintInfo *info;
	void writeTableHeaderEntry( const wxString &s1 );
	wxString header1FontName, header2FontName, header3FontName, defaultFontName, tinyFontName;
	wxString header1FontStyle, header2FontStyle, header3FontStyle, defaultFontStyle, tinyFontStyle;
	int header1FontSize, header2FontSize, header3FontSize, defaultFontSize, tinyFontSize;
	Horoscope *horoscope;
	void setDefaultFont();
	wxPdfLineStyle *lsSolid, *lsDot, *lsLongDash, *lsDotDash;
};

#endif


