/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           Printer.cpp
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifdef __GNUG__
	#pragma implementation "Printer.h"
#endif

#include "Printer.h"

#include "Conf.h"
#include "Horoscope.h"
#include "PdfWriter.h"

#include <wx/defs.h>
#include <wx/filename.h>
#include <wx/string.h>

extern Config *config;

/*****************************************************
**
**   Printer   ---   Constructor 
**
******************************************************/
Printer::Printer( Horoscope *horoscope )
{
 h = horoscope;
 writer = new PdfWriter( h, config->printPaperFormat );
}

/*****************************************************
**
**   Printer   ---   Destructor 
**
******************************************************/
Printer::~Printer()
{
	delete writer;
}

/*****************************************************
**
**   Printer   ---   print
**
******************************************************/
bool Printer::print( const int &prt, wxString f, const bool askOverwrite )
{
	int i;
	wxString s, pathname;

	filename = f;
	pathname = config->defExportPath;
	if ( filename == wxEmptyString )
	{
		filename = pathname;
		// append a slash/backslash if necessary
		if ( pathname != wxEmptyString && pathname.Last() != wxFileName::GetPathSeparator())
			filename << wxFileName::GetPathSeparator();
		filename << h->getHName() << wxT( ".pdf" );
	}
	if ( wxFile::Exists( filename ) && ! wxFile::Access( filename, wxFile::write ))
	{
		s.Printf( _( "Permission denied (%s)" ), filename.c_str());
		doMessageBox( 0, s, wxOK | wxICON_ERROR );
		return false;
	}
	if ( config->printAskOverwrite && wxFile::Exists( filename ))
	{
		s.Printf( _( "File %s exists. Do you want to overwrite?" ), filename.c_str());
		i = doMessageBox( 0, s, wxYES_NO | wxCENTRE );
		if ( i == wxID_NO ) return false;
	}

	// try to create the file and look if it works; e.g. no write permission on directory will not work.
	wxFile file;
	bool b = file.Create( filename, true );
	if ( b == false )
	{
		s.Printf( _( "Could not create file %s" ), filename.c_str());
		doMessageBox( 0, s, wxOK | wxICON_ERROR );
		return false;
	}
	file.Close();

	writer->setPrintInfo( prt );
	writer->setFilename( filename );
	writer->beginWriting();
	writer->print();
	writer->endWriting();
	config->defExportPath = pathname;
	return true;
}


