/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           PrintoutManager.cpp
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifdef __GNUG__
	#pragma implementation "PrintoutManager.h"
#endif

#include "PrintoutManager.h"

#include <stdio.h>

#include "Conf.h"
#include "Dasa.h"
#include "Horoscope.h"
#include "Session.h"

#include <wx/dc.h>
#include <wx/textfile.h>
#include <wx/tokenzr.h>

extern Config *config;

PrintoutManager *PrintoutManager::ego = 0;

/*****************************************************
**
**   PrintoutManager   ---   Constructor
**
******************************************************/
PrintoutManager::PrintoutManager()
{
	init();
}

/*****************************************************
**
**   PrintoutManager   ---   get
**
******************************************************/
PrintoutManager *PrintoutManager::get()
{
	if ( ! ego ) ego = new PrintoutManager();
	return ego;
}

/*****************************************************
**
**   PrintoutManager   ---   Destructor
**
******************************************************/
PrintoutManager::~PrintoutManager()
{
	clear();
}

/*****************************************************
**
**   PrintoutManager   ---   clear
**
******************************************************/
void PrintoutManager::clear()
{
	for( unsigned int i = 0; i < info.size(); i++ ) delete info[i];
	info.clear();
}

/*****************************************************
**
**   PrintoutManager   ---   init
**
******************************************************/
void PrintoutManager::init()
{
	wxString filename, buf, name, description;
	wxString spage, stype, sstyle, sp1, sp2;
	long page, type, style, p1, p2;
	wxTextFile theFile;
	PrintInfo *pinfo = 0;

	filename = Session::get()->getPrintoutFile();

	if ( ! theFile.Open( filename ))
	{
		printf( "Can't open printout.dat\n" );
		return;
	}
	buf = theFile.GetFirstLine();
	int line = 0;
	// Quick and dirty parser
  while( ! theFile.Eof() && line < 1000 )
  {
		if ( ! buf.StartsWith( wxT( "#" )) && buf.Len() > 1 )
		{
			if ( buf.StartsWith( wxT( "printinfo" )))
			{
				wxStringTokenizer t( buf, wxT( ";" ));
				t.GetNextToken();
				name = t.GetNextToken();
				spage = t.GetNextToken();
				description = t.GetNextToken();
				assert( name.Len() > 0 );
				spage.ToLong( &page );
				pinfo = new PrintInfo( name, page, description );
			}
			else if ( buf.StartsWith( wxT( "endprintinfo" )))
			{
				info.push_back( pinfo );
				pinfo = 0;
			}
			else if ( buf.StartsWith( wxT( "item" )))
			{
				wxStringTokenizer t( buf, wxT( ";" ));
				t.GetNextToken();
				stype = t.GetNextToken();
				sstyle = t.GetNextToken();
				sp1 = t.GetNextToken();
				sp2 = t.GetNextToken();
				assert( stype.Len() > 0 );
				stype.ToLong( &type );
				sstyle.ToLong( &style );
				sp1.ToLong( &p1 );
				sp2.ToLong( &p2 );
				assert( pinfo );
				pinfo->items.push_back( new PrintItem( type, style, p1, p2 ));
			}
			else
			{
				//assert( 0 );
			}
		}
		else
		{
		}

    buf = theFile.GetNextLine();
		line++;
	}
	theFile.Close();
}

/*****************************************************
**
**   PrintoutManager   ---   getPrintInfoById
**
******************************************************/
PrintInfo *PrintoutManager::getPrintInfoById( const unsigned int&i )
{
	assert( i >= 0 && i < info.size());
	return info[i];
}

/*****************************************************
**
**   PrintItem   ---   Constructor
**
******************************************************/
PrintItem::PrintItem( const int &t, const int s, const int pp1, const int pp2 )
{
  type = t;
	style = s;
	p1 = pp1;
	p2 = pp2;
	page = 0;
}

/*****************************************************
**
**   PrintInfo   ---   Destructor
**
******************************************************/
PrintInfo::PrintInfo( const wxString &n, const int &p, const wxString &desc )
{
	name = n;
	pages = p;
	description = desc;
}

/*****************************************************
**
**   PrintInfo   ---   Destructor
**
******************************************************/
PrintInfo::~PrintInfo()
{
	for( unsigned int i = 0; i < items.size(); i++ ) delete items[i];
	items.clear();
}

