/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           PrintoutManager.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/
#ifndef _PRINTOUTMANAGER_H_
#define _PRINTOUTMANAGER_H_

#ifdef __GNUG__
	#pragma interface "PrintoutManager.h"
#endif

#include <vector>
#include <wx/object.h>

using namespace std;

class Horoscope;
class PrintWriter;
class wxDC;

enum { PI_TITLE = 0, PI_BASEDATA, PI_VEDICGRAPHICPAIR, PI_GRAPHIC, PI_DASA, PI_ASHTAKAVARGA, PI_SBC, PI_MIDPOINT };

/*****************************************************
**
**   CLASS PrintItem
**
******************************************************/
class PrintItem : public wxObject
{
public:
	PrintItem( const int &t, const int s = 0, const int pp1 = -1, const int pp2 = -1 );
	int type;
	int style;
	int p1;
	int p2;
	int page;
protected:

};

/*****************************************************
**
**   CLASS PrintInfo
**
******************************************************/
class PrintInfo : public wxObject
{
public:
	PrintInfo( const wxString &n, const int &p, const wxString &desc );
	~PrintInfo();
	vector<PrintItem*> items;
	wxString name, description;
	int pages;

protected:

};

/*****************************************************
**
**   CLASS PrintoutManager
**
******************************************************/
class PrintoutManager : public wxObject
{
public:
	static PrintoutManager *get();
	vector<PrintInfo*> getPrintoutList() { return info; }
	PrintInfo *getDefaultVedicPrintout() { return defvedic; }
	PrintInfo *getDefaultWesternPrintout() { return defwestern; }
	PrintInfo *getPrintInfoById( const unsigned int& );

protected:
	PrintoutManager();
	~PrintoutManager();
	void init();
	void clear();

	PrintInfo *defwestern, *defvedic;
	static PrintoutManager *ego;
	vector<PrintInfo*> info;
};

#endif

