/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           SbcView.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifndef SBCVIEW_H_
#define SBCVIEW_H_

#ifdef __GNUG__
	#pragma interface "SbcView.h"
#endif

#include "MView.h"
#include "Base.h"

#include <wx/string.h>

class ChildWindow;
class Horoscope;
class SbcWidget;
class SbcWriter;
class TextWidget;
class Writer;
class wxDC;

/*****************************************************
**
**   CLASS NakshatraContents  
**
******************************************************/
class NakshatraContents
{
public:
	NakshatraContents() { s = wxT( "" ); nb = 0; lines = 0; }
	int nb, lines;
	wxString s;
	wxArrayInt planets;
};


/*****************************************************
**
**   CLASS SbcView  
**
******************************************************/
class SbcView : public MView
{
public:

	SbcView( MViewInfo );
	~SbcView();

	virtual bool dispatchCommand( const int &command );
	int getIStyle();
	virtual const wxChar *getWindowLabel( const bool shortname = false );
	virtual void postCreate();

protected:
	void writeContents();
	void OnPaint(wxPaintEvent& event);
	void OnDataChanged();
  Horoscope *th;
	void updateTextWindow( Writer* );
	void updateTextWindowPositions( Writer* );
	void updateTextWindowAfflictions( Writer* );
	void OnToolbarCommand();
	void OnActual( wxCommandEvent& );
	SbcWidget *gwidget;
  MySplitter *splitter;
	TextWidget *theText;
	void SetContextMenuInfo( ContextMenuInfo& );
	void doSaveText();
	int textmode, gocharamode;
	virtual void initToolItems();

private:
	DECLARE_CLASS( SbcView )
	DECLARE_EVENT_TABLE()
};


/*****************************************************
**
**   CLASS SbcWriter
**
******************************************************/
class SbcWriter : public wxObject
{
public:

	SbcWriter( Horoscope*, Horoscope* );
	void setGocharaMode( const bool &b ) { gochara = b; }
	void doPaint( wxDC*, const wxRect& );
	bool getFieldIndex( int &x, int& y );
	void toggleMark( const int &x, const int &y ) { mark[x][y] = ! mark[x][y]; }
	wxColour bgcolor, pcolor, fgcolor, mcolor, a1color, a2color;
	void writeNakshatras();

private:

	void markField( const int &x, const int &y );
	void paintChart();
	void drawAspects();

	double xmax, ymax, x0, y0, xAussen, yAussen, xstep, ystep;

  Horoscope *h, *th;
	NakshatraContents contents[28];

	wxRect getNakshatraCoord( const int &i );
	wxRect getFieldCoord( const int &x, const int &y );
	wxRect getWeekdayCoord( const int& );
	wxRect getRasiCoord( const int& );
	void getNakshatraIndex( const int &i, int &x, int &y );
	void getRasiIndex( const int &r, int &x, int &y );
	void getWeekdayIndex( const int &w, int &x, int &y );
	int mark[9][9];
	int style;
	bool gochara;
	wxDC *dc;
	void drawTextFormatted( const wxRect &rect, const wxString t, const int& align );

private:
};

/*****************************************************
**
**   CLASS SbcWidget  
**
******************************************************/
class SbcWidget : public ExportableScrollWidget
{
public:

	SbcWidget( wxWindow *parent, Horoscope*, Horoscope*, wxWindowID id = -1, const wxPoint& pos = wxDefaultPosition,
		const wxSize& size = wxDefaultSize );
	~SbcWidget();
	void setGocharaMode( const bool &b ) { writer->setGocharaMode( b ); }
	virtual void OnDataChanged();

private:

	wxColour bgcolor, fgcolor;
	SbcWriter *writer;
	void OnMouseLeft( wxMouseEvent& );
	void doPaint( wxDC* );

private:
	DECLARE_CLASS( SbcWidget )
	DECLARE_EVENT_TABLE()
};

#endif

