/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           Shortcuts.cpp
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifdef __GNUG__
	#pragma implementation "Shortcuts.h"
#endif

#include "Shortcuts.h"
#include "Base.h"

#include <wx/event.h>

const int ShortcutManager::child_commands[SHORTCUT_MAX_CHILD_COMMANDS][4] = {
	{ CHILD_CLOSE, WXK_ESCAPE, 0, 0 },	
	{ CHILD_CLOSE, 'W', 0, 1 },	
	{ CHILD_CLOSE_DOC, 'W', 1, 1 },	
	{ CHILD_EDITDATA, 'B', 0, 1 },	
	{ CHILD_NEW_TEXT, 'T', 0, 1 },	
	{ CHILD_NEW_TRANSIT, 'R', 0, 1 },	
// start disthook
	{ CHILD_NEW_YOGA, 'Y', 0, 1 },	
// end disthook
	{ CHILD_NEW_SBC, 'S', 1, 1 },	
	{ CHILD_NEW_SOLAR, 'T', 1, 1 },	
	{ CHILD_NEW_MIDPOINT, 'M', 0, 1 },	
	{ VIEW_PREFERINDIAN, 'v', 0, 0 },	
	{ VIEW_PREFERWESTERN, 'w', 0, 0 },	
	{ CHILD_NEW_WCHART, '0', 0, 0 },	
	{ CHILD_COPY, 'C', 0, 1 },	
	{ CHILD_ANIMATE, 'A', 1, 1 },	
	{ CHILD_SELECT_ALL, 'A', 1, 1 },	
	{ CHILD_SAVE, 'S', 0, 1 },	
	{ CHILD_SAVEAS, 'A', 0, 1 },	
	{ CHILD_PRINT, 'P', 0, 1 },	
	{ CHILD_QUICKPRINT, 'P', 1, 1 },	
	{ CHILD_NEW_DASA, 'D', 0, 1 },
	{ CHILD_NEW_GRAPHICALDASA, 'G', 0, 1 },
	{ CHILD_NEW_RASI, '1', 0, 0 },
	{ CHILD_NEW_RASI+1, '2', 0, 0 },
	{ CHILD_NEW_RASI+2, '3', 0, 0 },
	{ CHILD_NEW_RASI+3, '4', 0, 0 },
	{ CHILD_NEW_RASI+4, '5', 0, 0 },
	{ CHILD_NEW_RASI+5, '6', 0, 0 },
	{ CHILD_NEW_RASI+6, '7', 0, 0 },
	{ CHILD_NEW_RASI+7, '8', 0, 0 },
	{ CHILD_NEW_RASI+8, '9', 0, 0 },
	{ CHILD_NEW_RASI+9, '0', 0, 1 },
	{ CHILD_NEW_RASI+10, '1', 0, 1 },
	{ CHILD_NEW_RASI+11, '2', 0, 1 },
	{ CHILD_NEW_RASI+12, '3', 0, 1 },
	{ CHILD_NEW_RASI+13, '4', 0, 1 },
	{ CHILD_NEW_RASI+14, '5', 0, 1 },
	{ CHILD_NEW_RASI+15, '6', 0, 1 },
	{ CHILD_NEW_RASI+16, '7', 0, 1 },
	{ CHILD_NEW_RASI+17, '8', 0, 1 },
	{ CHILD_NEW_RASI+18, '9', 0, 1 }
};

const int ShortcutManager::app_commands[SHORTCUT_MAX_APP_COMMANDS][4] = {
	{ APP_FILENEW, 'N', 0, 1 },	
	{ APP_FILEOPEN, 'O', 0, 1 },	
	{ APP_FILEQUIT, 'Q', 0, 1 },	
	{ APP_SHOWHORA, 'H', 0, 1 },	
	{ APP_SHOWECLIPSE, 'E', 1, 1 },	
	{ APP_NEW_PARTNER, 'I', 0, 1 },	
	{ APP_SHOWEPHEM, 'E', 0, 1 },	
	{ APP_CONFIGURE, 'C', 1, 1 },	
	{ APP_LOCATION, 'L', 0, 1 },	
	{ APP_ABOUT, WXK_F1, 0, 0 }
};

/*****************************************************
**
**   ShortcutManager   ---   getMenushortcut 
**
******************************************************/
wxString ShortcutManager::getMenushortcut( const int &cmd )
{
	int i;
	wxChar shiftcmd[32], ctrlcmd[32], c;
	wxStrcpy( shiftcmd, wxT( "" ));
	wxStrcpy( ctrlcmd, wxT( "" ));
	wxString s = wxEmptyString;

	for( i = 1; i < SHORTCUT_MAX_CHILD_COMMANDS; i++ ) // i=0 avoided
	{
		if ( cmd == child_commands[i][0] )
		{
			if ( child_commands[i][2] ) wxStrcpy( shiftcmd, wxT( "Shift+" ));
			if ( child_commands[i][3] ) wxStrcpy( ctrlcmd, wxT( "Ctrl+" ));
			c = wxToupper( child_commands[i][1] );
			s << shiftcmd << ctrlcmd << c;
			return s;
		}
	}
	for( i = 0; i < SHORTCUT_MAX_APP_COMMANDS; i++ )
	{
		if ( cmd == app_commands[i][0] )
		{
			if ( app_commands[i][2] ) wxStrcpy( shiftcmd, wxT( "Shift+" ));
			if ( app_commands[i][3] ) wxStrcpy( ctrlcmd, wxT( "Ctrl+" ));
			if ( app_commands[i][1] == WXK_F1 )
				{ s.sprintf( wxT( "%s%s%s" ), shiftcmd, ctrlcmd, wxT( "F1" )); }
			else
			{
				c = wxToupper( app_commands[i][1] );
				s << shiftcmd << ctrlcmd << c;
			}
			return s;
		}
	}
	return s;
}

/*****************************************************
**
**   ShortcutManager   ---   lookupAppWindowKeyEvent 
**
******************************************************/
int ShortcutManager::lookupAppWindowKeyEvent( wxKeyEvent &event )
{
	long keycode = event.GetKeyCode();
	for( int i = 0; i < SHORTCUT_MAX_APP_COMMANDS; i++ )
	{
		if ( keycode == app_commands[i][1] && event.m_controlDown == app_commands[i][3]
			&& event.m_shiftDown == app_commands[i][2] )
		{ return app_commands[i][0]; }
	}
	return false;
}

/*****************************************************
**
**   ShortcutManager   ---   lookupChildWindowKeyEvent 
**
******************************************************/
int ShortcutManager::lookupChildWindowKeyEvent( wxKeyEvent &event )
{
	long keycode = event.GetKeyCode();
	for( int i = 0; i < SHORTCUT_MAX_CHILD_COMMANDS; i++ )
	{
		if ( keycode == child_commands[i][1] && event.m_controlDown == child_commands[i][3]
			&&  event.m_shiftDown == child_commands[i][2] )
		{ return child_commands[i][0]; }
	}
	return false;
}

