/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           SolarView.cpp
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifdef __GNUG__
	#pragma implementation "SolarView.h"
#endif

#include "SolarView.h"

#include <stdio.h>
#include <wx/string.h>

#include <wx/app.h>
#include <wx/sizer.h>
#include <wx/spinctrl.h>
#include <wx/splitter.h>
#include <wx/stattext.h>

#include "ApplicationWindow.h"
#include "Conf.h"
#include "ChildWindow.h"
#include "Document.h"
#include "GraphicView.h"
#include "IconProvider.h"
#include "Lang.h"
#include "MenuProvider.h"
#include "ToolPanel.h"
#include "dialogs/DialogElements.h"

extern Config *config;

IMPLEMENT_CLASS( SolarView, MView )
BEGIN_EVENT_TABLE( SolarView, MView )
	EVT_SPINCTRL( TBS_YEAR, SolarView::OnYearSpin  )
	EVT_MENU( TBB_NOW, SolarView::OnNow )
	EVT_MENU( TBB_NEW, SolarView::OnCreateChart )
END_EVENT_TABLE()

/*****************************************************
**
**   SolarView   ---   Constructor 
**
******************************************************/
SolarView::SolarView( MViewInfo info )
 : MView( info )
{
	supportEWToggle = true;
	th = new TajakaHoroscope( doc->getDataSet() );
	th->update();
	setActualYear();

	int sash = 200;
	wxSize sizet = info.size;
	sizet.x = sash;
	wxSize sizeg = info.size;
	sizeg.x = sizet.x - sash;
	splitter = new MySplitter( this );
	pptext = new PlanetaryPositionTextCtrl( splitter, th, config->preferHtml2Text, -1,
		wxDefaultPosition, sizet );

	gwidget = new GraphicWidget( splitter, th, preferVedic, 0, -1, wxDefaultPosition, sizeg );

	widget =  splitter;
	initToolItems();
	splitter->SplitVertically( pptext, gwidget ); //, ( preferVedic ? 300 : 200 ) );
	if ( preferVedic ) SetSize( 600, 400 );
	else SetSize( 800, 600 );
	OnDataChanged();
}

/*****************************************************
**
**   SolarView   ---   Destructor 
**
******************************************************/
SolarView::~SolarView()
{
	delete th;
}

/*****************************************************
**
**   SolarView   ---   postCreate
**
******************************************************/
void SolarView::postCreate()
{
	wxSplitterWindow *splitter = (wxSplitterWindow*)widget;
	splitter->SetSashPosition( ( preferVedic ? 300 : 200 ) );
}

/*****************************************************
**
**   SolarView   ---   SetContextMenuInfo 
**
******************************************************/
void SolarView::initToolItems()
{
	if ( toolbar )
	{
		wxSpinCtrl *spin_year = (wxSpinCtrl*)toolbar->FindControl( TBS_YEAR );
		if ( spin_year ) spin_year->SetValue( year );
	}
}

/*****************************************************
**
**   SolarView   ---   SetContextMenuInfo 
**
******************************************************/
void SolarView::SetContextMenuInfo( ContextMenuInfo &menuinfo )
{
	menuinfo.graphic = ( preferVedic ? getIStyle() : getWStyle() );
	MView::SetContextMenuInfo( menuinfo );
}

/*****************************************************
**
**   SolarView   ---   setActualYear 
**
******************************************************/
void SolarView::setActualYear()
{
  int bday, aday, bmonth, amonth, byear;
  Formatter::get()->getDateIntsFromJD( JDate().getJD(), aday, amonth, year );
  Formatter::get()->getDateIntsFromJD( doc->getJD(), bday, bmonth, byear );
  if ( amonth < bmonth || ( amonth == bmonth && aday < bday )) year--;
}

/*****************************************************
**
**   SolarView   ---   OnNow 
**
******************************************************/
void SolarView::OnNow( wxCommandEvent &event )
{
  setActualYear();
  OnDataChanged();
	if ( toolbar )
	{	
		wxSpinCtrl *spin_year = (wxSpinCtrl*)toolbar->FindControl( TBS_YEAR );
		if ( spin_year ) spin_year->SetValue( year );
	}
} 

/*****************************************************
**
**   SolarView   ---   OnCreateChart 
**
******************************************************/
void SolarView::OnCreateChart( wxCommandEvent &e )
{
	wxChar tmp[256];
	Document *d = new Document;
	d->setLocation( *doc->getLocation() );
	d->setDate( th->getJD() );
	wxSprintf( tmp, wxT( "%s: %s (%d)" ), doc->getHName(), ( preferVedic ? _( "Tajaka" ) : _( "Solar" )), year );
	d->setHName( tmp );

	wxCommandEvent event( CREATE_ENTRY_CHART, GetParent()->GetId() );
	event.SetEventObject( (wxObject*)d );
	wxPostEvent( GetParent(), event );
}
    
/*****************************************************
**
**   SolarView   ---   OnYearSpin 
**
******************************************************/
void SolarView::OnYearSpin( wxSpinEvent &event )
{
	if ( toolbar )
	{	
		wxSpinCtrl *spin_year = (wxSpinCtrl*)toolbar->FindControl( TBS_YEAR );
		if ( spin_year ) year = spin_year->GetValue();
	}
  OnDataChanged();
}  

/*****************************************************
**
**   SolarView   ---   OnPreferVedic 
**
******************************************************/
void SolarView::OnPreferVedic( bool f )
{
  preferVedic = f;
  gwidget->preferVedic = f;
	pptext->setPreferVedic( f );
	OnDataChanged();
}

/*****************************************************
**
**   SolarView   ---   OnDataChanged 
**
******************************************************/
void SolarView::OnDataChanged()
{
	wxString s;
	Formatter *f = Formatter::get();	
	Location *location = th->getLocation();

	th->calcTajaka( year, preferVedic );
	th->update();
	if ( toolbar )
	{	
		ToolbarLabel *text_return = (ToolbarLabel*)toolbar->FindControl( TBS_TEXT );
		s.Printf( wxT( "%s: %s" ), _( "Return" ),
			f->getFullDateStringFromJD( th->getJD() + ( location->getTimeZone() + location->getDST())/24 ).c_str() );
		if ( text_return ) text_return->SetLabel( s );
	}

	pptext->setPrefix( _( "Solar Chart" ) );
	pptext->dump();
	
	gwidget->Refresh();
}

/*****************************************************
**
**   SolarView   ---   getIStyle 
**
******************************************************/
int SolarView::getIStyle()
{
	return gwidget->getIStyle();
}

/*****************************************************
**
**   SolarView   ---   getWStyle 
**
******************************************************/
int SolarView::getWStyle()
{
	return gwidget->getWStyle();
}

/*****************************************************
**
**   SolarView   ---   dispatchCommand 
**
******************************************************/
bool SolarView::dispatchCommand( const int &command )
{
	wxString st;
  switch( command )
	{
		case CHILD_WSHOWASPECTS:
		case CHILD_WSHOWRETRO:
		case CHILD_WSHOWHOUSES:
		case CHILD_WSHOWURANIAN:
		case CHILD_ISHOWRETRO:
		case CHILD_ISHOWARUDHA:
		case CHILD_ISHOWLAGNAS:
		case CHILD_ISHOWSOUTH:
		case CHILD_ISHOWNORTH:
		case CHILD_ISHOWEAST:
		case CHILD_EXPORT:
			gwidget->dispatchCommand( command );
			pptext->dispatchCommand( command );
		break;
  	case CHILD_SELECT_ALL:
			//pptext->SetSelection( -1, -1 );
		break;
  	case CHILD_COPY:
			//pptext->doCopy();
		break;
		case CHILD_SAVETEXT:
			//pptext->doExport( st );
		break;
		default:
			return MView::dispatchCommand( command );
		break;
	}
	return true;
}

/**************************************************************
***
**   SolarView   ---   getWindowLabel
***
***************************************************************/
const wxChar *SolarView::getWindowLabel( const bool shortname )
{
	if ( preferVedic ) return _( "Tajaka" );
	else return _( "Solar" );
}

/**************************************************************
***
**   ViewFactory   ---   createSolarView
***
***************************************************************/
MView *ViewFactory::createSolarView( MViewInfo info )
{
	return new SolarView( info );
}


