/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           SolarView.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifndef SOLARVIEV_H_
#define SOLARVIEW_H_

#ifdef __GNUG__
	#pragma interface "SolarView.h"
#endif

#include "MView.h"
#include "Base.h"

class ChildWindow;
class ContextMenuInfo;
class Document;
class GraphicWidget;
class PlanetaryPositionTextCtrl;
class TajakaHoroscope;
class wxSpinEvent;

/*****************************************************
**
**   CLASS SolarView  
**
******************************************************/
class SolarView : public MView
{
public:

	SolarView( MViewInfo );
	~SolarView();

	virtual bool dispatchCommand( const int &command );
	virtual void OnPreferVedic( bool f );
	int getIStyle();
	int getWStyle();
	virtual const wxChar *getWindowLabel( const bool shortname = false );
	virtual void postCreate();

protected:

	void SetContextMenuInfo( ContextMenuInfo& );
	void OnDataChanged();
	void setActualYear();
	void OnNow( wxCommandEvent& );
	void OnCreateChart( wxCommandEvent& );
	void OnYearSpin( wxSpinEvent& );
	virtual void initToolItems();

	GraphicWidget *gwidget;
  TajakaHoroscope *th;
  MySplitter *splitter;
	PlanetaryPositionTextCtrl *pptext;
	int year;

private:
	DECLARE_CLASS( SolarView )
	DECLARE_EVENT_TABLE()
};

#endif

