/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           TextView.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifndef _TEXTVIEW_H_
#define _TEXTVIEW_H_

#ifdef __GNUG__
	#pragma interface "TextView.h"
#endif

#include <wx/string.h>

#include "Base.h"
#include "MView.h"

class ChildWindow;
class DataSet;
class wxTextCtrl;
class wxSizeEvent;
class wxSpinEvent;
class Writer;

/*****************************************************
**
**   CLASS TextViewBase  
**
******************************************************/
class TextViewBase : public MView
{
public:
	TextViewBase( MViewInfo );

	virtual void OnPreferVedic( bool f );
	virtual void OnDataChanged();
	virtual bool dispatchCommand( const int &command );
protected:
	virtual void writeContents();
	virtual void write( Writer* ) = 0;
	void SetContextMenuInfo( ContextMenuInfo& );
	void doExport();
	TextWidget *theText;

private:
	DECLARE_CLASS( TextViewBase )
	DECLARE_EVENT_TABLE()
};

/*****************************************************
**
**   CLASS DefaultTextView  
**
******************************************************/
class DefaultTextView : public TextViewBase
{
public:
	DefaultTextView( MViewInfo );
	virtual const wxChar *getWindowLabel( const bool shortname = false );

protected:
	int mode, varga, dasa;
	virtual void OnToolbarCommand();
	virtual void write( Writer* );
	virtual void initToolItems();

private:
	DECLARE_CLASS( DefaultTextView )
	DECLARE_EVENT_TABLE()
};


/*****************************************************
**
**   CLASS MainView  
**
******************************************************/
class MainView : public TextViewBase
{
public:
	MainView( MViewInfo );
	~MainView();
	virtual bool dispatchCommand( const int &command );
	virtual const wxChar *getWindowLabel( const bool shortname = false );

protected:
	virtual void write( Writer* );
  void SetContextMenuInfo( ContextMenuInfo& );
	void toggleSingleStyle( const int &which );

private:
	DECLARE_CLASS( MainView )
	DECLARE_EVENT_TABLE()
};

/*****************************************************
**
**   CLASS EclipseView  
**
******************************************************/
class EclipseView : public TextViewBase
{
public:
  EclipseView( MViewInfo );
  virtual const wxChar *getWindowLabel( const bool shortname = false );

protected:
  virtual void OnToolbarCommand();
  int startyear, years, type;
	virtual void write( Writer* );
	void OnIdle( wxIdleEvent& );
	bool updateView;
	virtual void initToolItems();

private:
  DECLARE_CLASS( EclipseView )
  DECLARE_EVENT_TABLE()
};

/*****************************************************
**
**   CLASS HoraView  
**
******************************************************/
class HoraView : public TextViewBase
{
public:
	HoraView( MViewInfo );
	~HoraView();
	virtual const wxChar *getWindowLabel( const bool shortname = false );

protected:
	virtual void write( Writer* );
	DataSet *dataset;
	void OnNow( wxCommandEvent& );
	void OnDateSpin( wxCommandEvent& );
	double jd;

private:
	DECLARE_CLASS( HoraView )
	DECLARE_EVENT_TABLE()
};


#endif

