/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           ToolPanel.cpp
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifdef __GNUG__
	#pragma implementation "ToolPanel.h"
#endif

#include "ToolPanel.h"

#include <wx/app.h>
#include <wx/log.h>
#include <wx/panel.h>
#include <wx/spinctrl.h>
#include <wx/stattext.h>

#include "Base.h"
#include "IconProvider.h"
#include "dialogs/DialogElements.h"

#include "func.h"
#include "Conf.h"
#include "Dasa.h"
#include "Lang.h"
#include "Session.h"
#include "Varga.h"

DEFINE_EVENT_TYPE( TOOLPANEL_CHANGED )
DEFINE_EVENT_TYPE( TOOLPANEL_CREATEDOC )

extern Config *config;

//#define TB_STYLE iwxTB_FLAT | wxTB_DOCKABLE | wxTB_TEXT
#define TB_STYLE wxTB_FLAT | wxTB_DOCKABLE
/*****************************************************
**
**   MyToolBar   ---   Constructor 
**
******************************************************/
MyToolBar::MyToolBar( wxWindow* parent, wxWindowID id, const wxPoint& pos, const wxSize& size, long style )
 : wxToolBar( parent, id, pos, size, TB_STYLE )
{
  SetToolBitmapSize( wxSize( 24, 24 ));
  //SetMargins( 4, 4 );
  SetMargins( 0, 0 );
  SetToolSeparation( 2 );
  AddTool( APP_FILENEW, IconProvider::getBitmap( BITMAP_NEW ), _( "New File" ) );
  AddTool( APP_FILEOPEN, IconProvider::getBitmap( BITMAP_OPEN ), _( "Open File" ) );
  AddTool( CHILD_SAVE, IconProvider::getBitmap( BITMAP_SAVE ), _( "Save File" ) );
  //AddSeparator();

  AddTool( CHILD_PRINT, IconProvider::getBitmap( BITMAP_PRINT ), _( "Print" ) );
  AddTool( CHILD_EDITDATA, IconProvider::getBitmap( BITMAP_EDIT ), _( "Edit Birth Data" ) );
  AddSeparator();

  AddTool( CHILD_NEW_RASI, IconProvider::getBitmap( BITMAP_CHART ), _( "Rasi Chart (D1)" ) );
  AddTool( CHILD_NEW_RASI+1, IconProvider::getBitmap( BITMAP_CHART9 ), _( "Navamsa Chart (D9)" ) );
  AddTool( CHILD_NEW_TEXT, IconProvider::getBitmap( BITMAP_TEXT ), _( "Text Window" ) );
  AddTool( CHILD_NEW_DASA, IconProvider::getBitmap( BITMAP_DASA ), _( "Dasas in Tree View" ) );
  AddTool( CHILD_NEW_GRAPHICALDASA, IconProvider::getBitmap( BITMAP_GRAPHICALDASA ), _( "Dasas in Graphical View" ));
  AddTool( CHILD_NEW_SBC, IconProvider::getBitmap( BITMAP_SBC ), _( "Sarvatobhadra Chakra (Sbc)" ) );
  AddTool( CHILD_NEW_SOLAR, IconProvider::getBitmap( BITMAP_SOLAR ), _( "Solar/Tajaka Chart" ) );
  //AddSeparator();

  AddTool( CHILD_NEW_WCHART, IconProvider::getBitmap( BITMAP_WCHART ), _( "Western Chart" ) );
  AddTool( CHILD_NEW_MIDPOINT, IconProvider::getBitmap( BITMAP_MIDPOINT ), _( "Midpoint View" ) );
  AddTool( CHILD_NEW_TRANSIT, IconProvider::getBitmap( BITMAP_TRANSIT ), _( "Transit View" ) );
  AddSeparator();

  //AddTool( APP_SHOWHORA, IconProvider::getBitmap( BITMAP_HORA ), _( "Show Hora Window" ) );
  AddTool( APP_NEW_PARTNER, IconProvider::getBitmap( BITMAP_PARTNER ), _( "Partner View" ) );
  AddTool( APP_SHOWEPHEM, IconProvider::getBitmap( BITMAP_EPHEM ), _( "Ephemeris" ) );
  AddTool( APP_LOCATION, IconProvider::getBitmap( BITMAP_WORLD ), _( "Location Database" ) );
  AddTool( APP_CONFIGURE, IconProvider::getBitmap( BITMAP_CONFIG ), _( "Configure Application" ) );
}

/*****************************************************
**
**   MyToolBar   ---   updateTools 
**
******************************************************/
void MyToolBar::updateTools( const bool &isWin, const bool &isDoc, const bool &animated, const int &checkEW )
{
	//wxLogMessage( wxT( "Start MyToolBar::updateTools isWin %d isDoc %d animated %d checkEW %d" ), isWin, isDoc, animated, checkEW );
  EnableTool( CHILD_SAVE, isDoc );
  EnableTool( CHILD_PRINT, isDoc );
  EnableTool( CHILD_EDITDATA, isDoc );
  EnableTool( CHILD_NEW_TEXT, isDoc );
  EnableTool( CHILD_NEW_RASI, isDoc );
  EnableTool( CHILD_NEW_RASI+1, isDoc );
  EnableTool( CHILD_NEW_DASA, isDoc );
  EnableTool( CHILD_NEW_SBC, isDoc );
  EnableTool( CHILD_NEW_SOLAR, isDoc );
  EnableTool( CHILD_NEW_GRAPHICALDASA, isDoc );
  EnableTool( CHILD_NEW_WCHART, isDoc );
  EnableTool( CHILD_NEW_MIDPOINT, isDoc );
  EnableTool( CHILD_NEW_TRANSIT, isDoc );   
	wxLogMessage( wxT( "End MyToolBar::updateTools" ));
}


/*****************************************************
**
**   TOOLBAR DEFINITIONS
**
******************************************************/
const int tb_horawindow[] = { TBB_NOW, TBS_DATE, -1 };
const int tb_textwindow[] = { TBS_TEXTMODE, TBS_VARGA, TBS_DASA, -1 };
const int tb_eclipsewindow[] = { TBS_YEAR, TBS_NBYEARS, TBS_ECL_TYPE, -1 };
const int tb_transitwindow[] = { TBS_DATE, TBS_TIME, TBB_NOW, TB_SEPARATOR, TBS_TRANSITMODE, TBS_YEARLENGTH,
	TBS_ORBIS, TBS_SORT, TBS_CIRCLEDEGREES, -1 };
const int tb_midpointwindow[] = { TBS_MIDPOINTMODE, TBS_SORT, TBS_FILTER, TBS_ORBIS, TBS_CIRCLEDEGREES,
	TBS_YEAR, TBS_YEARLENGTH, -1 };
const int tb_sbcwindow[] = { TBS_SBCTEXT, TBS_SBCMODE, TBS_DATE, TBS_TIME, TBB_NOW, -1 };
const int tb_gdasawindow[] = { TBB_GOTO, TBB_NOW, TBB_DASA, TB_SEPARATOR, TBS_ZOOM, -1 };
const int tb_ephemwindow[] = { TBS_YEAR, TBS_MONTH, TBB_NOW, TB_SEPARATOR, TBS_EPHEMMODE, TBS_EPHEMTZ, TBS_DASA,
	TBS_EPHEMDEG, TBS_EPHEMPLANETS, -1 };
const int tb_solarwindow[] = { TBS_YEAR, TBB_NOW, TBB_NEW, TBS_TEXT, -1 };
const int tb_partnerwindow[] = { TBS_PARTNER1 , TBS_PARTNER2, TBS_ORBIS, TBS_SORT, TBS_FILTER, TBS_CIRCLEDEGREES, -1 };

/*****************************************************
**
**   ToolbarFactory   ---    createToolbar
**
******************************************************/
wxToolBar *ToolbarFactory::createToolbar( wxWindow *parent, const int &type )
{
	toolbar = new wxToolBar( parent, -1, wxDefaultPosition, wxDefaultSize, TB_STYLE );
  toolbar->SetToolBitmapSize( wxSize( 24, 24 ));
  toolbar->SetMargins( 0, 0 );
  toolbar->SetToolSeparation( 0 );
	const int *a = 0;
	switch( type )
	{
		case VIEW_MIDPOINT:
			a = tb_midpointwindow;
		break;
		case VIEW_TRANSIT:
			a = tb_transitwindow;
		break;
		case VIEW_HORA:
			a = tb_horawindow;
		break;
		case VIEW_TEXT:
			a = tb_textwindow;
		break;
		case VIEW_SBC:
			a = tb_sbcwindow;
		break;
		case VIEW_SOLAR:
			a = tb_solarwindow;
		break;
		case VIEW_GRAPHICALDASA:
			a = tb_gdasawindow;
		break;
		case VIEW_ECLIPSE:
			a = tb_eclipsewindow;
		break;
		case VIEW_EPHEM:
			a = tb_ephemwindow;
		break;
		case VIEW_PARTNER:
			a = tb_partnerwindow;
		break;
	}
	if ( a ) create( a );
	else printf( "Warning: no toolbar configuration for id#%d found\n", type );
	toolbar->Realize();
	return toolbar;
}

/*****************************************************
**
**   ToolbarFactory   ---    create
**
******************************************************/
void ToolbarFactory::create( const int *a )
{
	const int *i = a;

	while( *i != -1 )
	{
		if ( *i < TBS_LAST ) createChoiceItem( *i );
		else if ( *i == TB_SEPARATOR ) toolbar->AddSeparator();
		else createButtonItem( *i );
		i++;
	}
}

/*****************************************************
**
**   ToolbarFactory   ---    createChoiceItem
**
******************************************************/
void ToolbarFactory::createChoiceItem( const int item )
{
const wxString text_viewmodes[] = { _("Base Data"), _("Vedic"), _("Western"), _("Nakshatra"), _("Varga"),
	_("Aspects"), _("Ashtaka Varga"), _("KP"), _("Jaimini"), _("Dasa (Short)"), _("Dasa (Long)"),
	_("Bhava"), _("Astronomical") };
const wxString eclipse_types[] = { _("All"), _("Solar"), _("Lunar") };
const wxString midpoint_viewmodes[] = { _("Radix"), _("Chains"), _("Chains (2)"), _("Yearly Preview") };
const wxString sbctext_choices[] = { _("Positions"), _("Afflictions") };
const wxString sbcmode_choices[] = { _("Birth Chart"), _("Gochara") };
const wxString zoom_choices[] = { wxT("10%"), wxT("25%"), wxT("50%"), wxT("100%"), wxT("150%"), wxT("200%"),
	wxT("250%") };
const wxString ephem_mode_choices[] = { _("Default"), _("Graphical"), _("Details"), _("Ingress"),
	_( "Lunar" ), _("KP") };
const wxString ephemtz_choices[] = { _("UT"), _("Local") };
const wxString ephemdeg_choices[] = { wxT("360"), wxT("180"), wxT("90"), wxT("45"), wxT("30"), wxT("22:30"),
		wxT("13:20"), wxT("11:15"), wxT("5:07:30") };
const wxString ephem_planets_choices[] = { _("All"), _("Minor"), _("Major") };

	wxChoice *choice = 0;
	wxControl *control = 0;
	int i;
	wxChar tmp[256];
	VargaExpert vexpert;
	Session *session = Session::get();
	switch( item )
	{
		case TBS_TEXTMODE:
			choice = new wxChoice( toolbar, item, wxDefaultPosition, wxDefaultSize, 13, text_viewmodes, 0);
			choice->SetToolTip( _( "Mode" ));
		break;
		case TBS_VARGA:
			choice = new wxChoice( toolbar, item, wxDefaultPosition, wxSize( 150, 25 ));
			for( i = 0; i < vexpert.getNbVargas(); i++ )
			{
				if ( vexpert.getVargaDivision(i) > 0 )
					wxSprintf( tmp, wxT( "%s (D%d)" ), vexpert.getVargaName(i), vexpert.getVargaDivision(i) );
				else wxStrcpy( tmp, vexpert.getVargaName(i) );
				choice->Append( tmp );
			}
			choice->SetToolTip( _( "Varga" ));
		break;
		case TBS_DASA:
			choice = new wxChoice( toolbar, item, wxDefaultPosition, wxSize( 150, 25 ));
			for( i = 0; i < session->getNoOfDasaExperts(); i++ ) choice->Append( session->getDasaExpert(i)->getName() );
			choice->SetToolTip( _( "Dasa" ));
		break;
		case TBS_YEAR:
			control = new wxSpinCtrl( toolbar, item, wxT(""), wxDefaultPosition, wxDefaultSize,
				wxSP_ARROW_KEYS, 0, 10000);
			control->SetToolTip( _( "Year" ));
		break;
		case TBS_NBYEARS:
			control = new wxSpinCtrl( toolbar, item, wxT(""), wxDefaultPosition, wxDefaultSize,
				wxSP_ARROW_KEYS, 1, 10);
			control->SetToolTip( _( "Number of Years" ));
		break;
		case TBS_ECL_TYPE:
			control = new wxChoice( toolbar, item, wxDefaultPosition, wxDefaultSize, 3, eclipse_types, 0);
			control->SetToolTip( _( "Type" ));
		break;
		case TBS_DATE:
#ifdef __WXMSW__
			control = new DateSpin( toolbar, item, 0, wxDefaultPosition, wxSize( 150, 32 ));
#else
			control = new DateSpin( toolbar, item, 0, wxDefaultPosition, wxSize( 150, 38 ));
#endif
		break;
		case TBS_TIME:
#ifdef __WXMSW__
			control = new TimeSpin( toolbar, item, 0, wxDefaultPosition, wxSize( 100, 24 ));
#else
			control = new TimeSpin( toolbar, item, 0, wxDefaultPosition, wxSize( 100, 30 ));
#endif
		break;
		case TBS_TRANSITMODE:
			control = new TransitModeChoice( toolbar, item );
		break;
		case TBS_YEARLENGTH:
			control = new YearLengthChoice( toolbar, item, false );
		break;
		case TBS_ORBIS:
			control = new wxSpinCtrl( toolbar, item, wxT(""), wxDefaultPosition, wxDefaultSize,
				wxSP_ARROW_KEYS, 0, 150);
			control->SetToolTip( _( "Orbis" ));
		break;
		case TBS_CIRCLEDEGREES:
			control = new CircleDegreeChoice( toolbar, item );
		break;
		case TBS_SORT:
			control = new SortChoice( toolbar, item );
		break;
		case TBS_FILTER:
			control =  new FilterChoice( toolbar, item, config->hsSystem );
		break;
		case TBS_MIDPOINTMODE:
			choice = new wxChoice( toolbar, item, wxDefaultPosition, wxDefaultSize, 4, midpoint_viewmodes, 0);
			choice->SetSelection( 0 );
			choice->SetToolTip( _( "Mode" ));
		break;
		case TBS_SBCMODE:
			control =  new wxChoice( toolbar, item, wxDefaultPosition, wxDefaultSize, 2, sbcmode_choices, 0);
			control->SetToolTip( _( "Mode" ));
		break;
		case TBS_SBCTEXT:
			choice =  new wxChoice( toolbar, item, wxDefaultPosition, wxDefaultSize, 2, sbctext_choices, 0);
			choice->SetToolTip( _( "Type of Text Output" ));
		break;
		case TBS_ZOOM:
			choice = new wxChoice( toolbar, item, wxDefaultPosition, wxDefaultSize, 7, zoom_choices, 0);
			choice->SetToolTip( _( "Zoom" ));
		break;
		case TBS_MONTH:
			control =  new wxSpinCtrl( toolbar, item, wxT(""), wxDefaultPosition, wxDefaultSize,
				wxSP_ARROW_KEYS|wxSP_WRAP, 1, 12 );
			control->SetToolTip( _( "Month" ));
		break;
		case TBS_EPHEMMODE:
			choice = new wxChoice( toolbar, item, wxDefaultPosition, wxSize( 120, 24 ), 6, ephem_mode_choices, 0);
			choice->SetToolTip( _( "Mode" ));
		break;
		case TBS_EPHEMTZ:
			choice = new wxChoice( toolbar, item, wxDefaultPosition, wxSize( 120, 24 ), 2, ephemtz_choices, 0);
			choice->SetToolTip( _( "Time Zone" ));
		break;
		case TBS_EPHEMDEG:
			choice = new wxChoice( toolbar, item, wxDefaultPosition, wxSize( 120, 24 ), 9, ephemdeg_choices, 0);
			choice->SetToolTip( _( "Degrees of the Circle" ));
		break;
		case TBS_EPHEMPLANETS:
			choice = new wxChoice( toolbar, item, wxDefaultPosition, wxSize( 120, 24 ), 3,
				ephem_planets_choices, wxADJUST_MINSIZE );
			choice->SetToolTip( _( "Filter for Planets" ));
		break;
		case TBS_TEXT:
			control = (wxControl*) new ToolbarLabel( toolbar, item, wxDefaultPosition, wxSize( 250, 28 ),
				_( "Date of Return" ) );
		break;
		case TBS_PARTNER1:
			choice = new wxChoice( toolbar, item, wxDefaultPosition, wxSize( 150, 20 ));
			choice->SetToolTip( _( "Partner 1" ));
		break;
		case TBS_PARTNER2:
			choice = new wxChoice( toolbar, item, wxDefaultPosition, wxSize( 150, 20 ));
			choice->SetToolTip( _( "Partner 2" ));
		break;
		default:
			assert( 0 );
		break;
	}
	assert( choice || control );
	if ( choice )
	{
		choice->SetSelection( 0 );
		toolbar->AddControl( choice );
	}
	else toolbar->AddControl( control );
}

/*****************************************************
**
**   ToolbarFactory   ---    createButtonItem
**
******************************************************/
void ToolbarFactory::createButtonItem( const int item )
{
	IconProvider p;
	switch( item )
	{
		case TBB_NOW:
			toolbar->AddTool( item, _("Now"), p.getBitmap( BITMAP_NOW ), _T("Set Current Date") );
		break;
		case TBB_DASA:
			toolbar->AddTool( item, _("Dasas"), p.getBitmap( BITMAP_DASA ), _T("Select Dasas") );
		break;
		case TBB_GOTO:
			toolbar->AddTool( item, _("Year"), p.getBitmap( BITMAP_GOTO ), _T("Goto Year") );
		break;
		case TBB_NEW:
			toolbar->AddTool( item, _("New"), p.getBitmap( BITMAP_NEW ), _T("Create Document") );
		break;
		default:
			assert( 0 );
		break;
	}
}

