/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           ToolPanel.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifndef _TOOLPANEL_H_
#define _TOOLPANEL_H_

#ifdef __GNUG__
	#pragma interface "ToolPanel.h"
#endif

#include <wx/toolbar.h>

class DataSet;
class Document;
class wxWindow;

enum { TBS_TEXTMODE = wxID_HIGHEST + 10000, TBS_VARGA, TBS_DASA,
	TBS_PARTNER1 , TBS_PARTNER2, TBS_DATE, TBS_TIME, TBS_CIRCLEDEGREES, TBS_YEARLENGTH,
	TBS_YEAR, TBS_NBYEARS, TBS_ECL_TYPE, TBS_TRANSITMODE, TBS_ORBIS, TBS_SORT, TBS_FILTER,
	TBS_MIDPOINTMODE, TBS_ZOOM, TBS_SBCMODE, TBS_SBCTEXT, TBS_TEXT,
	TBS_MONTH, TBS_EPHEMMODE, TBS_EPHEMTZ, TBS_EPHEMDEG, TBS_EPHEMPLANETS,
	TBS_LAST
};

enum { TB_SEPARATOR = wxID_HIGHEST + 10999 };
enum { TBB_NOW = wxID_HIGHEST + 11000, TBB_DASA, TBB_GOTO, TBB_NEW };

/*****************************************************
**
**   CLASS MyToolBar  
**
******************************************************/
class MyToolBar : public wxToolBar
{
public:
	MyToolBar( wxWindow* parent, wxWindowID id, const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxDefaultSize,
		long style = wxTB_HORIZONTAL | wxNO_BORDER );
	void updateTools( const bool &isWin, const bool &isDoc, const bool &animated, const int &checkEW );

private:

};

/*****************************************************
**
**   CLASS ToolbarFactory
**
******************************************************/
class ToolbarFactory
{
public:
	wxToolBar *createToolbar( wxWindow*, const int &type );

private:
	wxToolBar *toolbar;
	void create( const int* );
	void createChoiceItem( const int );
	void createButtonItem( const int );
};

#endif


