/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           VedicGraphic.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifndef VEDICGRAPHIC_H_
#define VEDICGRAPHIC_H_

#ifdef __GNUG__
	#pragma interface "VedicGraphic.h"
#endif

#include <wx/gdicmn.h>
#include <wx/string.h>
#include <vector>

using namespace std;

class Horoscope;
class Painter;

/***********************************************
***
**    CLASS   ---   rasi_cont
***
***********************************************/
struct rasi_cont
{
	rasi_cont( int r, wxString ln, wxString sn ) { rasi = r; long_name = ln; short_name = sn; }
	int rasi;
	wxString long_name;
	wxString short_name;
};

/*****************************************************
**
**   CLASS VedicGraphic  
**
******************************************************/
class VedicGraphic
{
public:

	VedicGraphic( Painter* );
	void paint( Horoscope*, int style, int division, int x0, int y0, int xmax, int ymax );
	void paint( Horoscope*, const int &style, const int &division, const wxRect& );

private:

	wxString content[12];

	void paintSouth( const wxRect& );
	void paintNorth( const wxRect& );
	void paintEast( const wxRect& );
	void getInternalVargaString( wxString &s );
  Horoscope *horoscope;
	vector<rasi_cont> rs;
	Painter *painter;
	int division;
	int style;
	void drawRasiText( const wxRect &rect, const int &r, const int& align );
	void drawRasiText( const double &x, const double &y, const double &w, const double &h,
		const int &r, const int& align );
	void writeContent( int = 0, bool writeAs = true );
};


#endif

