/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           WesternGraphic.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifndef WESTERNGRAPHIC_H_
#define WESTERNGRAPHIC_H_

#ifdef __GNUG__
	#pragma interface "WesternGraphic.h"
#endif

class wxDC;
class Painter;
class wxRect;
class wxString;
class PseudoHoroscope;

/*****************************************************
**
**   CLASS WesternGraphic  
**
******************************************************/
class WesternGraphic
{
public:
	WesternGraphic( Painter* );
	void paint( PseudoHoroscope*, const wxRect&, const int& );
private:

	void paintWestern( const wxRect& );
	void paintSymLine( const double &a, const double &rmin, const double &rmax );
	void paintArrow( const double &a, const double &rmax );

	double getRelativeLength(const int &pl );
	void getXYValues( double &x, double &y, const int &planet );
	double getPRadius( const int &planet );

	void paintDummies();
	void paintSun();
	void paintMoon();
	void paintMercury();
	void paintVenus();
	void paintMars();
	void paintJupiter();
	void paintSaturn();
	void paintUranus();
	void paintNeptune();
	void paintPluto();
	void paintNNode();
	void paintSNode();
	void paintCupido();
	void paintHades();
	void paintZeus();
	void paintKronos();
	void paintApollon();
	void paintVulkanus();
	void paintAdmetos();
	void paintPoseidon();

	void paintAspects();
	void paintSingleAspect( const double &len1, const double &len2, const int &type );
	void paintHouses();
	void showRetro();

  PseudoHoroscope *doc;
	int style;
	Painter *painter;
	double xmitte, ymitte, psize;
	double r0, r1, r2, r3, r4, r5, rp, r6, r7, rh1, rh2, aries;
};

#endif

