/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           AboutDialog.cpp
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifdef __GNUG__
	#pragma implementation "AboutDialog.h"
#endif

#include "AboutDialog.h"

#include <wx/button.h>
#include <wx/clipbrd.h>
#include <wx/dataobj.h>
#include <wx/dc.h>
#include <wx/dcclient.h>
#include <wx/filename.h>
#include <wx/image.h>
#include <wx/panel.h>
#include <wx/settings.h>
#include <wx/sizer.h>
#include <wx/statbox.h>
#include <wx/statline.h>
#include <wx/stattext.h>
#include <wx/textfile.h>
#include <wx/timer.h>

#include "func.h"
#include "HtmlWriter.h"
#include "Session.h"

#include "Base.h"
#include "IconProvider.h"

enum { ABOUT_TIMER = wxID_HIGHEST + 1 };

IMPLEMENT_CLASS( LogoWidget, wxWindow )
BEGIN_EVENT_TABLE( LogoWidget, wxWindow )
  EVT_PAINT( LogoWidget::OnPaint )
	EVT_TIMER( ABOUT_TIMER, LogoWidget::OnTimer )
END_EVENT_TABLE()

IMPLEMENT_CLASS( AboutDialog, wxDialog )
BEGIN_EVENT_TABLE( AboutDialog, wxDialog )
	EVT_BUTTON( wxID_OK, wxDialog::OnOK )
END_EVENT_TABLE()


/*****************************************************
**
**   LogoWidget   ---   Constructor 
**
******************************************************/
LogoWidget::LogoWidget( wxWindow *parent, int id )
 : wxWindow( parent, id )
{
	wxString s;
	Session *session = Session::get();
	s = session->getPicDir();
	if ( s.Last() != wxFileName::GetPathSeparator()) s << wxFileName::GetPathSeparator();
	s << wxT( "logo.jpg" );
	bitmap = new wxBitmap( s, wxBITMAP_TYPE_JPEG );
	xzoom = yzoom = 100;
	ani_mode = 0;
	ani_direction = 0;

	timer = new wxTimer( this, ABOUT_TIMER );
	timer->Start( 6000 );
}

/*****************************************************
**
**   LogoWidget   ---   Destructor 
**
******************************************************/
LogoWidget::~LogoWidget()
{
	timer->Stop();
	delete timer;
	delete bitmap;
}

/*****************************************************
**
**   LogoWidget   ---   doAnimation 
**
******************************************************/
void LogoWidget::doAnimation()
{
	if ( ! timer->IsRunning() ) timer->Start( 100 );
	else timer->Stop();
}

/*****************************************************
**
**   LogoWidget   ---   OnTimer 
**
******************************************************/
void LogoWidget::OnTimer( wxTimerEvent &event )
{
	if ( xzoom == 100 && yzoom == 100 ) timer->Start( 100 );
  if ( ani_direction == 0 )
  {
    if ( ani_mode == 0 ) xzoom -= 10;
    else yzoom -= 10;
    if ( xzoom <= -100 || yzoom <= -100 ) ani_direction = 1;
  }
  else
  {
    if ( ani_mode == 0 ) xzoom += 10;
    else yzoom += 10;
    if ( xzoom >= 100 && yzoom >= 100 )
    {
      ani_direction = 0;
      ani_mode = ! ani_mode;
      timer->Start( 12000 );
    }
  }
	Refresh( false );
}

/*****************************************************
**
**   LogoWidget   ---   OnPaint 
**
******************************************************/
void LogoWidget::OnPaint(wxPaintEvent& event)
{
  const int xmax = 400;
  const int ymax = 120;
  double axzoom = ( xzoom > 0 ? xzoom : -xzoom );
  double ayzoom = ( yzoom > 0 ? yzoom : -yzoom );
  int x = (int)(xmax * axzoom / 100);
  int xborder = (int)(( xmax - x ) / 2);
  int y = (int)(ymax * ayzoom / 100);
  int yborder = (int)(( ymax - y ) / 2);
  bool mirror = ( xzoom == 100 ? false : true );

  wxPaintDC dc(this);
  wxColour bgcolor = wxSystemSettings::GetColour( wxSYS_COLOUR_BACKGROUND );
  dc.SetBrush( wxBrush( GetBackgroundColour(), wxSOLID ));
  dc.SetPen( wxPen( bgcolor, 1, wxSOLID ));
  dc.DrawRectangle( -1, -1, xborder, ymax+2 ); // left
  dc.DrawRectangle( xmax - xborder, -1, xmax/2+2, ymax+2 ); // right
  dc.DrawRectangle( -1, -1, xmax+2, yborder ); // upper
  dc.DrawRectangle( -1, ymax - yborder, xmax+2, ymax/2+2 ); // lower
  if ( xzoom == 100 && yzoom == 100 )
    { dc.DrawBitmap( *bitmap, xborder, yborder, true ); }
  else if ( xzoom >= 0 && yzoom >= 0 )
    { dc.DrawBitmap( wxBitmap( bitmap->ConvertToImage().Scale( x, y )), xborder, yborder, true ); }
  else
    { dc.DrawBitmap( wxBitmap( bitmap->ConvertToImage().Mirror( mirror ).Scale( x, y )), xborder, yborder, true ); }
}

/*****************************************************
**
**   AboutDialog   ---   Constructor 
**
******************************************************/
AboutDialog::AboutDialog(wxWindow* parent )
 : wxDialog( parent, -1, wxT( "" ), wxDefaultPosition, wxDefaultSize, DEFAULT_DIALOG_STYLE )
{
    // begin wxGlade: AboutDialog::AboutDialog
    notebook = new wxNotebook(this, -1, wxDefaultPosition, wxDefaultSize, 0);
    notebook_pane_license = new wxPanel(notebook, -1, wxDefaultPosition, wxDefaultSize, wxSUNKEN_BORDER|wxTAB_TRAVERSAL);
    notebook_pane_credits = new wxPanel(notebook, -1, wxDefaultPosition, wxDefaultSize, wxSUNKEN_BORDER|wxTAB_TRAVERSAL);
    notebook_pane_about = new wxPanel(notebook, -1, wxDefaultPosition, wxDefaultSize, wxSUNKEN_BORDER|wxTAB_TRAVERSAL);
    sizer_info_staticbox = new wxStaticBox(notebook_pane_about, -1, _("Author"));
    sizer_software_staticbox = new wxStaticBox(notebook_pane_about, -1, _("Software"));
    panel_logo = new wxPanel(this, -1, wxDefaultPosition, wxDefaultSize, wxSUNKEN_BORDER|wxTAB_TRAVERSAL);
    widget = new LogoWidget(panel_logo, -1);
    label_author = new wxStaticText(notebook_pane_about, -1, _("Author"));
    label_url = new wxStaticText(notebook_pane_about, -1, _("Url"));
    label_version = new wxStaticText(notebook_pane_about, -1, _("Version"));
    label_builddate = new wxStaticText(notebook_pane_about, -1, _("Build Date"));
    label_toolkit = new wxStaticText(notebook_pane_about, -1, _("Gui Toolkit"));
    label_unicode = new wxStaticText(notebook_pane_about, -1, _("Unicode Mode"));
    label_os = new wxStaticText(notebook_pane_about, -1, _("OS"));
    text_credits = new TextWidget(notebook_pane_credits, true);
    text_license = new TextWidget(notebook_pane_license, false);
    button_ok = new wxButton(this, wxID_OK, _("OK"));

    set_properties();
    do_layout();
    // end wxGlade
	moveWindow2Center( this );
	SetIcon( IconProvider::getIcon( BITMAP_INFO ));
}

/*****************************************************
**
**   AboutDialog   ---   ProcessEvent 
**
******************************************************/
bool AboutDialog::ProcessEvent(wxEvent& event)
{
	if ( event.GetClassInfo()->IsKindOf( CLASSINFO( wxKeyEvent )))
	{
		if ( ((wxKeyEvent*)&event)->GetKeyCode() == WXK_ESCAPE )
		{
			EndModal( wxID_CANCEL );
			return true;
		}
		else return wxDialog::ProcessEvent( event );
	}
	else return wxDialog::ProcessEvent( event );
}

/*****************************************************
**
**   AboutDialog   ---   set_properties 
**
******************************************************/
void AboutDialog::set_properties()
{
	Session *session = Session::get();
	wxString s;

	label_author->SetLabel( AUTHOR );
  label_url->SetLabel( URL );

	s.sprintf( wxT( "%s: %s" ), _( "Version" ), session->getVersion().c_str() );
	label_version->SetLabel( s );

	s.sprintf( wxT( "%s: %s" ), _( "Build Date" ), wxT( __DATE__ ) );
	label_builddate->SetLabel( s );

	s.sprintf( wxT( "%s: %s" ), _( "Gui Toolkit" ), wxVERSION_STRING );
	label_toolkit->SetLabel( s );

#if wxUSE_UNICODE
	const wxChar *s1 = _( "enabled" );
#else
	const wxChar *s1 = _( "disabled" );
#endif
	s.sprintf( wxT( "%s: %s" ), _( "Unicode Mode" ), s1 );
	label_unicode->SetLabel( s );

	s.sprintf( _( "Running on %s" ), wxGetOsDescription().c_str() );
	label_os->SetLabel( s );

	wxString filename = Session::get()->getBinDir();
	if ( filename.Last() != wxFileName::GetPathSeparator() ) filename << wxFileName::GetPathSeparator();
#ifdef __WXMSW__
	filename << wxT( "Copying.txt" );
#else
	filename << wxT( "COPYING" );
#endif
	if ( ! wxFile::Access( filename, wxFile::read )) filename = wxT( "../COPYING" );
	wxTextFile file( filename );
	if ( ! file.Open()) { s = wxT( "License file not found." ); }
	else
	{
		s.Clear();
		while( ! file.Eof()) { s << file.GetNextLine() << LINE_FEED; }
		file.Close();
	}
	text_license->setContents( s );
	HtmlWriter writer;
	writer.writeCredits();
	text_credits->setContents( writer.getContents());

    // begin wxGlade: AboutDialog::set_properties
    SetTitle(_("About"));
    widget->SetMinSize(wxSize(400, 120));
    label_author->SetMinSize(wxSize(350, 16));
    label_version->SetMinSize(wxSize(300, 16));
    label_builddate->SetMinSize(wxSize(300, 16));
    label_toolkit->SetMinSize(wxSize(300, 16));
    label_unicode->SetMinSize(wxSize(300, 16));
    label_os->SetMinSize(wxSize(300, 16));
    button_ok->SetDefault();
    // end wxGlade
}


/*****************************************************
**
**   AboutDialog   ---   do_layout 
**
******************************************************/
void AboutDialog::do_layout()
{
    // begin wxGlade: AboutDialog::do_layout
    wxFlexGridSizer* sizer_about = new wxFlexGridSizer(4, 1, 0, 0);
    wxBoxSizer* sizer_pane_license = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_pane_credits = new wxBoxSizer(wxHORIZONTAL);
    wxFlexGridSizer* sizer_pane_about = new wxFlexGridSizer(2, 1, 0, 0);
    wxStaticBoxSizer* sizer_software = new wxStaticBoxSizer(sizer_software_staticbox, wxVERTICAL);
    wxStaticBoxSizer* sizer_info = new wxStaticBoxSizer(sizer_info_staticbox, wxVERTICAL);
    wxBoxSizer* sizer_logo = new wxBoxSizer(wxHORIZONTAL);
    sizer_logo->Add(widget, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 5);
    panel_logo->SetAutoLayout(true);
    panel_logo->SetSizer(sizer_logo);
    sizer_logo->Fit(panel_logo);
    sizer_logo->SetSizeHints(panel_logo);
    sizer_about->Add(panel_logo, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 3);
    sizer_info->Add(label_author, 0, wxALL|wxEXPAND|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    sizer_info->Add(label_url, 0, wxALL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    sizer_pane_about->Add(sizer_info, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 3);
    sizer_software->Add(label_version, 0, wxALL|wxEXPAND|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    sizer_software->Add(label_builddate, 0, wxALL|wxEXPAND|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    sizer_software->Add(label_toolkit, 0, wxALL|wxEXPAND|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    sizer_software->Add(label_unicode, 0, wxALL|wxEXPAND|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    sizer_software->Add(label_os, 0, wxALL|wxEXPAND|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    sizer_pane_about->Add(sizer_software, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL, 3);
    notebook_pane_about->SetAutoLayout(true);
    notebook_pane_about->SetSizer(sizer_pane_about);
    sizer_pane_about->Fit(notebook_pane_about);
    sizer_pane_about->SetSizeHints(notebook_pane_about);
    sizer_pane_about->AddGrowableCol(0);
    sizer_pane_credits->Add(text_credits, 1, wxALL|wxEXPAND, 3);
    notebook_pane_credits->SetAutoLayout(true);
    notebook_pane_credits->SetSizer(sizer_pane_credits);
    sizer_pane_credits->Fit(notebook_pane_credits);
    sizer_pane_credits->SetSizeHints(notebook_pane_credits);
    sizer_pane_license->Add(text_license, 1, wxEXPAND, 0);
    notebook_pane_license->SetAutoLayout(true);
    notebook_pane_license->SetSizer(sizer_pane_license);
    sizer_pane_license->Fit(notebook_pane_license);
    sizer_pane_license->SetSizeHints(notebook_pane_license);
    notebook->AddPage(notebook_pane_about, _("About"));
    notebook->AddPage(notebook_pane_credits, _("Credits"));
    notebook->AddPage(notebook_pane_license, _("License"));
    sizer_about->Add(notebook, 1, wxALL|wxEXPAND, 3);
    sizer_about->Add(button_ok, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 3);
    SetAutoLayout(true);
    SetSizer(sizer_about);
    sizer_about->Fit(this);
    sizer_about->SetSizeHints(this);
    sizer_about->AddGrowableCol(0);
    Layout();
    // end wxGlade
}

