/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           AboutDialog.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/


#ifndef ABOUTDIALOG_H
#define ABOUTDIALOG_H

#ifdef __GNUG__
	#pragma interface "AboutDialog.h"
#endif

// begin wxGlade: dependencies
// end wxGlade

#include <wx/dialog.h>

class TextWidget;
class wxButton;
class wxNotebook;
class wxPanel;
class wxStaticBox;
class wxStaticLine;
class wxStaticText;
class wxTimer;
class wxTimerEvent;

/*****************************************************
**
**   CLASS LogoWidget  
**
******************************************************/
class LogoWidget : public wxWindow
{
	DECLARE_CLASS( LogoWidget )
public:
	LogoWidget( wxWindow *parent, int id );
	~LogoWidget();
	void doAnimation();
	DECLARE_EVENT_TABLE()

protected:
	void OnPaint(wxPaintEvent& event);
	void OnTimer( wxTimerEvent& );
	wxBitmap *bitmap;
	int xzoom, yzoom, ani_mode, ani_direction;
	wxTimer *timer;
};

/*****************************************************
**
**   CLASS AboutDialog  
**
******************************************************/
class AboutDialog: public wxDialog
{
public:
    // begin wxGlade: AboutDialog::ids
    // end wxGlade

    AboutDialog(wxWindow* parent );

private:
    // begin wxGlade: AboutDialog::methods
    void set_properties();
    void do_layout();
    // end wxGlade
	virtual bool ProcessEvent(wxEvent& );
	DECLARE_CLASS( AboutDialog )
	DECLARE_EVENT_TABLE()

protected:
    // begin wxGlade: AboutDialog::attributes
    wxStaticBox* sizer_software_staticbox;
    wxStaticBox* sizer_info_staticbox;
    LogoWidget* widget;
    wxPanel* panel_logo;
    wxStaticText* label_author;
    wxStaticText* label_url;
    wxStaticText* label_version;
    wxStaticText* label_builddate;
    wxStaticText* label_toolkit;
    wxStaticText* label_unicode;
    wxStaticText* label_os;
    wxPanel* notebook_pane_about;
    TextWidget* text_credits;
    wxPanel* notebook_pane_credits;
    TextWidget* text_license;
    wxPanel* notebook_pane_license;
    wxNotebook* notebook;
    wxButton* button_ok;
    // end wxGlade
};


#endif // ABOUTDIALOG_H
