/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           ConfAppearancePanel.cpp
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifdef __GNUG__
	#pragma implementation "ConfAppearancePanel.h"
#endif

#include "ConfAppearancePanel.h"

#include "Base.h"
#include "func.h"
#include "ColorProvider.h"
#include "Conf.h"
#include "FontProvider.h"
#include "PrintoutManager.h"

#include <wx/button.h>
#include <wx/checkbox.h>
#include <wx/choice.h>
#include <wx/colordlg.h>
#include <wx/filedlg.h>
#include <wx/font.h>
#include <wx/fontdlg.h>
#include <wx/sizer.h>
#include <wx/spinctrl.h>
#include <wx/statbox.h>
#include <wx/statline.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>

extern Config *config;
enum { CD_CHOOSE_FONT = wxID_HIGHEST + 1, CA_COLOR, CA_COLOR_CHOOSE,
	CD_CHOICE_PRINTOUT, CD_ANIMATIONMODE, CD_FONT_SELECT, CD_COMMAND, CD_SWITCH_VIEWERMODE };

IMPLEMENT_CLASS( ConfAppearancePanel, wxPanel )
BEGIN_EVENT_TABLE( ConfAppearancePanel, wxPanel )
	EVT_CHOICE( CD_CHOICE_PRINTOUT, ConfAppearancePanel::OnPrintoutChoice )
	EVT_CHOICE( CD_FONT_SELECT, ConfAppearancePanel::OnSelectFont )
	EVT_BUTTON( CD_CHOOSE_FONT, ConfAppearancePanel::OnChooseFont )
	EVT_BUTTON( CA_COLOR_CHOOSE, ConfAppearancePanel::OnSetColor )
	EVT_BUTTON( CD_COMMAND, ConfAppearancePanel::OnChooseCommand )
  EVT_CHOICE( CD_ANIMATIONMODE, ConfAppearancePanel::OnAnimationModeChoice )
	EVT_CHOICE( CA_COLOR, ConfAppearancePanel::OnColorChoice )
	EVT_CHECKBOX( CD_SWITCH_VIEWERMODE, ConfAppearancePanel::OnSwitchViewerMode )
END_EVENT_TABLE()

/*****************************************************
**
**   ConfAppearancePanel   ---   Constructor 
**
******************************************************/
ConfAppearancePanel::ConfAppearancePanel(wxWindow* parent, int id, const wxPoint& pos, const wxSize& size, long style):
    wxPanel(parent, id, pos, size, wxTAB_TRAVERSAL)
{
    // begin wxGlade: ConfAppearancePanel::ConfAppearancePanel
    sizer_fontconfig_staticbox = new wxStaticBox(this, -1, _("Fonts"));
    sizer_signs_staticbox = new wxStaticBox(this, -1, _("Presentation of Positions and Signs"));
    sizer_animate_staticbox = new wxStaticBox(this, -1, _("Animation"));
    sizer_printout_staticbox = new wxStaticBox(this, -1, _("Printout"));
    sizer_colors_staticbox = new wxStaticBox(this, -1, _("Colors"));
    label_title = new wxStaticText(this, -1, _("Appearance"), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE);
    static_line_top = new wxStaticLine(this, -1);
    const wxString choice_colors_choices[] = {
        _("Background Default"),
        _("Background (Secondary)"),
        _("Text/Foreground"),
        _("Text (Secondary)"),
        _("Marked Fields"),
        _("Benefics"),
        _("Malefics")
    };
    choice_colors = new wxChoice(this, CA_COLOR, wxDefaultPosition, wxDefaultSize, 7, choice_colors_choices, 0);
    button_color_choose = new wxButton(this, CA_COLOR_CHOOSE, _("Choose ..."));
    panel_color = new wxPanel(this, -1, wxDefaultPosition, wxDefaultSize, wxRAISED_BORDER|wxTAB_TRAVERSAL);
    const wxString choice_fontselect_choices[] = {
        _("Default"),
        _("Header"),
        _("Graphic"),
        _("Text")
    };
    choice_fontselect = new wxChoice(this, CD_FONT_SELECT, wxDefaultPosition, wxDefaultSize, 4, choice_fontselect_choices, 0);
    button_choose_font = new wxButton(this, CD_CHOOSE_FONT, _("Choose ..."));
    text_font = new wxTextCtrl(this, -1, wxT(""), wxDefaultPosition, wxDefaultSize, wxTE_MULTILINE|wxTE_READONLY);
    label_name_length = new wxStaticText(this, -1, _("Sign Names"));
    const wxString choice_sign_length_choices[] = {
        _("Short"),
        _("Medium"),
        _("Large")
    };
    choice_sign_length = new wxChoice(this, -1, wxDefaultPosition, wxDefaultSize, 3, choice_sign_length_choices, 0);
    label_positions = new wxStaticText(this, -1, _("Planetary Positions"));
    const wxString choice_positions_choices[] = {
        _("Western (eg 10-20 Ge)"),
        _("Vedic (eg 02-10-20)")
    };
    choice_positions = new wxChoice(this, -1, wxDefaultPosition, wxDefaultSize, 2, choice_positions_choices, 0);
    label_animation_mode = new wxStaticText(this, -1, _("Mode"));
    const wxString choice_animation_mode_choices[] = {
        _("System Time"),
        _("Custom Steps")
    };
    choice_animation_mode = new wxChoice(this, CD_ANIMATIONMODE, wxDefaultPosition, wxDefaultSize, 2, choice_animation_mode_choices, 0);
    label_animation_freq = new wxStaticText(this, -1, _("Frequency"));
    spin_animation_freq = new wxSpinCtrl(this, -1, wxT(""), wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS|wxTE_AUTO_URL, 1, 1000);
    label_animation_freq2 = new wxStaticText(this, -1, _("sec"));
    label_animation_step = new wxStaticText(this, -1, _("Step Length"));
    spin_animation_steplength = new wxSpinCtrl(this, -1, wxT(""), wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 1, 1000);
    const wxString choice_animate_dimension_choices[] = {
        _("seconds"),
        _("minutes"),
        _("hours"),
        _("days"),
        _("months"),
        _("years")
    };
    choice_animate_dimension = new wxChoice(this, -1, wxDefaultPosition, wxDefaultSize, 6, choice_animate_dimension_choices, 0);
    const wxString choice_printout_type_choices[] = {
        _("dummy"),
        _("dummy"),
        _("dummy")
    };
    choice_printout_type = new wxChoice(this, CD_CHOICE_PRINTOUT, wxDefaultPosition, wxDefaultSize, 3, choice_printout_type_choices, 0);
    text_printout_description = new wxTextCtrl(this, -1, wxT(""), wxDefaultPosition, wxDefaultSize, wxTE_MULTILINE|wxTE_READONLY);
    label_paper = new wxStaticText(this, -1, _("Paper Format"));
    const wxString choice_paperformat_choices[] = {
        _("A4 (210x297mm)"),
        _("Letter (8.5x11 in)"),
        _("Legal (8.5x14 in)")
    };
    choice_paperformat = new wxChoice(this, -1, wxDefaultPosition, wxDefaultSize, 3, choice_paperformat_choices, 0);
    check_launchviewer = new wxCheckBox(this, CD_SWITCH_VIEWERMODE, _("Launch Pdf Viewer"));
    button_launchcommand = new wxButton(this, CD_COMMAND, _("Command ..."));
    text_launchcommand = new wxTextCtrl(this, -1, wxT(""));
    check_overwrite = new wxCheckBox(this, -1, _("Ask on Overwrite"));

    set_properties();
    do_layout();
    // end wxGlade
}

/*****************************************************
**
**   ConfAppearancePanel   ---   OnSelectFont
**
******************************************************/
void ConfAppearancePanel::OnSelectFont( wxCommandEvent &event )
{
	setFontPanel();
}

/*****************************************************
**
**   ConfAppearancePanel   ---   OnSwitchViewerMode
**
******************************************************/
void ConfAppearancePanel::OnSwitchViewerMode( wxCommandEvent &event )
{
#ifndef __WXMSW__
	button_launchcommand->Enable( check_launchviewer->GetValue());
	text_launchcommand->Enable( check_launchviewer->GetValue());
#endif
}

/*****************************************************
**
**   ConfAppearancePanel   ---   OnChooseFont
**
******************************************************/
void ConfAppearancePanel::OnChooseFont( wxCommandEvent &event )
{
	FontProvider fp;
	int sel = choice_fontselect->GetSelection();
	if ( sel < 0 || sel > 3 ) sel = 0;

  wxFontData data;
  data.SetInitialFont( *fp.initFont( fonts[sel] ));

  wxFontDialog dialog( this, &data);
  if ( dialog.ShowModal() == wxID_OK )
  {
    wxFontData retData = dialog.GetFontData();
		fonts[sel] = fp.getConfigEntry( retData.GetChosenFont() );
		tellThatRestartIsRecommended( this );
		fp.makeFontsDirty();
  }
	setFontPanel();
}

/*****************************************************
**
**   ConfAppearancePanel   ---   setFontPanel
**
******************************************************/
void ConfAppearancePanel::setFontPanel()
{
	int sel = choice_fontselect->GetSelection();
	if ( sel < 0 || sel > 3 ) sel = 0;
	setFontLabel( sel );
	text_font->Refresh();
}

/*****************************************************
**
**   ConfAppearancePanel   ---   OnColorChoice
**
******************************************************/
void ConfAppearancePanel::OnColorChoice( wxCommandEvent& )
{
	ColorProvider cp;
	unsigned char red, green, blue;
	int selcolor = choice_colors->GetSelection();
	getRGB( colors[selcolor], red, green, blue );
	panel_color->SetBackgroundColour( *cp.getColor( selcolor ));
	panel_color->Refresh();
}

/*****************************************************
**
**   ConfAppearancePanel   ---   OnChooseCommand
**
******************************************************/
void ConfAppearancePanel::OnChooseCommand( wxCommandEvent &event )
{
  wxFileDialog dialog( this, _("Choose Pdf Viewer" ));
 	 
  if ( dialog.ShowModal() == wxID_OK )
  {
    config->printPdfViewerCommand = dialog.GetDirectory();
    if ( config->printPdfViewerCommand != wxEmptyString ) config->printPdfViewerCommand << wxT( "/" );
    config->printPdfViewerCommand << dialog.GetFilename();
		text_launchcommand->SetValue( config->printPdfViewerCommand );
	}
}

/*****************************************************
**
**   ConfAppearancePanel   ---   OnSetColor
**
******************************************************/
void ConfAppearancePanel::OnSetColor( wxCommandEvent &event )
{
  wxColourData data;
	wxColour dcolor;

  data.SetColour( panel_color->GetBackgroundColour() );
  wxColourDialog dialog( this, &data );
  if ( dialog.ShowModal() == wxID_OK )
	{
		int selcolor = choice_colors->GetSelection();
		dcolor = dialog.GetColourData().GetColour();
		colors[selcolor] = setRGB( dcolor.Red(), dcolor.Green(), dcolor.Blue() );
		panel_color->SetBackgroundColour( dcolor );
		panel_color->Refresh();
		tellThatRestartIsRecommended( this );
		ColorProvider().reinit();
	}
}

/*****************************************************
**
**   ConfAppearancePanel   ---   setPrintoutFields
**
******************************************************/
void ConfAppearancePanel::setPrintoutFields()
{
	wxString s;
	if ( choice_printout_type->GetSelection() == -1 ) return;
	PrintInfo *pp = PrintoutManager::get()->getPrintInfoById( choice_printout_type->GetSelection() );
	text_printout_description->SetValue( pp->description );
}

/*****************************************************
**
**   ConfAppearancePanel   ---   OnPrintoutChoice
**
******************************************************/
void ConfAppearancePanel::OnPrintoutChoice( wxCommandEvent &event )
{
	setPrintoutFields();
}

/*****************************************************
**
**   ConfAppearancePanel   ---   setData
**
******************************************************/
void ConfAppearancePanel::setData()
{
  unsigned char red, green, blue;

	colors[0] = config->color_bg;
	colors[1] = config->color_bg2;
	colors[2] = config->color_fg;
	colors[3] = config->color_fg2;
	colors[4] = config->color_marked;
	colors[5] = config->color_benefic;
	colors[6] = config->color_malefic;

	fonts[0] = config->fontDefault;
	fonts[1] = config->fontHeader;
	fonts[2] = config->fontGraphic;
	fonts[3] = config->fontText;
	setFontPanel();

	int selcolor = choice_colors->GetSelection();
  getRGB( colors[selcolor], red, green, blue );
  panel_color->SetBackgroundColour( wxColour( red, green, blue ));

	//choice_sign_names->SetSelection( config->useVedicSigns );
	choice_sign_length->SetSelection( config->signPrecision );
	choice_positions->SetSelection( config->useVedicPositions );

	choice_printout_type->Clear();
	vector<PrintInfo*> pv = PrintoutManager::get()->getPrintoutList();
	for( unsigned int i = 0; i < pv.size(); i++ )
	{
		choice_printout_type->Append( pv[i]->name );
	}
	choice_printout_type->SetSelection( config->printDefaultPrintout );
	switch( config->printPaperFormat )
	{
		case wxPAPER_LETTER:
			choice_paperformat->SetSelection( 1 );
		break;
		case wxPAPER_LEGAL:
			choice_paperformat->SetSelection( 2 );
		break;
		default:
			choice_paperformat->SetSelection( 0 );
		break;
	}
	setPrintoutFields();
	check_launchviewer->SetValue( config->printLaunchPdfViewer );
	check_overwrite->SetValue( config->printAskOverwrite );

#ifdef __WXMSW__
	button_launchcommand->Enable( false );
	text_launchcommand->Enable( false );
#else
	text_launchcommand->SetValue( config->printPdfViewerCommand );
	button_launchcommand->Enable( config->printLaunchPdfViewer );
	text_launchcommand->Enable( config->printLaunchPdfViewer );
#endif

  spin_animation_freq->SetValue( config->animateInterval );
  
  choice_animation_mode->SetSelection( config->animateMode );
  spin_animation_steplength->SetValue( config->animateStepLength );
  spin_animation_steplength->Enable( config->animateMode );
  choice_animate_dimension->SetSelection( config->animateStepDimension );
  choice_animate_dimension->Enable( config->animateMode );
}

/*****************************************************
**
**   ConfAppearancePanel   ---   saveData
**
******************************************************/
bool ConfAppearancePanel::saveData()
{
	//config->useVedicSigns = choice_sign_names->GetSelection();
	config->signPrecision = choice_sign_length->GetSelection();
	config->useVedicPositions = choice_positions->GetSelection();

	config->printDefaultPrintout = choice_printout_type->GetSelection();
	config->printLaunchPdfViewer = check_launchviewer->GetValue();
	config->printAskOverwrite = check_overwrite->GetValue();
	config->printPdfViewerCommand = text_launchcommand->GetValue();
	switch( choice_paperformat->GetSelection() )
	{
		case 1:
			config->printPaperFormat = wxPAPER_LETTER;
		break;
		case 2:
			config->printPaperFormat = wxPAPER_LEGAL;
		break;
		default:
			config->printPaperFormat = wxPAPER_A4;
		break;
	}

  config->animateInterval = spin_animation_freq->GetValue();

  config->animateMode = choice_animation_mode->GetSelection();
  config->animateStepLength = spin_animation_steplength->GetValue();
  config->animateStepDimension = choice_animate_dimension->GetSelection();

	config->color_bg = colors[0];
	config->color_bg2 = colors[1];
	config->color_fg = colors[2];
	config->color_fg2 = colors[3];
	config->color_marked = colors[4];
	config->color_benefic = colors[5];
	config->color_malefic = colors[6];

	config->fontDefault = fonts[0];
	config->fontHeader  = fonts[1];
	config->fontGraphic = fonts[2];
	config->fontText    = fonts[3];
	return true;
}

/*****************************************************
**
**   ConfAppearancePanel   ---   set_properties
**
******************************************************/
void ConfAppearancePanel::set_properties()
{
    // begin wxGlade: ConfAppearancePanel::set_properties
    label_title->SetFont(wxFont(12, wxDEFAULT, wxNORMAL, wxBOLD, 0, wxT("")));
    choice_colors->SetMinSize(wxSize(160, 27));
    choice_colors->SetSelection(0);
    panel_color->SetMinSize(wxSize(100,25));
    choice_fontselect->SetSelection(0);
    text_font->SetMinSize(wxSize(250, 50));
    label_name_length->SetMinSize(wxSize(140, 17));
    choice_sign_length->SetSelection(0);
    label_positions->SetMinSize(wxSize(140, 16));
    choice_positions->SetSelection(0);
    label_animation_mode->SetMinSize(wxSize(80, 17));
    choice_animation_mode->SetSelection(0);
    label_animation_freq->SetMinSize(wxSize(80, 16));
    spin_animation_freq->SetMinSize(wxSize(50, 24));
    label_animation_freq2->SetMinSize(wxSize(50, 16));
    label_animation_step->SetMinSize(wxSize(80, 24));
    spin_animation_steplength->SetMinSize(wxSize(50, 24));
    choice_animate_dimension->SetSelection(0);
    choice_printout_type->SetSelection(0);
    text_printout_description->SetMinSize(wxSize(200, 60));
    label_paper->SetMinSize(wxSize(120, 16));
    choice_paperformat->SetSelection(0);
    text_launchcommand->SetMinSize(wxSize(120,25));
    // end wxGlade
		text_printout_description->SetBackgroundColour( GetBackgroundColour() );
		text_printout_description->SetForegroundColour( GetForegroundColour() );
		text_font->SetBackgroundColour( GetBackgroundColour() );
		text_font->SetForegroundColour( GetForegroundColour() );
}

/*****************************************************
**
**   ConfAppearancePanel   ---   OnAnimationModeChoice 
**
******************************************************/
void ConfAppearancePanel::OnAnimationModeChoice( wxCommandEvent &event )
{
  spin_animation_steplength->Enable( choice_animation_mode->GetSelection() > 0 );
  choice_animate_dimension->Enable( choice_animation_mode->GetSelection() > 0 );
}

/*****************************************************
**
**   ConfAppearancePanel   ---   do_layout
**
******************************************************/
void ConfAppearancePanel::setFontLabel( const int &i )
{
	wxString s;
	FontProvider fp;

	wxFont font = *fp.initFont( fonts[i] );
	text_font->SetFont( font );
	s << _( "Sample Text" );
	text_font->SetValue( s );
}

/*****************************************************
**
**   ConfAppearancePanel   ---   do_layout
**
******************************************************/
void ConfAppearancePanel::do_layout()
{
    // begin wxGlade: ConfAppearancePanel::do_layout
    wxBoxSizer* sizer_top = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* sizer_main = new wxBoxSizer(wxHORIZONTAL);
    wxFlexGridSizer* sizer_left = new wxFlexGridSizer(2, 1, 0, 0);
    wxStaticBoxSizer* sizer_printout = new wxStaticBoxSizer(sizer_printout_staticbox, wxVERTICAL);
    wxFlexGridSizer* sizer_printout2 = new wxFlexGridSizer(5, 1, 0, 0);
    wxFlexGridSizer* sizer_command = new wxFlexGridSizer(1, 2, 0, 0);
    wxBoxSizer* sizer_4 = new wxBoxSizer(wxHORIZONTAL);
    wxStaticBoxSizer* sizer_animate = new wxStaticBoxSizer(sizer_animate_staticbox, wxVERTICAL);
    wxFlexGridSizer* sizer_animode = new wxFlexGridSizer(2, 1, 0, 0);
    wxFlexGridSizer* grid_sizer_animation = new wxFlexGridSizer(2, 3, 0, 0);
    wxBoxSizer* sizer_3 = new wxBoxSizer(wxHORIZONTAL);
    wxFlexGridSizer* sizer_right = new wxFlexGridSizer(3, 1, 0, 0);
    wxStaticBoxSizer* sizer_signs = new wxStaticBoxSizer(sizer_signs_staticbox, wxVERTICAL);
    wxBoxSizer* sizer_8 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_7 = new wxBoxSizer(wxHORIZONTAL);
    wxStaticBoxSizer* sizer_fontconfig = new wxStaticBoxSizer(sizer_fontconfig_staticbox, wxVERTICAL);
    wxFlexGridSizer* grid_fonts = new wxFlexGridSizer(3, 1, 0, 0);
    wxStaticBoxSizer* sizer_colors = new wxStaticBoxSizer(sizer_colors_staticbox, wxVERTICAL);
    wxFlexGridSizer* sizer_color_choose = new wxFlexGridSizer(1, 2, 0, 0);
    sizer_top->Add(label_title, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxADJUST_MINSIZE, 3);
    sizer_top->Add(static_line_top, 0, wxALL|wxEXPAND, 3);
    sizer_colors->Add(choice_colors, 0, wxALL|wxEXPAND|wxADJUST_MINSIZE, 3);
    sizer_color_choose->Add(button_color_choose, 0, wxALL|wxALIGN_CENTER_VERTICAL, 3);
    sizer_color_choose->Add(panel_color, 1, wxALL|wxEXPAND, 3);
    sizer_color_choose->AddGrowableCol(1);
    sizer_colors->Add(sizer_color_choose, 1, wxALL|wxEXPAND, 3);
    sizer_right->Add(sizer_colors, 1, wxALL, 3);
    grid_fonts->Add(choice_fontselect, 0, wxALL|wxADJUST_MINSIZE, 3);
    grid_fonts->Add(button_choose_font, 0, wxALL|wxADJUST_MINSIZE, 3);
    grid_fonts->Add(text_font, 0, wxEXPAND, 0);
    grid_fonts->AddGrowableRow(2);
    sizer_fontconfig->Add(grid_fonts, 1, wxEXPAND, 0);
    sizer_right->Add(sizer_fontconfig, 1, wxALL, 3);
    sizer_7->Add(label_name_length, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    sizer_7->Add(choice_sign_length, 0, wxADJUST_MINSIZE, 0);
    sizer_signs->Add(sizer_7, 1, wxALL|wxEXPAND, 3);
    sizer_8->Add(label_positions, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    sizer_8->Add(choice_positions, 0, wxADJUST_MINSIZE, 0);
    sizer_signs->Add(sizer_8, 1, wxALL|wxEXPAND, 3);
    sizer_right->Add(sizer_signs, 1, 0, 0);
    sizer_right->AddGrowableRow(1);
    sizer_right->AddGrowableCol(0);
    sizer_main->Add(sizer_right, 1, wxALL, 3);
    sizer_3->Add(label_animation_mode, 0, wxALL|wxALIGN_CENTER_VERTICAL, 3);
    sizer_3->Add(choice_animation_mode, 0, wxALL|wxEXPAND|wxALIGN_CENTER_VERTICAL, 3);
    sizer_animode->Add(sizer_3, 1, wxEXPAND, 0);
    grid_sizer_animation->Add(label_animation_freq, 0, wxALL|wxALIGN_CENTER_VERTICAL, 3);
    grid_sizer_animation->Add(spin_animation_freq, 0, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 3);
    grid_sizer_animation->Add(label_animation_freq2, 0, wxLEFT|wxALIGN_CENTER_VERTICAL, 10);
    grid_sizer_animation->Add(label_animation_step, 0, wxALL|wxALIGN_CENTER_VERTICAL, 3);
    grid_sizer_animation->Add(spin_animation_steplength, 0, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 3);
    grid_sizer_animation->Add(choice_animate_dimension, 0, wxALL|wxALIGN_CENTER_VERTICAL, 3);
    sizer_animode->Add(grid_sizer_animation, 1, wxEXPAND, 0);
    sizer_animate->Add(sizer_animode, 1, wxEXPAND, 0);
    sizer_left->Add(sizer_animate, 1, 0, 3);
    sizer_printout2->Add(choice_printout_type, 0, wxALL|wxEXPAND|wxADJUST_MINSIZE, 3);
    sizer_printout2->Add(text_printout_description, 0, wxALL|wxEXPAND, 3);
    sizer_4->Add(label_paper, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    sizer_4->Add(choice_paperformat, 0, wxADJUST_MINSIZE, 0);
    sizer_printout2->Add(sizer_4, 1, wxALL|wxEXPAND, 3);
    sizer_printout2->Add(check_launchviewer, 0, wxALL, 3);
    sizer_command->Add(button_launchcommand, 0, wxALL|wxADJUST_MINSIZE, 3);
    sizer_command->Add(text_launchcommand, 0, wxALL|wxEXPAND|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    sizer_command->AddGrowableCol(1);
    sizer_printout2->Add(sizer_command, 1, wxEXPAND, 0);
    sizer_printout2->Add(check_overwrite, 0, wxADJUST_MINSIZE, 0);
    sizer_printout2->AddGrowableRow(2);
    sizer_printout2->AddGrowableCol(0);
    sizer_printout->Add(sizer_printout2, 1, wxEXPAND, 0);
    sizer_left->Add(sizer_printout, 1, wxEXPAND, 0);
    sizer_left->AddGrowableCol(0);
    sizer_main->Add(sizer_left, 1, wxALL|wxEXPAND, 3);
    sizer_top->Add(sizer_main, 0, wxALL|wxEXPAND, 3);
    SetAutoLayout(true);
    SetSizer(sizer_top);
    sizer_top->Fit(this);
    sizer_top->SetSizeHints(this);
    // end wxGlade
}

