/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           ConfAppearancePanel.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifndef CONFAPPEARANCEPANEL_H
#define CONFAPPEARANCEPANEL_H

#ifdef __GNUG__
	#pragma interface "ConfAppearancePanel.h"
#endif

#include <wx/panel.h>

// begin wxGlade: dependencies
// end wxGlade

class wxButton;
class wxCheckBox;
class wxChoice;
class wxSpinCtrl;
class wxStaticBox;
class wxStaticLine;
class wxStaticText;
class wxTextCtrl;

/*****************************************************
**
**   CLASS ConfAppearancePanel
**
******************************************************/
class ConfAppearancePanel: public wxPanel {
public:
    // begin wxGlade: ConfAppearancePanel::ids
    // end wxGlade

    ConfAppearancePanel(wxWindow* parent, int id, const wxPoint& pos=wxDefaultPosition,
			const wxSize& size=wxDefaultSize, long style=0);
  void setData();
  bool saveData();

private:
    // begin wxGlade: ConfAppearancePanel::methods
    void set_properties();
    void do_layout();
    // end wxGlade
	void OnChooseFont( wxCommandEvent& );
	void OnSelectFont( wxCommandEvent& );
	void setFontPanel();
	void OnColorChoice( wxCommandEvent& );
	void OnSetColor( wxCommandEvent & );
	void OnChooseCommand( wxCommandEvent& );
	void OnSwitchViewerMode( wxCommandEvent& );
	void OnAnimationModeChoice( wxCommandEvent& );
	void setFontLabel( const int& );
	void setPrintoutFields();
	void OnPrintoutChoice( wxCommandEvent& );
	int colors[7];
	wxString fonts[4];

	DECLARE_CLASS( ConfAppearancePanel )
	DECLARE_EVENT_TABLE()

protected:
    // begin wxGlade: ConfAppearancePanel::attributes
    wxStaticBox* sizer_printout_staticbox;
    wxStaticBox* sizer_animate_staticbox;
    wxStaticBox* sizer_signs_staticbox;
    wxStaticBox* sizer_fontconfig_staticbox;
    wxStaticBox* sizer_colors_staticbox;
    wxStaticText* label_title;
    wxStaticLine* static_line_top;
    wxChoice* choice_colors;
    wxButton* button_color_choose;
    wxPanel* panel_color;
    wxChoice* choice_fontselect;
    wxButton* button_choose_font;
    wxTextCtrl* text_font;
    wxStaticText* label_name_length;
    wxChoice* choice_sign_length;
    wxStaticText* label_positions;
    wxChoice* choice_positions;
    wxStaticText* label_animation_mode;
    wxChoice* choice_animation_mode;
    wxStaticText* label_animation_freq;
    wxSpinCtrl* spin_animation_freq;
    wxStaticText* label_animation_freq2;
    wxStaticText* label_animation_step;
    wxSpinCtrl* spin_animation_steplength;
    wxChoice* choice_animate_dimension;
    wxChoice* choice_printout_type;
    wxTextCtrl* text_printout_description;
    wxStaticText* label_paper;
    wxChoice* choice_paperformat;
    wxCheckBox* check_launchviewer;
    wxButton* button_launchcommand;
    wxTextCtrl* text_launchcommand;
    wxCheckBox* check_overwrite;
    // end wxGlade
};


#endif // CONFAPPEARANCEPANEL_H
