/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           ConfExpertPanel.cpp
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifdef __GNUG__
	#pragma implementation "ConfExpertPanel.h"
#endif

#include "ConfExpertPanel.h"

#include <wx/button.h>
#include <wx/checkbox.h>
#include <wx/choice.h>
#include <wx/dir.h>
#include <wx/dirdlg.h>
#include <wx/spinctrl.h>
#include <wx/sizer.h>
#include <wx/statbox.h>
#include <wx/statline.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
    
#include "Base.h"
#include "func.h"
#include "Conf.h"
#include "Lang.h"
#include "Session.h"
#include "ViewBuilder.h"

extern Config *config;
enum { CD_ANIMATIONMODE = wxID_HIGHEST + 1, CD_SEPATH, CD_DEFAULTAYA, CD_DEFAULT_CALC, CD_AYA_CONSTANT,
	CD_SWITCH_MVIEW, CD_CHOICE_DEFAULTVIEW };

IMPLEMENT_CLASS( ConfExpertPanel, wxPanel )
BEGIN_EVENT_TABLE( ConfExpertPanel, wxPanel )
  EVT_BUTTON( CD_SEPATH, ConfExpertPanel::OnSelectSEPath )
  EVT_BUTTON( CD_DEFAULTAYA, ConfExpertPanel::OnDefaultAyanamsa )
  EVT_BUTTON( CD_DEFAULT_CALC, ConfExpertPanel::OnDefaultCalculation )
	EVT_CHECKBOX( CD_AYA_CONSTANT, ConfExpertPanel::OnCheckConstantAyanamsa )
	EVT_CHECKBOX( CD_SWITCH_MVIEW, ConfExpertPanel::OnSwitchMView )
	EVT_CHOICE( CD_CHOICE_DEFAULTVIEW, ConfExpertPanel::OnDefaultViewChoice )
END_EVENT_TABLE()
   
/*****************************************************
**
**   ConfExpertPanel   ---   Constructor 
**
******************************************************/
ConfExpertPanel::ConfExpertPanel(wxWindow* parent, int id, const wxPoint& pos, const wxSize& size, long style):
    wxPanel(parent, id, pos, size, wxTAB_TRAVERSAL)
{
    // begin wxGlade: ConfExpertPanel::ConfExpertPanel
    sizer_mview_staticbox = new wxStaticBox(this, -1, _("Multiple Views"));
    sizer_ephem_path_staticbox = new wxStaticBox(this, -1, _("Path for Ephemeris Data Files"));
    sizer_calc_staticbox = new wxStaticBox(this, -1, _("Calculation"));
    sizer_14_staticbox = new wxStaticBox(this, -1, _("Custom Ayanamsa"));
    label_title = new wxStaticText(this, -1, _("Advanced"), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE);
    static_line_top = new wxStaticLine(this, -1);
    label_custom_aya_t0 = new wxStaticText(this, -1, _("Date t0"));
    text_t0 = new wxTextCtrl(this, -1, wxT(""));
    label_custom_aya_ayat0 = new wxStaticText(this, -1, _("Ayanamsa at t0"));
    text_ayan_t0 = new wxTextCtrl(this, -1, wxT(""));
    check_period = new wxCheckBox(this, CD_AYA_CONSTANT, _("Constant Period"));
    text_period = new wxTextCtrl(this, -1, wxT(""));
    label_period = new wxStaticText(this, -1, _("Years"));
    defaya_button = new wxButton(this, CD_DEFAULTAYA, _("Default"));
    check_use_mw = new wxCheckBox(this, CD_SWITCH_MVIEW, _("Use Multiple Views (Experimental)"));
    label_defview = new wxStaticText(this, -1, _("View"));
    const wxString choice_viewlist_choices[] = {
        _("dummy"),
        _("dummy"),
        _("dummy"),
        _("dummy")
    };
    choice_viewlist = new wxChoice(this, CD_CHOICE_DEFAULTVIEW, wxDefaultPosition, wxDefaultSize, 4, choice_viewlist_choices, 0);
    text_view_description = new wxTextCtrl(this, -1, wxT(""), wxDefaultPosition, wxDefaultSize, wxTE_MULTILINE|wxTE_READONLY);
    button_sepath = new wxButton(this, CD_SEPATH, _("Choose ..."));
    text_sepath = new wxTextCtrl(this, -1, wxT(""));
    label_timemodel = new wxStaticText(this, -1, _("Time Model"));
    const wxString choice_timemodel_choices[] = {
        _("Universal"),
        _("Ephemeris")
    };
    choice_timemodel = new wxChoice(this, -1, wxDefaultPosition, wxDefaultSize, 2, choice_timemodel_choices, 0);
    label_coord = new wxStaticText(this, -1, _("Coordinates"));
    const wxString choice_coord_choices[] = {
        _("Geocentric"),
        _("Topocentric")
    };
    choice_coord = new wxChoice(this, -1, wxDefaultPosition, wxDefaultSize, 2, choice_coord_choices, 0);
    label_pos = new wxStaticText(this, -1, _("Positions"));
    const wxString choice_pos_choices[] = {
        _("Apparent"),
        _("True")
    };
    choice_pos = new wxChoice(this, -1, wxDefaultPosition, wxDefaultSize, 2, choice_pos_choices, 0);
    button_defcalc = new wxButton(this, CD_DEFAULT_CALC, _("Default"));

    set_properties();
    do_layout();
    // end wxGlade
}


/*****************************************************
**
**   ConfExpertPanel   ---   set_properties 
**
******************************************************/
void ConfExpertPanel::set_properties()
{
    // begin wxGlade: ConfExpertPanel::set_properties
    label_title->SetFont(wxFont(12, wxDEFAULT, wxNORMAL, wxBOLD, 0, wxT("")));
    label_custom_aya_t0->SetMinSize(wxSize(120, 16));
    text_t0->SetMinSize(wxSize(100, 23));
    label_custom_aya_ayat0->SetMinSize(wxSize(120, 16));
    text_ayan_t0->SetMinSize(wxSize(100, 23));
    check_period->SetMinSize(wxSize(120, 24));
    text_period->SetMinSize(wxSize(100, 23));
    label_defview->SetMinSize(wxSize(50, 17));
    choice_viewlist->SetSelection(0);
    text_view_description->SetMinSize(wxSize(200,100));
    text_sepath->SetMinSize(wxSize(180, 23));
    text_sepath->SetToolTip(_("Only required for high precision calculation"));
    label_timemodel->SetMinSize(wxSize(120, 16));
    choice_timemodel->SetSelection(0);
    label_coord->SetMinSize(wxSize(120, 16));
    choice_coord->SetSelection(0);
    label_pos->SetMinSize(wxSize(120, 16));
    choice_pos->SetSelection(0);
    // end wxGlade

	text_view_description->SetBackgroundColour( GetBackgroundColour() );
	text_view_description->SetForegroundColour( GetForegroundColour() );
	Session *session = Session::get();
	wxString viewdir, filename, viewname;
	int sel = 0;

	choice_viewlist->Clear();
	vector<wxString> v = session->getViewList();
	for( unsigned int i = 0; i < v.size(); i++ )
	{
		if ( v[i].IsSameAs( config->defaultView, false )) sel = i; 
		choice_viewlist->Append( v[i] );
	}
	choice_viewlist->SetSelection( sel );
}


/*****************************************************
**
**   ConfExpertPanel   ---   do_layout 
**
******************************************************/
void ConfExpertPanel::do_layout()
{
    // begin wxGlade: ConfExpertPanel::do_layout
    wxBoxSizer* sizer_top = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* sizer_nb5 = new wxBoxSizer(wxHORIZONTAL);
    wxFlexGridSizer* sizer_nb5b = new wxFlexGridSizer(2, 1, 0, 0);
    wxStaticBoxSizer* sizer_calc = new wxStaticBoxSizer(sizer_calc_staticbox, wxVERTICAL);
    wxFlexGridSizer* grid_sizer_calc = new wxFlexGridSizer(3, 2, 0, 0);
    wxStaticBoxSizer* sizer_ephem_path = new wxStaticBoxSizer(sizer_ephem_path_staticbox, wxVERTICAL);
    wxFlexGridSizer* sizer_ephemdata = new wxFlexGridSizer(1, 2, 0, 0);
    wxFlexGridSizer* sizer_nb5a = new wxFlexGridSizer(2, 1, 0, 0);
    wxStaticBoxSizer* sizer_mview = new wxStaticBoxSizer(sizer_mview_staticbox, wxVERTICAL);
    wxFlexGridSizer* grid_mview = new wxFlexGridSizer(3, 1, 0, 0);
    wxFlexGridSizer* grid_select_view = new wxFlexGridSizer(1, 2, 0, 0);
    wxStaticBoxSizer* sizer_14 = new wxStaticBoxSizer(sizer_14_staticbox, wxVERTICAL);
    wxFlexGridSizer* grid_sizer_aya = new wxFlexGridSizer(3, 3, 0, 0);
    sizer_top->Add(label_title, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxADJUST_MINSIZE, 3);
    sizer_top->Add(static_line_top, 0, wxALL|wxEXPAND, 3);
    grid_sizer_aya->Add(label_custom_aya_t0, 0, wxALIGN_CENTER_VERTICAL, 0);
    grid_sizer_aya->Add(text_t0, 0, wxTOP|wxBOTTOM|wxEXPAND|wxALIGN_CENTER_VERTICAL, 3);
    grid_sizer_aya->Add(20, 20, 0, wxALIGN_CENTER_VERTICAL, 0);
    grid_sizer_aya->Add(label_custom_aya_ayat0, 0, wxALIGN_CENTER_VERTICAL, 0);
    grid_sizer_aya->Add(text_ayan_t0, 0, wxTOP|wxBOTTOM|wxEXPAND|wxALIGN_CENTER_VERTICAL, 3);
    grid_sizer_aya->Add(20, 20, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 0);
    grid_sizer_aya->Add(check_period, 0, wxALIGN_CENTER_VERTICAL, 0);
    grid_sizer_aya->Add(text_period, 0, wxTOP|wxBOTTOM|wxEXPAND|wxALIGN_CENTER_VERTICAL, 3);
    grid_sizer_aya->Add(label_period, 0, wxALL|wxALIGN_CENTER_VERTICAL, 3);
    grid_sizer_aya->AddGrowableCol(1);
    sizer_14->Add(grid_sizer_aya, 1, wxEXPAND, 0);
    sizer_14->Add(defaya_button, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 3);
    sizer_nb5a->Add(sizer_14, 1, wxEXPAND, 0);
    grid_mview->Add(check_use_mw, 0, wxALL, 3);
    grid_select_view->Add(label_defview, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    grid_select_view->Add(choice_viewlist, 0, wxALL|wxEXPAND|wxADJUST_MINSIZE, 3);
    grid_select_view->AddGrowableCol(1);
    grid_mview->Add(grid_select_view, 1, wxALL|wxEXPAND, 3);
    grid_mview->Add(text_view_description, 0, wxALL|wxEXPAND, 3);
    grid_mview->AddGrowableRow(2);
    grid_mview->AddGrowableCol(0);
    sizer_mview->Add(grid_mview, 1, wxEXPAND, 0);
    sizer_nb5a->Add(sizer_mview, 1, wxEXPAND, 0);
    sizer_nb5a->AddGrowableCol(0);
    sizer_nb5->Add(sizer_nb5a, 1, wxALL, 3);
    sizer_ephemdata->Add(button_sepath, 0, wxALL|wxALIGN_CENTER_VERTICAL, 5);
    sizer_ephemdata->Add(text_sepath, 0, wxALL|wxEXPAND|wxALIGN_CENTER_VERTICAL, 5);
    sizer_ephemdata->AddGrowableCol(1);
    sizer_ephem_path->Add(sizer_ephemdata, 1, wxEXPAND, 0);
    sizer_nb5b->Add(sizer_ephem_path, 1, wxALL|wxEXPAND, 3);
    grid_sizer_calc->Add(label_timemodel, 0, wxALIGN_CENTER_VERTICAL, 0);
    grid_sizer_calc->Add(choice_timemodel, 0, wxALL|wxEXPAND, 3);
    grid_sizer_calc->Add(label_coord, 0, wxALIGN_CENTER_VERTICAL, 0);
    grid_sizer_calc->Add(choice_coord, 0, wxALL|wxEXPAND|wxALIGN_CENTER_VERTICAL, 3);
    grid_sizer_calc->Add(label_pos, 0, wxALIGN_CENTER_VERTICAL, 0);
    grid_sizer_calc->Add(choice_pos, 0, wxALL|wxEXPAND, 3);
    sizer_calc->Add(grid_sizer_calc, 1, 0, 0);
    sizer_calc->Add(button_defcalc, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 3);
    sizer_nb5b->Add(sizer_calc, 1, 0, 0);
    sizer_nb5b->AddGrowableCol(0);
    sizer_nb5->Add(sizer_nb5b, 1, wxALL, 3);
    sizer_top->Add(sizer_nb5, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxADJUST_MINSIZE, 3);
    SetAutoLayout(true);
    SetSizer(sizer_top);
    sizer_top->Fit(this);
    sizer_top->SetSizeHints(this);
    // end wxGlade
}

/*****************************************************
**
**   ConfExpertPanel   ---   setData 
**
******************************************************/
void ConfExpertPanel::setData()
{
  text_sepath->SetValue( config->sePath );
  choice_timemodel->SetSelection( config->useEphemerisTime );
  choice_coord->SetSelection( config->useTopocentric );
  choice_pos->SetSelection( config->useTruePositions );

  text_t0->SetValue( printfDouble( config->custom_t0 ) );
  text_ayan_t0->SetValue( printfDouble( config->custom_ayan_t0 ) );

  check_period->SetValue( config->custom_aya_constant );
  text_period->SetValue( printfDouble( config->custom_aya_period ) );
  text_period->Enable( config->custom_aya_constant );

  check_use_mw->SetValue( config->useMultipleViews );
  setDefaultViewFields();
}

/*****************************************************
**
**   ConfExpertPanel   ---   saveData 
**
******************************************************/
bool ConfExpertPanel::saveData()
{
  config->sePath = text_sepath->GetValue().c_str();
	config->useEphemerisTime = choice_timemodel->GetSelection();
	config->useTopocentric = choice_coord->GetSelection();
	config->useTruePositions = choice_pos->GetSelection();

  config->custom_t0 = myatof( text_t0->GetValue().c_str() );
  config->custom_ayan_t0 = myatof( text_ayan_t0->GetValue().c_str() );
  config->custom_aya_constant = check_period->GetValue();
  config->custom_aya_period = myatof( text_period->GetValue().c_str() );

	config->useMultipleViews = check_use_mw->GetValue();
	config->defaultView = choice_viewlist->GetStringSelection();

	return true;
}

/*****************************************************
**
**   ConfExpertPanel   ---   OnSelectSEPath 
**
******************************************************/
void ConfExpertPanel::OnSelectSEPath( wxCommandEvent &event )
{
  wxDirDialog dialog( this, _( "Choose a directory" ), text_sepath->GetValue());
  if ( dialog.ShowModal() == wxID_OK )
  {
    text_sepath->SetValue( dialog.GetPath());
  }
}  

/*****************************************************
**
**   ConfExpertPanel   ---   OnDefaultAyanamsa 
**
******************************************************/
void ConfExpertPanel::OnDefaultAyanamsa( wxCommandEvent &event )
{
  text_t0->SetValue( printfDouble( DEFAULT_T0 ) );
  text_ayan_t0->SetValue( printfDouble( DEFAULT_AYAN_T0 ));

  check_period->SetValue( false );
  text_period->SetValue( printfDouble( DEFAULT_AYA_PERIOD ));
  text_period->Enable( false );
}
    
/*****************************************************
**
**   ConfExpertPanel   ---   OnCheckConstantAyanamsa 
**
******************************************************/
void ConfExpertPanel::OnCheckConstantAyanamsa( wxCommandEvent &event )
{
  text_period->Enable( check_period->GetValue() );
}

/*****************************************************
**
**   ConfExpertPanel   ---   OnDefaultCalculation 
**
******************************************************/
void ConfExpertPanel::OnDefaultCalculation( wxCommandEvent &event )
{
	choice_timemodel->SetSelection( 0 );
	choice_coord->SetSelection( 0 );
	choice_pos->SetSelection(  0 );
}

/*****************************************************
**
**   ConfExpertPanel   ---   OnPrintoutChoice
**
******************************************************/
void ConfExpertPanel::OnDefaultViewChoice( wxCommandEvent &event )
{
  setDefaultViewFields();
}

/*****************************************************
**
**   ConfExpertPanel   ---   setDefaultViewFields
**
******************************************************/
void ConfExpertPanel::setDefaultViewFields()
{
	choice_viewlist->Enable( false );
	text_view_description->SetValue( wxT( "" ));
	choice_viewlist->Enable( check_use_mw->GetValue() );
	label_defview->Enable( check_use_mw->GetValue());
	text_view_description->Enable( check_use_mw->GetValue());
	if ( check_use_mw->GetValue())
	{
		int sel = choice_viewlist->GetSelection();
		if ( sel == -1 ) { text_view_description->SetValue( wxT( "Error" )); }
		else
		{
			ViewContainer *container = new ViewContainer;
			ViewBuilder().getViewDefinition( container, choice_viewlist->GetStringSelection() );
			text_view_description->SetValue( container->description );
			delete container;
		}
	}
	else { text_view_description->SetValue( wxT( "" )); }
}


/*****************************************************
**
**   ConfExpertPanel   ---   OnSwitchMView
**
******************************************************/
void ConfExpertPanel::OnSwitchMView( wxCommandEvent &event )
{
	setDefaultViewFields();
}



