/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           ConfExpertPanel.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifndef CONFEXPERTPANEL_H
#define CONFEXPERTPANEL_H

#ifdef __GNUG__
	#pragma interface "ConfExpertPanel.h"
#endif

#include <wx/panel.h>

// begin wxGlade: dependencies
// end wxGlade

class wxButton;
class wxCheckBox;
class wxChoice;
class wxSpinCtrl;
class wxStaticBox;
class wxStaticLine;
class wxStaticText;
class wxTextCtrl;

/*****************************************************
**
**   CLASS ConfExpertPanel  
**
******************************************************/
class ConfExpertPanel: public wxPanel
{
	DECLARE_CLASS( ConfExpertPanel )
public:
    // begin wxGlade: ConfExpertPanel::ids
    // end wxGlade

	ConfExpertPanel(wxWindow* parent, int id, const wxPoint& pos=wxDefaultPosition, const wxSize& size=wxDefaultSize, long style=0);
	void setData();  
  bool saveData();
	DECLARE_EVENT_TABLE()

private:
    // begin wxGlade: ConfExpertPanel::methods
    void set_properties();
    void do_layout();
    // end wxGlade
  void OnSelectSEPath( wxCommandEvent& );
  void OnDefaultAyanamsa( wxCommandEvent& );
	void OnDefaultCalculation( wxCommandEvent& );
	void OnCheckConstantAyanamsa( wxCommandEvent& );
	void OnSwitchMView( wxCommandEvent& );
	void OnDefaultViewChoice( wxCommandEvent& );
	void setDefaultViewFields();

protected:
    // begin wxGlade: ConfExpertPanel::attributes
    wxStaticBox* sizer_calc_staticbox;
    wxStaticBox* sizer_ephem_path_staticbox;
    wxStaticBox* sizer_mview_staticbox;
    wxStaticBox* sizer_14_staticbox;
    wxStaticText* label_title;
    wxStaticLine* static_line_top;
    wxStaticText* label_custom_aya_t0;
    wxTextCtrl* text_t0;
    wxStaticText* label_custom_aya_ayat0;
    wxTextCtrl* text_ayan_t0;
    wxCheckBox* check_period;
    wxTextCtrl* text_period;
    wxStaticText* label_period;
    wxButton* defaya_button;
    wxCheckBox* check_use_mw;
    wxStaticText* label_defview;
    wxChoice* choice_viewlist;
    wxTextCtrl* text_view_description;
    wxButton* button_sepath;
    wxTextCtrl* text_sepath;
    wxStaticText* label_timemodel;
    wxChoice* choice_timemodel;
    wxStaticText* label_coord;
    wxChoice* choice_coord;
    wxStaticText* label_pos;
    wxChoice* choice_pos;
    wxButton* button_defcalc;
    // end wxGlade
};


#endif // CONFEXPERTPANEL_H
