/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           ConfGeneralPanel.cpp
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifdef __GNUG__
	#pragma implementation "ConfGeneralPanel.h"
#endif

#include "ConfGeneralPanel.h"

#include <math.h>
#include <list>

#include "Base.h"
#include "LocationDialog.h"

#include "func.h"
#include "Conf.h"
#include "Lang.h"

#include <wx/button.h>
#include <wx/checkbox.h>
#include <wx/choice.h>
#include <wx/log.h>
#include <wx/sizer.h>
#include <wx/spinctrl.h>
#include <wx/statbox.h>
#include <wx/statline.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/timer.h>

using namespace std;

extern Config *config;
enum { CD_SEARCHLOCATION = wxID_HIGHEST + 1, CD_TIMER };

IMPLEMENT_CLASS( ConfGeneralPanel, wxPanel )
BEGIN_EVENT_TABLE( ConfGeneralPanel, wxPanel )
	EVT_BUTTON( CD_SEARCHLOCATION, ConfGeneralPanel::OnSearchLocation )
	EVT_TIMER( CD_TIMER, ConfGeneralPanel::OnTimer )
END_EVENT_TABLE()

/*****************************************************
**
**   ConfGeneralPanel   ---   Constructor 
**
******************************************************/
ConfGeneralPanel::ConfGeneralPanel(wxWindow* parent, int id, const wxPoint& pos, const wxSize& size, long style):
    wxPanel(parent, id, pos, size, wxTAB_TRAVERSAL)
{
    // begin wxGlade: ConfGeneralPanel::ConfGeneralPanel
    panel_systime = new wxPanel(this, -1, wxDefaultPosition, wxDefaultSize, wxSUNKEN_BORDER|wxTAB_TRAVERSAL);
    sizer_misc_staticbox = new wxStaticBox(this, -1, _("Miscellaneous"));
    sizer_deflocname_staticbox = new wxStaticBox(this, -1, _("Default Location"));
    sizer_deflocdata_staticbox = new wxStaticBox(this, -1, _("Geographical Data"));
    sizer_defloc_tz_staticbox = new wxStaticBox(this, -1, _("Time Zone Options"));
    sizer_general_staticbox = new wxStaticBox(this, -1, _("General"));
    label_title = new wxStaticText(this, -1, _("General"), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE);
    static_line_top = new wxStaticLine(this, -1);
    label_defstyle = new wxStaticText(this, -1, _("Default Style"));
    const wxString choice_defstyle_choices[] = {
        _("Vedic"),
        _("Western")
    };
    choice_defstyle = new wxChoice(this, -1, wxDefaultPosition, wxDefaultSize, 2, choice_defstyle_choices, 0);
    label_lang = new wxStaticText(this, -1, _("Language"));
    const wxString choice_lang_choices[] = {
        _("dummy"),
        _("dummy"),
        _("dummy"),
        _("dummy")
    };
    choice_lang = new wxChoice(this, -1, wxDefaultPosition, wxDefaultSize, 4, choice_lang_choices, 0);
    check_opennewdoc = new wxCheckBox(this, -1, _("Open New Document on Startup"));
    check_askonquit = new wxCheckBox(this, -1, _("Ask on Quit"));
    check_showstatusinfo = new wxCheckBox(this, -1, _("Running Objects in Status Bar"));
    check_showhtml = new wxCheckBox(this, -1, _("Text Windows in HTML"));
    label_recent = new wxStaticText(this, -1, _("Maximum of Recent Files"));
    spin_recent_files = new wxSpinCtrl(this, -1, wxT(""), wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 0, 100);
    label_location_backup = new wxStaticText(this, -1, _("Backups of Location DB"));
    const wxString choice_location_backup_choices[] = {
        _("Never"),
        _("One"),
        _("Infinite")
    };
    choice_location_backup = new wxChoice(this, -1, wxDefaultPosition, wxDefaultSize, 3, choice_location_backup_choices, 0);
    text_deflocname = new wxTextCtrl(this, -1, wxT(""));
    label_defloc_long = new wxStaticText(this, -1, _("Longitude"));
    text_deflong = new wxTextCtrl(this, -1, wxT(""));
    const wxString choice_ew_choices[] = {
        _("East"),
        _("West")
    };
    choice_ew = new wxChoice(this, -1, wxDefaultPosition, wxDefaultSize, 2, choice_ew_choices, 0);
    label_defloc_lat = new wxStaticText(this, -1, _("Latitude"));
    text_deflat = new wxTextCtrl(this, -1, wxT(""));
    const wxString choice_ns_choices[] = {
        _("North"),
        _("South")
    };
    choice_ns = new wxChoice(this, -1, wxDefaultPosition, wxDefaultSize, 2, choice_ns_choices, 0);
    label_defloc_tz = new wxStaticText(this, -1, _("Time Zone"));
    text_timezone = new wxTextCtrl(this, -1, wxT(""));
    const wxString choice_tzew_choices[] = {
        _("East"),
        _("West")
    };
    choice_tzew = new wxChoice(this, -1, wxDefaultPosition, wxDefaultSize, 2, choice_tzew_choices, 0);
    label_defloc_dst = new wxStaticText(this, -1, _("Daylight Saving"));
    text_dst = new wxTextCtrl(this, -1, wxT(""));
    label_defloc_dst2 = new wxStaticText(this, -1, _("Hours"));
    label_systime = new wxStaticText(this, -1, _("Current Time"));
    text_systime = new wxStaticText(panel_systime, -1, _("00:00:00"));
    searchloc_button = new wxButton(this, CD_SEARCHLOCATION, _("Search Location ..."));

    set_properties();
    do_layout();
    // end wxGlade
	timer = new wxTimer( this, CD_TIMER );
	timer->Start( 1000 );
}

/*****************************************************
**
**   ConfGeneralPanel   ---   Destructor
**
******************************************************/
ConfGeneralPanel::~ConfGeneralPanel()
{
	timer->Stop();
	delete timer;
}

/*****************************************************
**
**   ConfGeneralPanel   ---   OnTimer 
**
******************************************************/
void ConfGeneralPanel::OnTimer( wxTimerEvent &event )
{
	time_t tt;
	time( &tt );
	double mytime, diff, dst;
	Formatter *formatter = Formatter::get();

	mytime = 2440587.5 + (double)tt / 86400.0; // 1.1.1970 + seconds elapsed / number of seconds per day

	double tz = myatof( text_timezone->GetValue());
	if ( choice_tzew->GetSelection()) tz *= -1;
	text_dst->GetValue().ToDouble( &dst );
	diff = tz + dst;

	//if ( check_systemgt->GetValue() ) mytime += diff/24;
	mytime += diff/24;
	text_systime->SetLabel( formatter->getTimeFormated( getTimeFromJD( mytime )));
}

/*****************************************************
**
**   ConfGeneralPanel   ---   set_properties 
**
******************************************************/
void ConfGeneralPanel::set_properties()
{
    // begin wxGlade: ConfGeneralPanel::set_properties
    label_title->SetFont(wxFont(12, wxDEFAULT, wxNORMAL, wxBOLD, 0, wxT("")));
    label_defstyle->SetMinSize(wxSize(180, 16));
    choice_defstyle->SetSelection(0);
    label_lang->SetMinSize(wxSize(180, 16));
    choice_lang->SetSelection(0);
    check_opennewdoc->SetMinSize(wxSize(250, 24));
    check_showstatusinfo->SetMinSize(wxSize(250, 24));
    label_recent->SetMinSize(wxSize(180, 20));
    spin_recent_files->SetMinSize(wxSize(50, 24));
    label_location_backup->SetMinSize(wxSize(180, 17));
    choice_location_backup->SetSelection(0);
    text_deflocname->SetMinSize(wxSize(250, 23));
    label_defloc_long->SetMinSize(wxSize(100, 16));
    text_deflong->SetMinSize(wxSize(80, 23));
    choice_ew->SetSelection(0);
    label_defloc_lat->SetMinSize(wxSize(100, 16));
    text_deflat->SetMinSize(wxSize(80, 23));
    choice_ns->SetSelection(0);
    label_defloc_tz->SetMinSize(wxSize(100, 16));
    text_timezone->SetMinSize(wxSize(80, 23));
    choice_tzew->SetSelection(0);
    label_defloc_dst->SetMinSize(wxSize(100, 17));
    text_dst->SetMinSize(wxSize(80, 23));
    label_defloc_dst2->SetMinSize(wxSize(80, 16));
    label_systime->SetMinSize(wxSize(100, 17));
    text_systime->SetMinSize(wxSize(80, 17));
    panel_systime->SetMinSize(wxSize(100,25));
    // end wxGlade
}

/*****************************************************
**
**   ConfGeneralPanel   ---   do_layout 
**
******************************************************/
void ConfGeneralPanel::do_layout()
{
    // begin wxGlade: ConfGeneralPanel::do_layout
    wxBoxSizer* sizer_top = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* sizer_main = new wxBoxSizer(wxHORIZONTAL);
    wxFlexGridSizer* sizer_right = new wxFlexGridSizer(4, 1, 0, 0);
    wxStaticBoxSizer* sizer_defloc_tz = new wxStaticBoxSizer(sizer_defloc_tz_staticbox, wxVERTICAL);
    wxFlexGridSizer* sizer_3 = new wxFlexGridSizer(1, 3, 0, 0);
    wxBoxSizer* sizer_systime2 = new wxBoxSizer(wxHORIZONTAL);
    wxFlexGridSizer* sizer_defloc_dst = new wxFlexGridSizer(1, 3, 0, 0);
    wxFlexGridSizer* sizer_defloc_zone = new wxFlexGridSizer(1, 3, 0, 0);
    wxStaticBoxSizer* sizer_deflocdata = new wxStaticBoxSizer(sizer_deflocdata_staticbox, wxVERTICAL);
    wxFlexGridSizer* sizer_defloc_lat = new wxFlexGridSizer(1, 3, 0, 0);
    wxFlexGridSizer* sizer_defloc_long = new wxFlexGridSizer(1, 3, 0, 0);
    wxStaticBoxSizer* sizer_deflocname = new wxStaticBoxSizer(sizer_deflocname_staticbox, wxVERTICAL);
    wxFlexGridSizer* sizer_left = new wxFlexGridSizer(2, 1, 0, 0);
    wxStaticBoxSizer* sizer_misc = new wxStaticBoxSizer(sizer_misc_staticbox, wxVERTICAL);
    wxBoxSizer* sizer_locationbackup = new wxBoxSizer(wxHORIZONTAL);
    wxFlexGridSizer* sizer_recent = new wxFlexGridSizer(1, 2, 0, 0);
    wxStaticBoxSizer* sizer_general = new wxStaticBoxSizer(sizer_general_staticbox, wxVERTICAL);
    wxBoxSizer* sizer_lang = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_defstyle = new wxBoxSizer(wxHORIZONTAL);
    sizer_top->Add(label_title, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxADJUST_MINSIZE, 3);
    sizer_top->Add(static_line_top, 0, wxALL|wxEXPAND, 3);
    sizer_defstyle->Add(label_defstyle, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    sizer_defstyle->Add(choice_defstyle, 0, wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 0);
    sizer_general->Add(sizer_defstyle, 1, wxALL|wxEXPAND, 3);
    sizer_lang->Add(label_lang, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    sizer_lang->Add(choice_lang, 0, wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 0);
    sizer_general->Add(sizer_lang, 1, wxALL|wxEXPAND, 3);
    sizer_general->Add(check_opennewdoc, 0, wxALL|wxEXPAND, 1);
    sizer_general->Add(check_askonquit, 0, wxALL|wxEXPAND, 1);
    sizer_left->Add(sizer_general, 1, wxALL, 3);
    sizer_misc->Add(check_showstatusinfo, 0, wxALL|wxADJUST_MINSIZE, 3);
    sizer_misc->Add(check_showhtml, 0, wxALL|wxADJUST_MINSIZE, 3);
    sizer_recent->Add(label_recent, 0, wxALL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    sizer_recent->Add(spin_recent_files, 0, wxALL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    sizer_misc->Add(sizer_recent, 1, wxALL, 3);
    sizer_locationbackup->Add(label_location_backup, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    sizer_locationbackup->Add(choice_location_backup, 0, wxALIGN_CENTER_VERTICAL, 0);
    sizer_misc->Add(sizer_locationbackup, 1, wxALL, 3);
    sizer_left->Add(sizer_misc, 1, wxALL, 3);
    sizer_left->AddGrowableCol(0);
    sizer_main->Add(sizer_left, 1, wxALL, 3);
    sizer_deflocname->Add(text_deflocname, 0, wxALL|wxEXPAND|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    sizer_right->Add(sizer_deflocname, 1, wxALL|wxEXPAND, 3);
    sizer_defloc_long->Add(label_defloc_long, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    sizer_defloc_long->Add(text_deflong, 0, wxLEFT|wxRIGHT|wxEXPAND|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    sizer_defloc_long->Add(choice_ew, 0, wxLEFT|wxADJUST_MINSIZE, 3);
    sizer_defloc_long->AddGrowableCol(1);
    sizer_deflocdata->Add(sizer_defloc_long, 1, wxALL, 3);
    sizer_defloc_lat->Add(label_defloc_lat, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    sizer_defloc_lat->Add(text_deflat, 0, wxLEFT|wxRIGHT|wxEXPAND|wxALIGN_CENTER_VERTICAL, 3);
    sizer_defloc_lat->Add(choice_ns, 0, wxLEFT|wxADJUST_MINSIZE, 3);
    sizer_defloc_lat->AddGrowableCol(1);
    sizer_deflocdata->Add(sizer_defloc_lat, 1, wxALL, 3);
    sizer_right->Add(sizer_deflocdata, 1, wxALL, 3);
    sizer_defloc_zone->Add(label_defloc_tz, 0, wxALL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    sizer_defloc_zone->Add(text_timezone, 0, wxALL|wxEXPAND|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    sizer_defloc_zone->Add(choice_tzew, 0, wxALL|wxADJUST_MINSIZE, 3);
    sizer_defloc_zone->AddGrowableCol(1);
    sizer_defloc_tz->Add(sizer_defloc_zone, 1, wxALL, 3);
    sizer_defloc_dst->Add(label_defloc_dst, 0, wxALL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    sizer_defloc_dst->Add(text_dst, 0, wxALL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    sizer_defloc_dst->Add(label_defloc_dst2, 0, wxALL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    sizer_defloc_dst->AddGrowableCol(1);
    sizer_defloc_tz->Add(sizer_defloc_dst, 1, wxALL|wxEXPAND, 3);
    sizer_3->Add(label_systime, 0, wxALL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    sizer_systime2->Add(text_systime, 0, wxALL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    panel_systime->SetAutoLayout(true);
    panel_systime->SetSizer(sizer_systime2);
    sizer_3->Add(panel_systime, 1, wxEXPAND, 0);
    sizer_3->Add(80, 16, 0, wxADJUST_MINSIZE, 0);
    sizer_3->AddGrowableCol(1);
    sizer_defloc_tz->Add(sizer_3, 1, wxALL|wxEXPAND, 3);
    sizer_right->Add(sizer_defloc_tz, 1, wxALL, 3);
    sizer_right->Add(searchloc_button, 0, wxALL|wxALIGN_CENTER_HORIZONTAL, 3);
    sizer_right->AddGrowableCol(0);
    sizer_main->Add(sizer_right, 1, wxALL|wxEXPAND, 3);
    sizer_top->Add(sizer_main, 0, 0, 0);
    SetAutoLayout(true);
    SetSizer(sizer_top);
    sizer_top->Fit(this);
    sizer_top->SetSizeHints(this);
    // end wxGlade
}

/*****************************************************
**
**   ConfGeneralPanel   ---   setData 
**
******************************************************/
void ConfGeneralPanel::setData()
{
	choice_lang->Clear();
#ifdef __WXMSW__
	list<LanguageEntry>::iterator iter;
	int thelang = 0, i = 0;
	list<LanguageEntry> thelist = Session::get()->getLanguages();
	for( iter = thelist.begin(); iter != thelist.end(); iter++ )
	{
		choice_lang->Append( (*iter).name );
		if ( (*iter).code == config->lang ) thelang = i;
		i++;
	}
  choice_lang->SetSelection( thelang );
#else
  label_lang->Enable( false );
  choice_lang->Enable( false );
#endif

  config->preferVedic ? choice_defstyle->SetSelection( 0 ) : choice_defstyle->SetSelection( 1 );
  check_opennewdoc->SetValue( config->openNewDocOnStart );
  check_askonquit->SetValue( config->askOnQuit );

  check_showstatusinfo->SetValue( config->showStatusInfo );
  spin_recent_files->SetValue( config->maxRecentFiles );
	check_showhtml->SetValue( config->preferHtml2Text );
	choice_location_backup->SetSelection( config->locationBackupMode );

	setDefaultLocation( &config->defaultLocation );
  text_dst->SetValue( printfDouble( config->defaultLocation.getDST()));
}

/*****************************************************
**
**   ConfGeneralPanel   ---   saveData 
**
******************************************************/
bool ConfGeneralPanel::saveData()
{
  Formatter *formatter = Formatter::get();
  double longitude, latitude, tz;
  int ldeg, lmin, lsec, bdeg, bmin, bsec;
  wxColour color;
   
  if ( ! formatter->getDegreeIntsFromString( (const wxChar*)text_deflong->GetValue(), ldeg, lmin, lsec ))
  {
		doMessageBox( this, _("Longitude field invalid"), wxOK | wxICON_ERROR | wxCENTRE );
    return false;
  }
 
  if ( ! formatter->getDegreeIntsFromString( (const wxChar*)text_deflat->GetValue(), bdeg, bmin, bsec ))
  {
		doMessageBox( this, _("Latitude field invalid"), wxOK | wxICON_ERROR | wxCENTRE );
    return false;
  }

	list<LanguageEntry>::iterator iter;
	wxString sellang = choice_lang->GetStringSelection();
	wxString oldlang = config->lang;
	list<LanguageEntry> thelist = Session::get()->getLanguages();
	for( iter = thelist.begin(); iter != thelist.end(); iter++ )
	{
		if ( sellang == (*iter).name )
		{
			config->lang = (*iter).code;
			break;
		}
	}

  if ( config->lang != oldlang )
  {
		doMessageBox( this, _("The language will be changed when you restart the program."), wxOK | wxCENTRE );
  }

  config->preferVedic = ! choice_defstyle->GetSelection();
  config->openNewDocOnStart = check_opennewdoc->GetValue();
  config->askOnQuit = check_askonquit->GetValue();

  config->showStatusInfo = check_showstatusinfo->GetValue();
  config->maxRecentFiles = spin_recent_files->GetValue();
	config->preferHtml2Text = check_showhtml->GetValue();
	config->locationBackupMode = choice_location_backup->GetSelection();

  longitude = 3600 * ldeg + 60 * lmin + lsec;
  longitude /= 3600;
  if ( choice_ew->GetSelection() ) longitude *= -1;
 
  latitude = 3600 * bdeg + 60 * bmin + bsec;
  latitude /= 3600;
  if ( choice_ns->GetSelection() ) latitude *= -1;

	tz = myatof( text_timezone->GetValue());
	if ( choice_tzew->GetSelection()) tz *= -1;


	double d;
	if ( ! text_dst->GetValue().ToDouble( &d ) ) wxLogError( wxT( "Cannot convert time zone to double" ));
  config->defaultLocation.setLocation( text_deflocname->GetValue().c_str(), longitude, latitude, tz, d );

	return true;
}

/*****************************************************
**
**   ConfGeneralPanel   ---   setDefaultLocation 
**
******************************************************/
void ConfGeneralPanel::setDefaultLocation( Location *loc )
{
	Formatter *formatter = Formatter::get();
  double longitude, latitude;

  text_deflocname->SetValue( loc->getLocName() );
  // update longitude
  longitude = loc->getLongitude();
  text_deflong->SetValue( formatter->getDegreesFormated( fabs( longitude )));
  choice_ew->SetSelection( longitude < 0 );

  // update latitude
  latitude = loc->getLatitude();
  text_deflat->SetValue( formatter->getDegreesFormated( fabs( latitude )));
  if ( latitude >= 0 ) choice_ns->SetSelection( 0 );
  else choice_ns->SetSelection( 1 );

  text_timezone->SetValue( printfDouble( fabs( loc->getTimeZone() )));
  choice_tzew->SetSelection( loc->getTimeZone() < 0 );
}

/*****************************************************
**
**   ConfGeneralPanel   ---   OnSearchLocation 
**
******************************************************/
void ConfGeneralPanel::OnSearchLocation( wxCommandEvent &event )
{
  Location *l;
  LocationDialog dialog( this );
  if ( dialog.ShowModal() == wxID_OK )
  {
    l = dialog.getSelectedLocation();
    if ( ! l ) return;
    setDefaultLocation( l );
  }
}


