/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           ConfGeneralPanel.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifndef CONFGENERALPANEL_H
#define CONFGENERALPANEL_H

#ifdef __GNUG__
	#pragma interface "ConfGeneralPanel.h"
#endif

#include <wx/panel.h>

// begin wxGlade: dependencies
// end wxGlade

class Location;
class wxButton;
class wxCheckBox;
class wxChoice;
class wxSpinCtrl;
class wxStaticBox;
class wxStaticLine;
class wxStaticText;
class wxTextCtrl;
class wxTimer;
class wxTimerEvent;

/*****************************************************
**
**   CLASS ConfGeneralPanel  
**
******************************************************/
class ConfGeneralPanel: public wxPanel
{
public:
    // begin wxGlade: ConfGeneralPanel::ids
    // end wxGlade

	ConfGeneralPanel(wxWindow* parent, int id, const wxPoint& pos=wxDefaultPosition,
		const wxSize& size=wxDefaultSize, long style=0);
	~ConfGeneralPanel();

  void setData();
  bool saveData();

private:
    // begin wxGlade: ConfGeneralPanel::methods
    void set_properties();
    void do_layout();
    // end wxGlade
	void OnSearchLocation( wxCommandEvent& );
	void setDefaultLocation( Location* );
	void OnTimer( wxTimerEvent& );
	wxTimer *timer;
	DECLARE_CLASS( ConfGeneralPanel )
	DECLARE_EVENT_TABLE()

protected:
    // begin wxGlade: ConfGeneralPanel::attributes
    wxStaticBox* sizer_defloc_tz_staticbox;
    wxStaticBox* sizer_deflocdata_staticbox;
    wxStaticBox* sizer_deflocname_staticbox;
    wxStaticBox* sizer_misc_staticbox;
    wxStaticBox* sizer_general_staticbox;
    wxStaticText* label_title;
    wxStaticLine* static_line_top;
    wxStaticText* label_defstyle;
    wxChoice* choice_defstyle;
    wxStaticText* label_lang;
    wxChoice* choice_lang;
    wxCheckBox* check_opennewdoc;
    wxCheckBox* check_askonquit;
    wxCheckBox* check_showstatusinfo;
    wxCheckBox* check_showhtml;
    wxStaticText* label_recent;
    wxSpinCtrl* spin_recent_files;
    wxStaticText* label_location_backup;
    wxChoice* choice_location_backup;
    wxTextCtrl* text_deflocname;
    wxStaticText* label_defloc_long;
    wxTextCtrl* text_deflong;
    wxChoice* choice_ew;
    wxStaticText* label_defloc_lat;
    wxTextCtrl* text_deflat;
    wxChoice* choice_ns;
    wxStaticText* label_defloc_tz;
    wxTextCtrl* text_timezone;
    wxChoice* choice_tzew;
    wxStaticText* label_defloc_dst;
    wxTextCtrl* text_dst;
    wxStaticText* label_defloc_dst2;
    wxStaticText* label_systime;
    wxStaticText* text_systime;
    wxPanel* panel_systime;
    wxButton* searchloc_button;
    // end wxGlade
};


#endif // CONFGENERALPANEL_H
