/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           ConfMidpointPanel.cpp
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifdef __GNUG__
	#pragma implementation "ConfMidpointPanel.h"
#endif

#include "ConfMidpointPanel.h"

#include <wx/checkbox.h>
#include <wx/choice.h>
#include <wx/colordlg.h>
#include <wx/sizer.h>
#include <wx/spinctrl.h>
#include <wx/statbox.h>
#include <wx/statline.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>

#include "DialogElements.h"

#include "Base.h"
#include "constants.h"
#include "func.h"
#include "Conf.h"
#include "Lang.h"
#include "Session.h"

extern Config *config;
enum { CD_YL_CHOICE = wxID_HIGHEST + 1 };

IMPLEMENT_CLASS( ConfMidpointPanel, wxPanel )
BEGIN_EVENT_TABLE( ConfMidpointPanel, wxPanel )
	EVT_CHOICE( CD_YL_CHOICE, ConfMidpointPanel::OnYlChoice )
END_EVENT_TABLE()

/*****************************************************
**
**   ConfMidpointPanel   ---   Constructor 
**
******************************************************/
ConfMidpointPanel::ConfMidpointPanel(wxWindow* parent, int id, const wxPoint& pos, const wxSize& size, long style):
    wxPanel(parent, id, pos, size, wxTAB_TRAVERSAL)
{
    // begin wxGlade: ConfMidpointPanel::ConfMidpointPanel
    sizer_mid_remember_staticbox = new wxStaticBox(this, -1, _("Remember"));
    sizer_mid_radix_staticbox = new wxStaticBox(this, -1, _("Radix"));
    sizer_mid_transit_staticbox = new wxStaticBox(this, -1, _("Transit"));
    sizer_mid_partner_staticbox = new wxStaticBox(this, -1, _("Partner"));
    sizer_mid_general_staticbox = new wxStaticBox(this, -1, _("General"));
    label_title = new wxStaticText(this, -1, _("Midpoint Astrology"), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE);
    static_line_top = new wxStaticLine(this, -1);
    label_mid_system = new wxStaticText(this, -1, _("System"));
    const wxString choice_hssystem_choices[] = {
        _("Ebertin"),
        _("Witte")
    };
    choice_hssystem = new wxChoice(this, -1, wxDefaultPosition, wxDefaultSize, 2, choice_hssystem_choices, 0);
    label_mid_symbols = new wxStaticText(this, -1, _("Event Symbols"));
    const wxString choice_event_symbols_choices[] = {
        _("Always '='"),
        _("Use '=', '|', etc")
    };
    choice_event_symbols = new wxChoice(this, -1, wxDefaultPosition, wxDefaultSize, 2, choice_event_symbols_choices, 0);
    check_hsrememberorbis = new wxCheckBox(this, -1, _("Orbis"));
    check_hsrememberyearlength = new wxCheckBox(this, -1, _("Year Length"));
    check_hsrememberdegrees = new wxCheckBox(this, -1, _("Circle Degrees"));
    check_hsremembertransitmode = new wxCheckBox(this, -1, _("Transit Mode"));
    label_mid_radix_orbis = new wxStaticText(this, -1, _("Orbis"));
    spin_hsradixorbis = new wxSpinCtrl(this, -1, wxT(""), wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 0, 300);
    label_mid_radix_orbis2 = new wxStaticText(this, -1, _("Min"));
    label_mid_radix_deg = new wxStaticText(this, -1, _("Circle Degrees"));
    choice_hsradixcircle = new CircleDegreeChoice(this, -1);
    label_mid_transit_orbis = new wxStaticText(this, -1, _("Orbis"));
    spin_hstransitorbis = new wxSpinCtrl(this, -1, wxT(""), wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 0, 300);
    label_mid_transit_orbis2 = new wxStaticText(this, -1, _("Min"));
    choice_hstransitcircle = new CircleDegreeChoice(this, -1);
    choice_hstransityearlength = new YearLengthChoice(this, CD_YL_CHOICE, false);
    text_custom_yl = new wxTextCtrl(this, -1, wxT(""));
    choice_hstransitmode = new TransitModeChoice(this, -1);
    label_mid_partner_orbis = new wxStaticText(this, -1, _("Orbis"));
    spin_hspartnerorbis = new wxSpinCtrl(this, -1, wxT(""), wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 0, 300);
    label_mid_partner_orbis2 = new wxStaticText(this, -1, _("Min"));
    label_mid_partner_deg = new wxStaticText(this, -1, _("Circle Degrees"));
    choice_hspartnercircle = new CircleDegreeChoice(this, -1);

    set_properties();
    do_layout();
    // end wxGlade
}


/*****************************************************
**
**   ConfMidpointPanel   ---   set_properties 
**
******************************************************/
void ConfMidpointPanel::set_properties()
{
    // begin wxGlade: ConfMidpointPanel::set_properties
    label_title->SetFont(wxFont(12, wxDEFAULT, wxNORMAL, wxBOLD, 0, wxT("")));
    label_mid_system->SetMinSize(wxSize(120, 16));
    choice_hssystem->SetMinSize(wxSize(140, 25));
    choice_hssystem->SetSelection(0);
    label_mid_symbols->SetMinSize(wxSize(120, 17));
    choice_event_symbols->SetMinSize(wxSize(140, 25));
    choice_event_symbols->SetSelection(0);
    label_mid_radix_orbis->SetMinSize(wxSize(120, 16));
    spin_hsradixorbis->SetMinSize(wxSize(60, 24));
    label_mid_radix_orbis2->SetMinSize(wxSize(40, 16));
    label_mid_radix_deg->SetMinSize(wxSize(120, 16));
    choice_hsradixcircle->SetMinSize(wxSize(120, 29));
    label_mid_transit_orbis->SetMinSize(wxSize(120, 16));
    spin_hstransitorbis->SetMinSize(wxSize(60, 24));
    label_mid_transit_orbis2->SetMinSize(wxSize(40, 16));
    choice_hstransitcircle->SetMinSize(wxSize(120, 29));
    choice_hstransityearlength->SetMinSize(wxSize(120, 29));
    text_custom_yl->SetMinSize(wxSize(120, 23));
    choice_hstransitmode->SetMinSize(wxSize(120, 29));
    label_mid_partner_orbis->SetMinSize(wxSize(120, 16));
    spin_hspartnerorbis->SetMinSize(wxSize(60, 24));
    label_mid_partner_orbis2->SetMinSize(wxSize(40, 16));
    label_mid_partner_deg->SetMinSize(wxSize(120, 16));
    choice_hspartnercircle->SetMinSize(wxSize(120, 29));
    // end wxGlade
}


/*****************************************************
**
**   ConfMidpointPanel   ---   do_layout 
**
******************************************************/
void ConfMidpointPanel::do_layout()
{
    // begin wxGlade: ConfMidpointPanel::do_layout
    wxBoxSizer* sizer_top = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* sizer_1 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_nb4 = new wxBoxSizer(wxHORIZONTAL);
    wxFlexGridSizer* sizer_nb4b = new wxFlexGridSizer(2, 1, 0, 0);
    wxStaticBoxSizer* sizer_mid_partner = new wxStaticBoxSizer(sizer_mid_partner_staticbox, wxVERTICAL);
    wxBoxSizer* sizer_mid_partner_deg = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_mid_partner_orbis = new wxBoxSizer(wxHORIZONTAL);
    wxStaticBoxSizer* sizer_mid_transit = new wxStaticBoxSizer(sizer_mid_transit_staticbox, wxVERTICAL);
    wxBoxSizer* sizer_mid_transit_mode = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_custom_yl = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_mid_transit_yl = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_mid_transit_deg = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_mid_transit_orbis = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_nb4a = new wxBoxSizer(wxVERTICAL);
    wxStaticBoxSizer* sizer_mid_radix = new wxStaticBoxSizer(sizer_mid_radix_staticbox, wxVERTICAL);
    wxBoxSizer* sizer_mid_radix_deg = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_mid_radix_orbis = new wxBoxSizer(wxHORIZONTAL);
    wxStaticBoxSizer* sizer_mid_remember = new wxStaticBoxSizer(sizer_mid_remember_staticbox, wxVERTICAL);
    wxGridSizer* grid_sizer_mid_remember = new wxGridSizer(2, 2, 3, 3);
    wxStaticBoxSizer* sizer_mid_general = new wxStaticBoxSizer(sizer_mid_general_staticbox, wxVERTICAL);
    wxBoxSizer* sizer_mid_sysmbols = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_mid_system = new wxBoxSizer(wxHORIZONTAL);
    sizer_top->Add(label_title, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxADJUST_MINSIZE, 3);
    sizer_top->Add(static_line_top, 0, wxALL|wxEXPAND, 3);
    sizer_mid_system->Add(label_mid_system, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    sizer_mid_system->Add(choice_hssystem, 0, 0, 0);
    sizer_mid_general->Add(sizer_mid_system, 1, wxALL, 3);
    sizer_mid_sysmbols->Add(label_mid_symbols, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    sizer_mid_sysmbols->Add(choice_event_symbols, 0, 0, 0);
    sizer_mid_general->Add(sizer_mid_sysmbols, 1, wxALL, 3);
    sizer_nb4a->Add(sizer_mid_general, 1, wxALL, 3);
    grid_sizer_mid_remember->Add(check_hsrememberorbis, 0, 0, 0);
    grid_sizer_mid_remember->Add(check_hsrememberyearlength, 0, 0, 0);
    grid_sizer_mid_remember->Add(check_hsrememberdegrees, 0, 0, 0);
    grid_sizer_mid_remember->Add(check_hsremembertransitmode, 0, 0, 0);
    sizer_mid_remember->Add(grid_sizer_mid_remember, 1, wxALL|wxEXPAND, 3);
    sizer_nb4a->Add(sizer_mid_remember, 1, wxALL, 3);
    sizer_mid_radix_orbis->Add(label_mid_radix_orbis, 0, wxLEFT|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    sizer_mid_radix_orbis->Add(spin_hsradixorbis, 0, wxADJUST_MINSIZE, 0);
    sizer_mid_radix_orbis->Add(label_mid_radix_orbis2, 0, wxLEFT|wxALIGN_CENTER_VERTICAL, 10);
    sizer_mid_radix->Add(sizer_mid_radix_orbis, 1, wxALL, 3);
    sizer_mid_radix_deg->Add(label_mid_radix_deg, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    sizer_mid_radix_deg->Add(choice_hsradixcircle, 1, wxLEFT|wxEXPAND|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    sizer_mid_radix->Add(sizer_mid_radix_deg, 1, wxALL|wxEXPAND, 3);
    sizer_nb4a->Add(sizer_mid_radix, 1, wxALL, 3);
    sizer_nb4->Add(sizer_nb4a, 1, wxALL, 3);
    sizer_mid_transit_orbis->Add(label_mid_transit_orbis, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    sizer_mid_transit_orbis->Add(spin_hstransitorbis, 0, wxADJUST_MINSIZE, 0);
    sizer_mid_transit_orbis->Add(label_mid_transit_orbis2, 0, wxLEFT|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 10);
    sizer_mid_transit->Add(sizer_mid_transit_orbis, 1, wxALL, 3);
    wxStaticText* label_mid_transit_deg = new wxStaticText(this, -1, _("Circle Degrees"));
    label_mid_transit_deg->SetMinSize(wxSize(120, 16));
    sizer_mid_transit_deg->Add(label_mid_transit_deg, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    sizer_mid_transit_deg->Add(choice_hstransitcircle, 1, wxLEFT|wxEXPAND, 0);
    sizer_mid_transit->Add(sizer_mid_transit_deg, 1, wxALL|wxEXPAND, 3);
    wxStaticText* label_mid_transit_yl = new wxStaticText(this, -1, _("Year Length"));
    label_mid_transit_yl->SetMinSize(wxSize(120, 16));
    sizer_mid_transit_yl->Add(label_mid_transit_yl, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    sizer_mid_transit_yl->Add(choice_hstransityearlength, 1, wxLEFT, 0);
    sizer_mid_transit->Add(sizer_mid_transit_yl, 1, wxALL|wxEXPAND, 3);
    wxStaticText* label_mid_transit_customyl = new wxStaticText(this, -1, _("Custom Length"));
    label_mid_transit_customyl->SetMinSize(wxSize(120, 16));
    sizer_custom_yl->Add(label_mid_transit_customyl, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    sizer_custom_yl->Add(text_custom_yl, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    sizer_mid_transit->Add(sizer_custom_yl, 1, wxALL, 3);
    wxStaticText* label_mid_transit_mode = new wxStaticText(this, -1, _("Transit Modus"));
    label_mid_transit_mode->SetMinSize(wxSize(120, 16));
    sizer_mid_transit_mode->Add(label_mid_transit_mode, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    sizer_mid_transit_mode->Add(choice_hstransitmode, 1, wxLEFT, 0);
    sizer_mid_transit->Add(sizer_mid_transit_mode, 1, wxALL|wxEXPAND, 3);
    sizer_nb4b->Add(sizer_mid_transit, 1, wxALL, 3);
    sizer_mid_partner_orbis->Add(label_mid_partner_orbis, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    sizer_mid_partner_orbis->Add(spin_hspartnerorbis, 0, wxADJUST_MINSIZE, 0);
    sizer_mid_partner_orbis->Add(label_mid_partner_orbis2, 0, wxLEFT|wxALIGN_CENTER_VERTICAL, 10);
    sizer_mid_partner->Add(sizer_mid_partner_orbis, 1, wxALL, 3);
    sizer_mid_partner_deg->Add(label_mid_partner_deg, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    sizer_mid_partner_deg->Add(choice_hspartnercircle, 1, wxLEFT|wxEXPAND, 0);
    sizer_mid_partner->Add(sizer_mid_partner_deg, 1, wxALL|wxEXPAND, 3);
    sizer_nb4b->Add(sizer_mid_partner, 1, wxALL, 3);
    sizer_nb4b->AddGrowableRow(0);
    sizer_nb4b->AddGrowableRow(1);
    sizer_nb4b->AddGrowableCol(0);
    sizer_nb4->Add(sizer_nb4b, 1, wxALL, 3);
    sizer_1->Add(sizer_nb4, 1, wxEXPAND, 0);
    sizer_top->Add(sizer_1, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxADJUST_MINSIZE, 3);
    SetAutoLayout(true);
    SetSizer(sizer_top);
    sizer_top->Fit(this);
    sizer_top->SetSizeHints(this);
    // end wxGlade
}

/*****************************************************
**
**   ConfMidpointPanel   ---   setData 
**
******************************************************/
void ConfMidpointPanel::setData()
{
  choice_hssystem->SetSelection( config->hsSystem );
  choice_event_symbols->SetSelection( config->hsUseSpecialEventSymbols );
  check_hsrememberorbis->SetValue( config->hsRememberOrbis );
  check_hsrememberdegrees->SetValue( config->hsRememberGradkreis );
  check_hsrememberyearlength->SetValue( config->hsRememberYearLength );
  check_hsremembertransitmode->SetValue( config->hsRememberTransitModus );

  spin_hsradixorbis->SetValue( config->wOrbisRadix );
  choice_hsradixcircle->SetSelection( config->hsGradkreisRadix );

  spin_hstransitorbis->SetValue( config->wOrbisTransit );
  choice_hstransitcircle->SetSelection( config->hsGradkreisTransit );
  choice_hstransityearlength->SetSelection( config->hsYearLength );
	text_custom_yl->SetValue( printfDouble( config->hsCustomYearLength ));
	text_custom_yl->Enable( choice_hstransityearlength->GetSelection() == 4 );
  choice_hstransitmode->SetSelection( config->hsTransitModus );
  
  spin_hspartnerorbis->SetValue( config->wOrbisPartner );
  choice_hspartnercircle->SetSelection( config->hsGradkreisPartner );
}

/*****************************************************
**
**   ConfMidpointPanel   ---   saveData 
**
******************************************************/
bool ConfMidpointPanel::saveData()
{

  config->hsSystem = choice_hssystem->GetSelection();
  config->hsUseSpecialEventSymbols = choice_event_symbols->GetSelection();
  config->hsRememberOrbis = check_hsrememberorbis->GetValue();
  config->hsRememberGradkreis = check_hsrememberdegrees->GetValue();
  config->hsRememberYearLength = check_hsrememberyearlength->GetValue();
  config->hsRememberTransitModus = check_hsremembertransitmode->GetValue();

  config->wOrbisRadix = spin_hsradixorbis->GetValue();
  config->hsGradkreisRadix = choice_hsradixcircle->GetSelection();

  config->wOrbisTransit = spin_hstransitorbis->GetValue();
  config->hsGradkreisTransit = choice_hstransitcircle->GetSelection();
  config->hsYearLength = choice_hstransityearlength->GetSelection();
	config->hsCustomYearLength = myatof( text_custom_yl->GetValue() );
	if ( config->hsCustomYearLength < 0 ) config->hsCustomYearLength = WCUSTOM_YEAR_LEN;
  config->hsTransitModus = choice_hstransitmode->GetSelection();

  config->wOrbisPartner = spin_hspartnerorbis->GetValue();
  config->hsGradkreisPartner = choice_hspartnercircle->GetSelection();

	return true;
}

/*****************************************************
**
**   ConfMidpointPanel   ---   OnYlChoice
**
******************************************************/
void ConfMidpointPanel::OnYlChoice( wxCommandEvent &event )
{
	text_custom_yl->Enable( choice_hstransityearlength->GetSelection() == 4 );
}



