/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           ConfMidpointPanel.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifndef CONFMIDPOINTPANEL_H
#define CONFMIDPOINTPANEL_H

#ifdef __GNUG__
	#pragma interface "ConfMidpointPanel.h"
#endif

#include <wx/panel.h>

// begin wxGlade: dependencies
// end wxGlade

class YearLengthChoice;
class CircleDegreeChoice;
class TransitModeChoice;
class wxCheckBox;
class wxChoice;
class wxSpinCtrl;
class wxStaticBox;
class wxStaticLine;
class wxStaticText;
class wxTextCtrl;

/*****************************************************
**
**   CLASS ConfMidpointPanel  
**
******************************************************/
class ConfMidpointPanel: public wxPanel
{
	DECLARE_CLASS( ConfMidpointPanel )
public:
    // begin wxGlade: ConfMidpointPanel::ids
    // end wxGlade

    ConfMidpointPanel(wxWindow* parent, int id, const wxPoint& pos=wxDefaultPosition, const wxSize& size=wxDefaultSize, long style=0);
	void setData();
	bool saveData();
	DECLARE_EVENT_TABLE()

private:
    // begin wxGlade: ConfMidpointPanel::methods
    void set_properties();
    void do_layout();
    // end wxGlade
	void OnYlChoice( wxCommandEvent& );

protected:
    // begin wxGlade: ConfMidpointPanel::attributes
    wxStaticBox* sizer_mid_partner_staticbox;
    wxStaticBox* sizer_mid_transit_staticbox;
    wxStaticBox* sizer_mid_radix_staticbox;
    wxStaticBox* sizer_mid_remember_staticbox;
    wxStaticBox* sizer_mid_general_staticbox;
    wxStaticText* label_title;
    wxStaticLine* static_line_top;
    wxStaticText* label_mid_system;
    wxChoice* choice_hssystem;
    wxStaticText* label_mid_symbols;
    wxChoice* choice_event_symbols;
    wxCheckBox* check_hsrememberorbis;
    wxCheckBox* check_hsrememberyearlength;
    wxCheckBox* check_hsrememberdegrees;
    wxCheckBox* check_hsremembertransitmode;
    wxStaticText* label_mid_radix_orbis;
    wxSpinCtrl* spin_hsradixorbis;
    wxStaticText* label_mid_radix_orbis2;
    wxStaticText* label_mid_radix_deg;
    CircleDegreeChoice* choice_hsradixcircle;
    wxStaticText* label_mid_transit_orbis;
    wxSpinCtrl* spin_hstransitorbis;
    wxStaticText* label_mid_transit_orbis2;
    CircleDegreeChoice* choice_hstransitcircle;
    YearLengthChoice* choice_hstransityearlength;
    wxTextCtrl* text_custom_yl;
    TransitModeChoice* choice_hstransitmode;
    wxStaticText* label_mid_partner_orbis;
    wxSpinCtrl* spin_hspartnerorbis;
    wxStaticText* label_mid_partner_orbis2;
    wxStaticText* label_mid_partner_deg;
    CircleDegreeChoice* choice_hspartnercircle;
    // end wxGlade
};


#endif // CONFMIDPOINTPANEL_H
