/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           ConfVedicCalcPanel.cpp
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/
    
#ifdef __GNUG__
	#pragma implementation "ConfVedicCalcPanel.h"
#endif

#include "ConfVedicCalcPanel.h"
#include "DialogElements.h"

#include <wx/checkbox.h>
#include <wx/choice.h>
#include <wx/sizer.h>
#include <wx/statbox.h>
#include <wx/statline.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>

#include "Base.h"  

#include "func.h"
#include "Conf.h"
#include "Lang.h"

extern Config *config;
enum { CD_YL_CHOICE = wxID_HIGHEST + 1 };

IMPLEMENT_CLASS( ConfVedicCalcPanel, wxPanel )
BEGIN_EVENT_TABLE( ConfVedicCalcPanel, wxPanel )
	EVT_CHOICE( CD_YL_CHOICE, ConfVedicCalcPanel::OnYlChoice )
END_EVENT_TABLE()
 
/*****************************************************
**
**   ConfVedicCalcPanel   ---   Constructor 
**
******************************************************/
ConfVedicCalcPanel::ConfVedicCalcPanel(wxWindow* parent, int id, const wxPoint& pos, const wxSize& size, long style):
    wxPanel(parent, id, pos, size, wxTAB_TRAVERSAL)
{
    // begin wxGlade: ConfVedicCalcPanel::ConfVedicCalcPanel
    sizer_yl_staticbox = new wxStaticBox(this, -1, _("Year Length"));
    sizer_advanced_staticbox = new wxStaticBox(this, -1, _("Advanced"));
    sizer_sunrise_staticbox = new wxStaticBox(this, -1, _("Sunrise and Sunset"));
    sizer_basic_staticbox = new wxStaticBox(this, -1, _("Basic Calculation"));
    label_title = new wxStaticText(this, -1, _("Calculation in Vedic Astrology"), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE);
    static_line_top = new wxStaticLine(this, -1);
    label_vcalc_aya = new wxStaticText(this, -1, _("Ayanamsa"));
    choice_vcalc_aya = new AyanamsaChoice(this, -1, config->iAyanamsa);
    label_vcalc_node = new wxStaticText(this, -1, _("Lunar Node"));
    const wxString choice_node_choices[] = {
        _("True"),
        _("Mean")
    };
    choice_node = new wxChoice(this, -1, wxDefaultPosition, wxDefaultSize, 2, choice_node_choices, 0);
    label_vcalc_house = new wxStaticText(this, -1, _("House System"));
    const wxString choice_house_choices[] = {
        _("Placidus"),
        _("Koch"),
        _("Regiomontanus"),
        _("Campanus"),
        _("Porphyry"),
        _("Equal"),
        _("Vehlow Equal"),
        _("Axial Rotation"),
        _("Azimutal/Horizontal"),
        _("Polich/Page"),
        _("Alcabitus"),
        _("Morinus")
    };
    choice_house = new wxChoice(this, -1, wxDefaultPosition, wxDefaultSize, 12, choice_house_choices, 0);
    check_westernhouse = new wxCheckBox(this, -1, _("K.P. Style Houses (Start at Cusp)"));
    label_vcalc_arudha = new wxStaticText(this, -1, _("Arudhas"));
    const wxString choice_arudha_choices[] = {
        _("Parasara"),
        _("Raman")
    };
    choice_arudha = new wxChoice(this, -1, wxDefaultPosition, wxDefaultSize, 2, choice_arudha_choices, 0);
    label_vcalc_ashta = new wxStaticText(this, -1, _("Ashtakavarga"));
    const wxString choice_ashtaka_choices[] = {
        _("Parasara"),
        _("Vahara Mihira")
    };
    choice_ashtaka = new wxChoice(this, -1, wxDefaultPosition, wxDefaultSize, 2, choice_ashtaka_choices, 0);
    choice_yl = new YearLengthChoice(this, CD_YL_CHOICE, true);
    text_custom_yl = new wxTextCtrl(this, -1, wxT(""));
    label_vcalc_naks = new wxStaticText(this, -1, _("Nakshatras"));
    const wxString choice_naks_choices[] = {
        _("27"),
        _("28")
    };
    choice_naks = new wxChoice(this, -1, wxDefaultPosition, wxDefaultSize, 2, choice_naks_choices, 0);
    label_vcalc_dasa = new wxStaticText(this, -1, _("Nakshatra Dasas"));
    const wxString choice_nakdasa_choices[] = {
        _("Length"),
        _("Entry Time")
    };
    choice_nakdasa = new wxChoice(this, -1, wxDefaultPosition, wxDefaultSize, 2, choice_nakdasa_choices, 0);
    label_kalachakra = new wxStaticText(this, -1, _("Kalachakra"));
    const wxString choice_kala_choices[] = {
        _("Progressive"),
        _("Cyclic"),
        _("Progr. same Nakshatra"),
        _("Portion Zero")
    };
    choice_kala = new wxChoice(this, -1, wxDefaultPosition, wxDefaultSize, 4, choice_kala_choices, 0);
    label_sunrise_disk = new wxStaticText(this, -1, _("Reference Point"));
    const wxString choice_sunrise_disk_choices[] = {
        _("Center of Disk"),
        _("Edge of Disk")
    };
    choice_sunrise_disk = new wxChoice(this, -1, wxDefaultPosition, wxDefaultSize, 2, choice_sunrise_disk_choices, 0);
    check_sunrise_refrac = new wxCheckBox(this, -1, _("Use Refraction"));

    set_properties();
    do_layout();
    // end wxGlade
}

/*****************************************************
**
**   ConfVedicCalcPanel   ---   setData 
**
******************************************************/
void ConfVedicCalcPanel::setData()
{
  choice_house->SetSelection( config->iHouseSystem ? config->iHouseSystem -1 : 0 );
  check_westernhouse->SetValue( config->iHouseWestern );
  choice_node->SetSelection( config->iLunarNodeMode );

  choice_yl->SetSelection( config->iYearLength );
	text_custom_yl->SetValue( printfDouble( config->iCustomYearLength ));
	text_custom_yl->Enable( choice_yl->GetSelection() == 4 );

  choice_arudha->SetSelection( config->iArudhaMode );
  choice_naks->SetSelection( config->iNakshatraMode28 );
  choice_ashtaka->SetSelection( config->iAshtakavargaMode );
  choice_nakdasa->SetSelection( config->iNakshatraPortionMode );
  choice_kala->SetSelection( config->iKalachakraMode );

  choice_sunrise_disk->SetSelection( config->sunrise_def );
  check_sunrise_refrac->SetValue( config->sunrise_refrac );
}

/*****************************************************
**
**   ConfVedicCalcPanel   ---   saveData 
**
******************************************************/
bool ConfVedicCalcPanel::saveData()
{
  config->iHouseSystem = choice_house->GetSelection() + 1;
  config->iHouseWestern = check_westernhouse->GetValue();
  config->iLunarNodeMode = choice_node->GetSelection();
	config->iAyanamsa = choice_vcalc_aya->getConfigIndex();

  config->iYearLength = choice_yl->GetSelection();
	config->iCustomYearLength = myatof( text_custom_yl->GetValue() );
	if ( config->iCustomYearLength < 0 ) config->iCustomYearLength = ICUSTOM_YEAR_LEN;

  config->iArudhaMode = choice_arudha->GetSelection();
  config->iNakshatraMode28 = choice_naks->GetSelection();
  config->iAshtakavargaMode = choice_ashtaka->GetSelection();
  config->iNakshatraPortionMode = choice_nakdasa->GetSelection();
  config->iKalachakraMode = choice_kala->GetSelection();

  config->sunrise_def = choice_sunrise_disk->GetSelection();
  config->sunrise_refrac = check_sunrise_refrac->GetValue();
	return true;
}

/*****************************************************
**
**   ConfVedicCalcPanel   ---   OnYlChoice
**
******************************************************/
void ConfVedicCalcPanel::OnYlChoice( wxCommandEvent &event )
{
	text_custom_yl->Enable( choice_yl->GetSelection() == 4 );
}

/*****************************************************
**
**   ConfVedicCalcPanel   ---   set_properties 
**
******************************************************/
void ConfVedicCalcPanel::set_properties()
{
    // begin wxGlade: ConfVedicCalcPanel::set_properties
    label_title->SetFont(wxFont(12, wxDEFAULT, wxNORMAL, wxBOLD, 0, wxT("")));
    label_vcalc_aya->SetMinSize(wxSize(120, 16));
    label_vcalc_node->SetMinSize(wxSize(120, 16));
    choice_node->SetToolTip(_("Mean Node is most frequently used in Vedic Astrology"));
    choice_node->SetSelection(0);
    label_vcalc_house->SetMinSize(wxSize(120, 16));
    choice_house->SetSelection(0);
    check_westernhouse->SetToolTip(_("Checked: houses start a cusp; Unchecked: cusp is middle of house"));
    label_vcalc_arudha->SetMinSize(wxSize(120, 16));
    choice_arudha->SetSelection(0);
    label_vcalc_ashta->SetMinSize(wxSize(120, 16));
    choice_ashtaka->SetSelection(0);
    label_vcalc_naks->SetMinSize(wxSize(120, 16));
    choice_naks->SetSelection(0);
    label_vcalc_dasa->SetMinSize(wxSize(120, 16));
    choice_nakdasa->SetSelection(0);
    label_kalachakra->SetMinSize(wxSize(120, 16));
    choice_kala->SetSelection(0);
    label_sunrise_disk->SetMinSize(wxSize(120, 16));
    choice_sunrise_disk->SetSelection(0);
    check_sunrise_refrac->SetToolTip(_("Checked: apparent position will be used"));
    // end wxGlade
}

/*****************************************************
**
**   ConfVedicCalcPanel   ---   do_layout 
**
******************************************************/
void ConfVedicCalcPanel::do_layout()
{
    // begin wxGlade: ConfVedicCalcPanel::do_layout
    wxBoxSizer* sizer_top = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* sizer_main = new wxBoxSizer(wxHORIZONTAL);
    wxFlexGridSizer* sizer_right = new wxFlexGridSizer(1, 1, 0, 0);
    wxStaticBoxSizer* sizer_sunrise = new wxStaticBoxSizer(sizer_sunrise_staticbox, wxVERTICAL);
    wxBoxSizer* sizer_sunrise_disk = new wxBoxSizer(wxHORIZONTAL);
    wxStaticBoxSizer* sizer_advanced = new wxStaticBoxSizer(sizer_advanced_staticbox, wxVERTICAL);
    wxBoxSizer* sizer_kalachakra = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_vcalc_dasa = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_vcalc_naks = new wxBoxSizer(wxHORIZONTAL);
    wxFlexGridSizer* sizer_left = new wxFlexGridSizer(1, 1, 0, 0);
    wxStaticBoxSizer* sizer_yl = new wxStaticBoxSizer(sizer_yl_staticbox, wxVERTICAL);
    wxBoxSizer* sizer_custom_yl = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_yl2 = new wxBoxSizer(wxHORIZONTAL);
    wxStaticBoxSizer* sizer_basic = new wxStaticBoxSizer(sizer_basic_staticbox, wxVERTICAL);
    wxBoxSizer* sizer_vcalc_ashta = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_vcalc_arudha = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_vcalc_house = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_vcalc_node = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_vcalc_aya = new wxBoxSizer(wxHORIZONTAL);
    sizer_top->Add(label_title, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxADJUST_MINSIZE, 3);
    sizer_top->Add(static_line_top, 0, wxALL|wxEXPAND, 3);
    sizer_vcalc_aya->Add(label_vcalc_aya, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    sizer_vcalc_aya->Add(choice_vcalc_aya, 1, wxALIGN_CENTER_HORIZONTAL, 0);
    sizer_basic->Add(sizer_vcalc_aya, 1, wxALL|wxEXPAND, 3);
    sizer_vcalc_node->Add(label_vcalc_node, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    sizer_vcalc_node->Add(choice_node, 0, wxEXPAND|wxALIGN_CENTER_VERTICAL, 0);
    sizer_basic->Add(sizer_vcalc_node, 1, wxALL|wxEXPAND, 3);
    sizer_vcalc_house->Add(label_vcalc_house, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    sizer_vcalc_house->Add(choice_house, 0, wxALIGN_CENTER_VERTICAL, 0);
    sizer_basic->Add(sizer_vcalc_house, 1, wxALL|wxEXPAND, 3);
    sizer_basic->Add(check_westernhouse, 0, wxALL, 3);
    sizer_vcalc_arudha->Add(label_vcalc_arudha, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    sizer_vcalc_arudha->Add(choice_arudha, 0, wxEXPAND|wxALIGN_CENTER_VERTICAL, 0);
    sizer_basic->Add(sizer_vcalc_arudha, 1, wxALL|wxEXPAND, 3);
    sizer_vcalc_ashta->Add(label_vcalc_ashta, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    sizer_vcalc_ashta->Add(choice_ashtaka, 0, wxEXPAND|wxALIGN_CENTER_VERTICAL, 0);
    sizer_basic->Add(sizer_vcalc_ashta, 1, wxALL|wxEXPAND, 3);
    sizer_left->Add(sizer_basic, 1, wxALL, 3);
    wxStaticText* label_yl = new wxStaticText(this, -1, _("Length"));
    label_yl->SetMinSize(wxSize(120, 16));
    sizer_yl2->Add(label_yl, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    sizer_yl2->Add(choice_yl, 1, wxLEFT|wxEXPAND|wxADJUST_MINSIZE, 0);
    sizer_yl->Add(sizer_yl2, 1, wxALL|wxEXPAND, 3);
    wxStaticText* label_customyl = new wxStaticText(this, -1, _("Custom Length"));
    label_customyl->SetMinSize(wxSize(120, 16));
    sizer_custom_yl->Add(label_customyl, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    sizer_custom_yl->Add(text_custom_yl, 0, wxEXPAND|wxALIGN_CENTER_VERTICAL, 0);
    sizer_yl->Add(sizer_custom_yl, 1, wxALL|wxEXPAND, 3);
    sizer_left->Add(sizer_yl, 1, wxEXPAND, 0);
    sizer_main->Add(sizer_left, 1, wxEXPAND, 0);
    sizer_vcalc_naks->Add(label_vcalc_naks, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    sizer_vcalc_naks->Add(choice_naks, 0, wxEXPAND|wxALIGN_CENTER_VERTICAL, 0);
    sizer_advanced->Add(sizer_vcalc_naks, 1, wxALL|wxEXPAND, 3);
    sizer_vcalc_dasa->Add(label_vcalc_dasa, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    sizer_vcalc_dasa->Add(choice_nakdasa, 0, wxEXPAND, 0);
    sizer_advanced->Add(sizer_vcalc_dasa, 1, wxALL|wxEXPAND, 3);
    sizer_kalachakra->Add(label_kalachakra, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    sizer_kalachakra->Add(choice_kala, 0, wxEXPAND, 0);
    sizer_advanced->Add(sizer_kalachakra, 1, wxALL|wxEXPAND, 3);
    sizer_right->Add(sizer_advanced, 1, 0, 0);
    sizer_sunrise_disk->Add(label_sunrise_disk, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    sizer_sunrise_disk->Add(choice_sunrise_disk, 0, wxEXPAND, 0);
    sizer_sunrise->Add(sizer_sunrise_disk, 1, wxALL|wxEXPAND, 3);
    sizer_sunrise->Add(check_sunrise_refrac, 0, wxALL, 3);
    sizer_right->Add(sizer_sunrise, 1, wxEXPAND, 0);
    sizer_main->Add(sizer_right, 1, wxEXPAND, 0);
    sizer_top->Add(sizer_main, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxADJUST_MINSIZE, 3);
    SetAutoLayout(true);
    SetSizer(sizer_top);
    sizer_top->Fit(this);
    sizer_top->SetSizeHints(this);
    // end wxGlade
}

