/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           ConfVedicCalcPanel.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/
    

#ifndef CONFVEDICCALCPANEL_H
#define CONFVEDICCALCPANEL_H

#ifdef __GNUG__
	#pragma interface "ConfVedicCalcPanel.h"
#endif

#include <wx/panel.h>

// begin wxGlade: dependencies
// end wxGlade

class AyanamsaChoice;
class YearLengthChoice;
class wxCheckBox;
class wxChoice;
class wxStaticBox;
class wxStaticLine;
class wxStaticText;
class wxTextCtrl;

/*****************************************************
**
**   CLASS ConfVedicCalcPanel  
**
******************************************************/
class ConfVedicCalcPanel: public wxPanel
{
	DECLARE_CLASS( ConfVedicCalcPanel )
public:
    // begin wxGlade: ConfVedicCalcPanel::ids
    // end wxGlade

    ConfVedicCalcPanel(wxWindow* parent, int id, const wxPoint& pos=wxDefaultPosition,
			const wxSize& size=wxDefaultSize, long style=0);

	void setData();
  bool saveData();
  DECLARE_EVENT_TABLE()

private:
    // begin wxGlade: ConfVedicCalcPanel::methods
    void set_properties();
    void do_layout();
    // end wxGlade
	void OnYlChoice( wxCommandEvent& );

protected:
    // begin wxGlade: ConfVedicCalcPanel::attributes
    wxStaticBox* sizer_sunrise_staticbox;
    wxStaticBox* sizer_advanced_staticbox;
    wxStaticBox* sizer_yl_staticbox;
    wxStaticBox* sizer_basic_staticbox;
    wxStaticText* label_title;
    wxStaticLine* static_line_top;
    wxStaticText* label_vcalc_aya;
    AyanamsaChoice* choice_vcalc_aya;
    wxStaticText* label_vcalc_node;
    wxChoice* choice_node;
    wxStaticText* label_vcalc_house;
    wxChoice* choice_house;
    wxCheckBox* check_westernhouse;
    wxStaticText* label_vcalc_arudha;
    wxChoice* choice_arudha;
    wxStaticText* label_vcalc_ashta;
    wxChoice* choice_ashtaka;
    YearLengthChoice* choice_yl;
    wxTextCtrl* text_custom_yl;
    wxStaticText* label_vcalc_naks;
    wxChoice* choice_naks;
    wxStaticText* label_vcalc_dasa;
    wxChoice* choice_nakdasa;
    wxStaticText* label_kalachakra;
    wxChoice* choice_kala;
    wxStaticText* label_sunrise_disk;
    wxChoice* choice_sunrise_disk;
    wxCheckBox* check_sunrise_refrac;
    // end wxGlade
};


#endif // CONFVEDICCALCPANEL_H
