/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           ConfVedicPanel.cpp
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifdef __GNUG__
	#pragma implementation "ConfVedicPanel.h"
#endif

#include "ConfVedicPanel.h"

#include <wx/checkbox.h>
#include <wx/cmndata.h>
#include <wx/choice.h>
#include <wx/colour.h>
#include <wx/colordlg.h>
#include <wx/sizer.h>
#include <wx/statbox.h>
#include <wx/statline.h>
#include <wx/stattext.h>

#include "Base.h"

#include "func.h"
#include "Conf.h"
#include "Lang.h"

extern Config *config;

IMPLEMENT_CLASS( ConfVedicPanel, wxPanel )

/*****************************************************
**
**   ConfVedicPanel   ---   Constructor 
**
******************************************************/
ConfVedicPanel::ConfVedicPanel(wxWindow* parent, int id, const wxPoint& pos, const wxSize& size, long style):
    wxPanel(parent, id, pos, size, wxTAB_TRAVERSAL)
{
    // begin wxGlade: ConfVedicPanel::ConfVedicPanel
    sizer_maincols_staticbox = new wxStaticBox(this, -1, _("Columns in Main Window"));
    sizer_mainrows_staticbox = new wxStaticBox(this, -1, _("Rows in Main Window"));
    sizer_vcharts_staticbox = new wxStaticBox(this, -1, _("Charts"));
    label_title = new wxStaticText(this, -1, _("Vedic Astrology"), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE);
    static_line_top = new wxStaticLine(this, -1);
    label_chartstyle = new wxStaticText(this, -1, _("Style"));
    const wxString choice_ichart_choices[] = {
        _("South Indian"),
        _("North Indian"),
        _("East Indian")
    };
    choice_ichart = new wxChoice(this, -1, wxDefaultPosition, wxDefaultSize, 3, choice_ichart_choices, 0);
    check_iraudhas = new wxCheckBox(this, -1, _("Show Arudhas"));
    check_iascendants = new wxCheckBox(this, -1, _("Show Special Ascendants"));
    check_iretro = new wxCheckBox(this, -1, _("Show Retrogression (R)"));
    label_chartcenter = new wxStaticText(this, -1, _("Center of Chart"));
    const wxString choice_ichart_center_choices[] = {
        _("Nothing"),
        _("Varga Name"),
        _("Division D-N")
    };
    choice_ichart_center = new wxChoice(this, -1, wxDefaultPosition, wxDefaultSize, 3, choice_ichart_center_choices, 0);
    check_main_d9 = new wxCheckBox(this, -1, _("Navamsa D9"));
    check_main_d10 = new wxCheckBox(this, -1, _("Dasa Varga"));
    check_main_nak = new wxCheckBox(this, -1, _("Nakshatras"));
    check_main_bhava = new wxCheckBox(this, -1, _("Bhavas Positions"));
    check_main_pada = new wxCheckBox(this, -1, _("Nakshatra Padas"));
    check_main_ashtaka = new wxCheckBox(this, -1, _("Ashtakavarga Points"));
    check_main_kara = new wxCheckBox(this, -1, _("Jamini Karakas"));
    check_main_kp = new wxCheckBox(this, -1, _("Krishnamurti Lords"));
    check_main_d60 = new wxCheckBox(this, -1, _("Shastiamsa D60"));
    check_main_house = new wxCheckBox(this, -1, _("Houses"));
    check_main_lagna = new wxCheckBox(this, -1, _("Special Lagnas"));
    check_main_upa = new wxCheckBox(this, -1, _("Upagrahas/Kalavelas"));

    set_properties();
    do_layout();
    // end wxGlade
}


/*****************************************************
**
**   ConfVedicPanel   ---   set_properties 
**
******************************************************/
void ConfVedicPanel::set_properties()
{
    // begin wxGlade: ConfVedicPanel::set_properties
    label_title->SetFont(wxFont(12, wxDEFAULT, wxNORMAL, wxBOLD, 0, wxT("")));
    label_chartstyle->SetMinSize(wxSize(150, 16));
    choice_ichart->SetSelection(0);
    check_iraudhas->SetMinSize(wxSize(220, 24));
    check_iascendants->SetMinSize(wxSize(220, 24));
    check_iretro->SetMinSize(wxSize(220, 24));
    label_chartcenter->SetMinSize(wxSize(150, 17));
    choice_ichart_center->SetSelection(0);
    // end wxGlade
}


/*****************************************************
**
**   ConfVedicPanel   ---   do_layout 
**
******************************************************/
void ConfVedicPanel::do_layout()
{
    // begin wxGlade: ConfVedicPanel::do_layout
    wxBoxSizer* sizer_top = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* sizer_nb2 = new wxBoxSizer(wxHORIZONTAL);
    wxFlexGridSizer* sizer_nb2b = new wxFlexGridSizer(2, 1, 0, 0);
    wxFlexGridSizer* sizer_2 = new wxFlexGridSizer(2, 1, 0, 0);
    wxStaticBoxSizer* sizer_mainrows = new wxStaticBoxSizer(sizer_mainrows_staticbox, wxVERTICAL);
    wxGridSizer* grid_mainrows = new wxGridSizer(5, 2, 4, 0);
    wxStaticBoxSizer* sizer_maincols = new wxStaticBoxSizer(sizer_maincols_staticbox, wxVERTICAL);
    wxGridSizer* grid_maincols = new wxGridSizer(3, 2, 4, 0);
    wxFlexGridSizer* sizer_nb2a = new wxFlexGridSizer(2, 1, 0, 0);
    wxStaticBoxSizer* sizer_vcharts = new wxStaticBoxSizer(sizer_vcharts_staticbox, wxVERTICAL);
    wxBoxSizer* sizer_vcharts_center = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_vcharts_style = new wxBoxSizer(wxHORIZONTAL);
    sizer_top->Add(label_title, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxADJUST_MINSIZE, 3);
    sizer_top->Add(static_line_top, 0, wxALL|wxEXPAND, 3);
    sizer_vcharts_style->Add(label_chartstyle, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    sizer_vcharts_style->Add(choice_ichart, 0, wxALL|wxADJUST_MINSIZE, 3);
    sizer_vcharts->Add(sizer_vcharts_style, 1, wxEXPAND, 0);
    sizer_vcharts->Add(check_iraudhas, 0, wxADJUST_MINSIZE, 0);
    sizer_vcharts->Add(check_iascendants, 0, wxADJUST_MINSIZE, 0);
    sizer_vcharts->Add(check_iretro, 0, wxADJUST_MINSIZE, 0);
    wxStaticLine* static_line_2 = new wxStaticLine(this, -1);
    sizer_vcharts->Add(static_line_2, 0, wxALL|wxEXPAND, 3);
    sizer_vcharts_center->Add(label_chartcenter, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    sizer_vcharts_center->Add(choice_ichart_center, 0, wxALL|wxADJUST_MINSIZE, 3);
    sizer_vcharts->Add(sizer_vcharts_center, 1, wxEXPAND, 0);
    sizer_nb2a->Add(sizer_vcharts, 1, wxALL, 3);
    sizer_nb2a->AddGrowableCol(0);
    sizer_nb2->Add(sizer_nb2a, 1, wxALL|wxEXPAND, 3);
    grid_maincols->Add(check_main_d9, 0, wxTOP|wxBOTTOM, 1);
    grid_maincols->Add(check_main_d10, 0, wxTOP|wxBOTTOM, 1);
    grid_maincols->Add(check_main_nak, 0, wxTOP|wxBOTTOM, 1);
    grid_maincols->Add(check_main_bhava, 0, wxTOP|wxBOTTOM, 1);
    grid_maincols->Add(check_main_pada, 0, wxTOP|wxBOTTOM, 1);
    grid_maincols->Add(check_main_ashtaka, 0, wxTOP|wxBOTTOM, 1);
    grid_maincols->Add(check_main_kara, 0, wxTOP|wxBOTTOM, 1);
    grid_maincols->Add(check_main_kp, 0, wxTOP|wxBOTTOM, 1);
    grid_maincols->Add(check_main_d60, 0, wxTOP|wxBOTTOM, 1);
    grid_maincols->Add(120, 24, 0, wxTOP|wxBOTTOM, 1);
    sizer_maincols->Add(grid_maincols, 1, wxALL|wxEXPAND, 3);
    sizer_2->Add(sizer_maincols, 1, wxALL|wxEXPAND, 3);
    grid_mainrows->Add(check_main_house, 0, wxTOP|wxBOTTOM, 1);
    grid_mainrows->Add(check_main_lagna, 0, wxTOP|wxBOTTOM, 1);
    grid_mainrows->Add(check_main_upa, 0, wxTOP|wxBOTTOM, 1);
    grid_mainrows->Add(120, 24, 0, wxTOP|wxBOTTOM, 1);
    sizer_mainrows->Add(grid_mainrows, 1, wxALL, 3);
    sizer_2->Add(sizer_mainrows, 1, wxALL, 3);
    sizer_nb2b->Add(sizer_2, 1, 0, 0);
    sizer_nb2b->AddGrowableRow(0);
    sizer_nb2b->AddGrowableRow(1);
    sizer_nb2b->AddGrowableCol(0);
    sizer_nb2->Add(sizer_nb2b, 1, wxALL|wxEXPAND, 3);
    sizer_top->Add(sizer_nb2, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxADJUST_MINSIZE, 3);
    SetAutoLayout(true);
    SetSizer(sizer_top);
    sizer_top->Fit(this);
    sizer_top->SetSizeHints(this);
    // end wxGlade
}

/*****************************************************
**
**   ConfVedicPanel   ---   setData 
**
******************************************************/
void ConfVedicPanel::setData()
{
	if ( config->iGraphicStyle& IGRAPHIC_STYLE_SOUTH_INDIAN ) { choice_ichart->SetSelection( 0 ); }
  else if ( config->iGraphicStyle& IGRAPHIC_STYLE_NORTH_INDIAN ) { choice_ichart->SetSelection( 1 ); }
  else { choice_ichart->SetSelection( 2 ); }
  check_iraudhas->SetValue( config->iGraphicStyle& IGRAPHIC_STYLE_SHOW_ARUDHAS );
  check_iascendants->SetValue( config->iGraphicStyle & IGRAPHIC_STYLE_SHOW_SPECIAL_LAGNAS );
  check_iretro->SetValue( config->iGraphicStyle & IGRAPHIC_STYLE_SHOW_RETRO );
  choice_ichart_center->SetSelection( config->iChartCenter );
    
  check_main_d9->SetValue(    config->iMainChildStyle & IMAIN_CHILD_SHOW_NAVAMSA    );
  check_main_d10->SetValue(   config->iMainChildStyle & IMAIN_CHILD_SHOW_DASAVARGA  );
  check_main_nak->SetValue(   config->iMainChildStyle & IMAIN_CHILD_SHOW_NAKSHATRA  );
  check_main_kara->SetValue(  config->iMainChildStyle & IMAIN_CHILD_SHOW_KARAKA     );
  check_main_bhava->SetValue( config->iMainChildStyle & IMAIN_CHILD_SHOW_BHAVA      );
  check_main_d60->SetValue(   config->iMainChildStyle & IMAIN_CHILD_SHOW_SHASTIAMSA );
  check_main_kp->SetValue(    config->iMainChildStyle & IMAIN_CHILD_SHOW_KP         );
  check_main_lagna->SetValue( config->iMainChildStyle & IMAIN_CHILD_SHOW_LAGNAS     );
  check_main_upa->SetValue(   config->iMainChildStyle & IMAIN_CHILD_SHOW_UPA        );
  check_main_house->SetValue( config->iMainChildStyle & IMAIN_CHILD_SHOW_HOUSES     );
  check_main_pada->SetValue(    config->iMainChildStyle & IMAIN_CHILD_SHOW_PADA       );
  check_main_ashtaka->SetValue( config->iMainChildStyle & IMAIN_CHILD_SHOW_ASHTAKA    );
}

/*****************************************************
**
**   ConfVedicPanel   ---   saveData 
**
******************************************************/
bool ConfVedicPanel::saveData()
{
  wxColour color;
      
  // Vedic
  switch( choice_ichart->GetSelection() )
  {
    case 0:
      config->iGraphicStyle |= IGRAPHIC_STYLE_SOUTH_INDIAN;
      config->iGraphicStyle &= ~IGRAPHIC_STYLE_NORTH_INDIAN;
      config->iGraphicStyle &= ~IGRAPHIC_STYLE_EAST_INDIAN;
    break;
    case 1:
      config->iGraphicStyle &= ~IGRAPHIC_STYLE_SOUTH_INDIAN;
      config->iGraphicStyle |= IGRAPHIC_STYLE_NORTH_INDIAN;
      config->iGraphicStyle &= ~IGRAPHIC_STYLE_EAST_INDIAN;
    break;
    case 2:
      config->iGraphicStyle &= ~IGRAPHIC_STYLE_SOUTH_INDIAN;
      config->iGraphicStyle &= ~IGRAPHIC_STYLE_NORTH_INDIAN;
      config->iGraphicStyle |= IGRAPHIC_STYLE_EAST_INDIAN;
    break;
    default:
      assert( 0 );
    break;
  }
  check_iraudhas->GetValue() ? config->iGraphicStyle |= IGRAPHIC_STYLE_SHOW_ARUDHAS
		: config->iGraphicStyle &= ~IGRAPHIC_STYLE_SHOW_ARUDHAS;
  check_iascendants->GetValue() ? config->iGraphicStyle |= IGRAPHIC_STYLE_SHOW_SPECIAL_LAGNAS
    : config->iGraphicStyle &= ~IGRAPHIC_STYLE_SHOW_SPECIAL_LAGNAS;
  check_iretro->GetValue() ? config->iGraphicStyle |= IGRAPHIC_STYLE_SHOW_RETRO
		: config->iGraphicStyle &= ~IGRAPHIC_STYLE_SHOW_RETRO;
  config->iChartCenter = choice_ichart_center->GetSelection();
  
  config->iMainChildStyle = 0;
  if ( check_main_d9->GetValue()    ) config->iMainChildStyle |= IMAIN_CHILD_SHOW_NAVAMSA;
  if ( check_main_d10->GetValue()   ) config->iMainChildStyle |= IMAIN_CHILD_SHOW_DASAVARGA;
  if ( check_main_nak->GetValue()   ) config->iMainChildStyle |= IMAIN_CHILD_SHOW_NAKSHATRA;
  if ( check_main_kara->GetValue()  ) config->iMainChildStyle |= IMAIN_CHILD_SHOW_KARAKA;
  if ( check_main_bhava->GetValue() ) config->iMainChildStyle |= IMAIN_CHILD_SHOW_BHAVA;
  if ( check_main_d60->GetValue()   ) config->iMainChildStyle |= IMAIN_CHILD_SHOW_SHASTIAMSA;
  if ( check_main_kp->GetValue()    ) config->iMainChildStyle |= IMAIN_CHILD_SHOW_KP;
  if ( check_main_upa->GetValue()   ) config->iMainChildStyle |= IMAIN_CHILD_SHOW_UPA;
  if ( check_main_lagna->GetValue() ) config->iMainChildStyle |= IMAIN_CHILD_SHOW_LAGNAS;
  if ( check_main_house->GetValue() ) config->iMainChildStyle |= IMAIN_CHILD_SHOW_HOUSES;
  if ( check_main_pada->GetValue())    config->iMainChildStyle  |= IMAIN_CHILD_SHOW_PADA;
  if ( check_main_ashtaka->GetValue()) config->iMainChildStyle  |= IMAIN_CHILD_SHOW_ASHTAKA;
	return true;
}


