/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           ConfWesternPanel.cpp
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifdef __GNUG__
	#pragma implementation "ConfWesternPanel.h"
#endif

#include "ConfWesternPanel.h"
#include "DialogElements.h"

#include <wx/checkbox.h>
#include <wx/cmndata.h>
#include <wx/choice.h>
#include <wx/colour.h>
#include <wx/colordlg.h>
#include <wx/sizer.h>
#include <wx/spinctrl.h>
#include <wx/statbox.h>
#include <wx/statline.h>
#include <wx/stattext.h>

#include "Base.h"

#include "func.h"
#include "Conf.h"
#include "Lang.h"
#include "Session.h" 

extern Config *config;

IMPLEMENT_CLASS( ConfWesternPanel, wxPanel )

/*****************************************************
**
**   ConfWesternPanel   ---   Constructor 
**
******************************************************/
ConfWesternPanel::ConfWesternPanel(wxWindow* parent, int id, const wxPoint& pos, const wxSize& size, long style):
    wxPanel(parent, id, pos, size, wxTAB_TRAVERSAL)
{
    // begin wxGlade: ConfWesternPanel::ConfWesternPanel
    sizer_wmainwindow_staticbox = new wxStaticBox(this, -1, _("Show in Main Window"));
    sizer_wcalc_staticbox = new wxStaticBox(this, -1, _("Calculation Options"));
    sizer_wcharts_staticbox = new wxStaticBox(this, -1, _("Charts"));
    label_title = new wxStaticText(this, -1, _("Western Astrology"), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE);
    static_line_top = new wxStaticLine(this, -1);
    check_wgraphicshowaspects = new wxCheckBox(this, -1, _("Show Aspects"));
    check_wgraphicshowretro = new wxCheckBox(this, -1, _("Show Retrogression (R)"));
    check_wgraphicshowhouses = new wxCheckBox(this, -1, _("Show Houses"));
    check_wgraphicshowuranian = new wxCheckBox(this, -1, _("Show Uranian Planets"));
    label_wchart_orbis = new wxStaticText(this, -1, _("Orbis for Aspects"));
    spin_worbisaspects = new wxSpinCtrl(this, -1, wxT(""), wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 0, 20);
    label_wchart_orbis2 = new wxStaticText(this, -1, _("Deg"));
    check_wmainshowuranian = new wxCheckBox(this, -1, _("Uranian Planets"));
    check_wmainshowhouses = new wxCheckBox(this, -1, _("Houses"));
    check_wmainshowhousepos = new wxCheckBox(this, -1, _("House Positions of Planets"));
    label_wcalc_aya = new wxStaticText(this, -1, _("Ayanamsa"));
    choice_waya = new AyanamsaChoice(this, -1, config->wAyanamsa);
    label_wcalc_house = new wxStaticText(this, -1, _("House System"));
    const wxString choice_whouse_choices[] = {
        _("Placidus"),
        _("Koch"),
        _("Regiomontanus"),
        _("Campanus"),
        _("Porphyry"),
        _("Equal"),
        _("Vehlow Equal"),
        _("Axial Rotation"),
        _("Azimutal/Horizontal"),
        _("Polich/Page"),
        _("Alcabitus"),
        _("Morinus")
    };
    choice_whouse = new wxChoice(this, -1, wxDefaultPosition, wxDefaultSize, 12, choice_whouse_choices, 0);
    label_wcalc_node = new wxStaticText(this, -1, _("Lunar Node"));
    const wxString choice_wnode_choices[] = {
        _("True"),
        _("Mean")
    };
    choice_wnode = new wxChoice(this, -1, wxDefaultPosition, wxDefaultSize, 2, choice_wnode_choices, 0);

    set_properties();
    do_layout();
    // end wxGlade
}


/*****************************************************
**
**   ConfWesternPanel   ---   set_properties 
**
******************************************************/
void ConfWesternPanel::set_properties()
{
    // begin wxGlade: ConfWesternPanel::set_properties
    label_title->SetFont(wxFont(12, wxDEFAULT, wxNORMAL, wxBOLD, 0, wxT("")));
    check_wgraphicshowaspects->SetMinSize(wxSize(200, 24));
    check_wgraphicshowretro->SetMinSize(wxSize(200, 24));
    check_wgraphicshowhouses->SetMinSize(wxSize(200, 24));
    label_wchart_orbis->SetMinSize(wxSize(120, 17));
    spin_worbisaspects->SetMinSize(wxSize(60, 24));
    check_wmainshowuranian->SetMinSize(wxSize(200, 24));
    check_wmainshowhouses->SetMinSize(wxSize(200, 24));
    label_wcalc_aya->SetMinSize(wxSize(120, 16));
    label_wcalc_house->SetMinSize(wxSize(120, 16));
    choice_whouse->SetSelection(0);
    label_wcalc_node->SetMinSize(wxSize(120, 16));
    choice_wnode->SetToolTip(_("Western astrology most frequently uses True Node"));
    choice_wnode->SetSelection(0);
    // end wxGlade
}


/*****************************************************
**
**   ConfWesternPanel   ---   do_layout 
**
******************************************************/
void ConfWesternPanel::do_layout()
{
    // begin wxGlade: ConfWesternPanel::do_layout
    wxBoxSizer* sizer_top = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* sizer_nb3 = new wxBoxSizer(wxHORIZONTAL);
    wxFlexGridSizer* sizer_nb3b = new wxFlexGridSizer(2, 1, 0, 0);
    wxStaticBoxSizer* sizer_wcalc = new wxStaticBoxSizer(sizer_wcalc_staticbox, wxVERTICAL);
    wxGridSizer* grid_sizer_3 = new wxGridSizer(3, 2, 3, 3);
    wxFlexGridSizer* sizer_nb3a = new wxFlexGridSizer(2, 1, 0, 0);
    wxStaticBoxSizer* sizer_wmainwindow = new wxStaticBoxSizer(sizer_wmainwindow_staticbox, wxVERTICAL);
    wxStaticBoxSizer* sizer_wcharts = new wxStaticBoxSizer(sizer_wcharts_staticbox, wxVERTICAL);
    wxBoxSizer* sizer_wchart_orbis = new wxBoxSizer(wxHORIZONTAL);
    sizer_top->Add(label_title, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxADJUST_MINSIZE, 3);
    sizer_top->Add(static_line_top, 0, wxALL|wxEXPAND, 3);
    sizer_wcharts->Add(check_wgraphicshowaspects, 0, wxALL|wxALIGN_CENTER_VERTICAL, 1);
    sizer_wcharts->Add(check_wgraphicshowretro, 0, wxALL|wxALIGN_CENTER_VERTICAL, 1);
    sizer_wcharts->Add(check_wgraphicshowhouses, 0, wxALL|wxALIGN_CENTER_VERTICAL, 1);
    sizer_wcharts->Add(check_wgraphicshowuranian, 0, wxALL|wxALIGN_CENTER_VERTICAL, 1);
    sizer_wchart_orbis->Add(label_wchart_orbis, 0, wxALL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 5);
    sizer_wchart_orbis->Add(spin_worbisaspects, 0, 0, 0);
    sizer_wchart_orbis->Add(label_wchart_orbis2, 0, wxLEFT|wxALIGN_CENTER_VERTICAL, 5);
    sizer_wcharts->Add(sizer_wchart_orbis, 1, wxALL, 3);
    sizer_nb3a->Add(sizer_wcharts, 1, wxALL, 3);
    sizer_wmainwindow->Add(check_wmainshowuranian, 0, wxALL|wxALIGN_CENTER_VERTICAL, 1);
    sizer_wmainwindow->Add(check_wmainshowhouses, 0, wxALL|wxALIGN_CENTER_VERTICAL, 1);
    sizer_wmainwindow->Add(check_wmainshowhousepos, 0, wxALL|wxALIGN_CENTER_VERTICAL, 1);
    sizer_nb3a->Add(sizer_wmainwindow, 1, wxALL, 3);
    sizer_nb3a->AddGrowableRow(0);
    sizer_nb3a->AddGrowableRow(1);
    sizer_nb3a->AddGrowableCol(0);
    sizer_nb3->Add(sizer_nb3a, 1, wxALL, 3);
    grid_sizer_3->Add(label_wcalc_aya, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    grid_sizer_3->Add(choice_waya, 1, wxEXPAND, 0);
    grid_sizer_3->Add(label_wcalc_house, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    grid_sizer_3->Add(choice_whouse, 0, wxEXPAND, 0);
    grid_sizer_3->Add(label_wcalc_node, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    grid_sizer_3->Add(choice_wnode, 0, wxEXPAND, 0);
    sizer_wcalc->Add(grid_sizer_3, 1, wxALL|wxEXPAND, 3);
    sizer_nb3b->Add(sizer_wcalc, 1, wxALL, 3);
    sizer_nb3->Add(sizer_nb3b, 1, wxALL, 3);
    sizer_top->Add(sizer_nb3, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxADJUST_MINSIZE, 3);
    SetAutoLayout(true);
    SetSizer(sizer_top);
    sizer_top->Fit(this);
    sizer_top->SetSizeHints(this);
    // end wxGlade
}

/*****************************************************
**
**   ConfWesternPanel   ---   setData 
**
******************************************************/
void ConfWesternPanel::setData()
{
  check_wgraphicshowaspects->SetValue( config->wGraphicStyle& WGRAPHIC_STYLE_SHOW_ASPECTS );
  check_wgraphicshowretro->SetValue( config->wGraphicStyle& WGRAPHIC_STYLE_SHOW_RETRO );
  check_wgraphicshowhouses->SetValue( config->wGraphicStyle& WGRAPHIC_STYLE_SHOW_HOUSES );
  check_wgraphicshowuranian->SetValue( config->wGraphicStyle& WGRAPHIC_STYLE_SHOW_URANIAN );
  spin_worbisaspects->SetValue( config->wOrbisAspects );
    
  check_wmainshowuranian->SetValue( config->wMainChildStyle & WMAIN_CHILD_SHOW_URANIAN );
  check_wmainshowhouses->SetValue( config->wMainChildStyle & WMAIN_CHILD_SHOW_HOUSES );
  check_wmainshowhousepos->SetValue( config->wMainChildStyle & WMAIN_CHILD_SHOW_HOUSEPOS );
  
  choice_whouse->SetSelection( config->wHouseSystem ? config->wHouseSystem -1 : 0 );
  choice_wnode->SetSelection( config->wLunarNodeMode );
}

/*****************************************************
**
**   ConfWesternPanel   ---   saveData 
**
******************************************************/
bool ConfWesternPanel::saveData()
{
  wxColour color;
  
  // Western - Graphic Style
  config->wGraphicStyle = 0;
  if ( check_wgraphicshowaspects->GetValue() ) config->wGraphicStyle |= WGRAPHIC_STYLE_SHOW_ASPECTS;
  if ( check_wgraphicshowretro->GetValue() ) config->wGraphicStyle |= WGRAPHIC_STYLE_SHOW_RETRO;
  if ( check_wgraphicshowhouses->GetValue() ) config->wGraphicStyle |= WGRAPHIC_STYLE_SHOW_HOUSES;
  if ( check_wgraphicshowuranian->GetValue() ) config->wGraphicStyle |= WGRAPHIC_STYLE_SHOW_URANIAN;
  config->wOrbisAspects = spin_worbisaspects->GetValue();
  
  // Main Window Style
  config->wMainChildStyle = 0;
  if ( check_wmainshowuranian->GetValue() ) config->wMainChildStyle |= WMAIN_CHILD_SHOW_URANIAN;
  if ( check_wmainshowhouses->GetValue() ) config->wMainChildStyle |= WMAIN_CHILD_SHOW_HOUSES;
  if ( check_wmainshowhousepos->GetValue() ) config->wMainChildStyle |= WMAIN_CHILD_SHOW_HOUSEPOS;
  
  config->wHouseSystem = choice_whouse->GetSelection() + 1;
  config->wLunarNodeMode = choice_wnode->GetSelection();
	config->wAyanamsa = choice_waya->getConfigIndex();
	return true;
}



