/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           ConfWesternPanel.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/


#ifndef CONFWESTERNPANEL_H
#define CONFWESTERNPANEL_H

#ifdef __GNUG__
	#pragma interface "ConfWesternPanel.h"
#endif

#include <wx/panel.h>

// begin wxGlade: dependencies
// end wxGlade

class AyanamsaChoice;
class wxCheckBox;
class wxChoice;
class wxSpinCtrl;
class wxStaticBox;
class wxStaticLine;
class wxStaticText;

/*****************************************************
**
**   CLASS ConfWesternPanel  
**
******************************************************/
class ConfWesternPanel: public wxPanel
{
public:
    // begin wxGlade: ConfWesternPanel::ids
    // end wxGlade

	ConfWesternPanel(wxWindow* parent, int id, const wxPoint& pos=wxDefaultPosition,
		const wxSize& size=wxDefaultSize, long style=0);
	void setData();
	bool saveData();

private:
    // begin wxGlade: ConfWesternPanel::methods
    void set_properties();
    void do_layout();
    // end wxGlade
	DECLARE_CLASS( ConfWesternPanel )

protected:
    // begin wxGlade: ConfWesternPanel::attributes
    wxStaticBox* sizer_wcalc_staticbox;
    wxStaticBox* sizer_wmainwindow_staticbox;
    wxStaticBox* sizer_wcharts_staticbox;
    wxStaticText* label_title;
    wxStaticLine* static_line_top;
    wxCheckBox* check_wgraphicshowaspects;
    wxCheckBox* check_wgraphicshowretro;
    wxCheckBox* check_wgraphicshowhouses;
    wxCheckBox* check_wgraphicshowuranian;
    wxStaticText* label_wchart_orbis;
    wxSpinCtrl* spin_worbisaspects;
    wxStaticText* label_wchart_orbis2;
    wxCheckBox* check_wmainshowuranian;
    wxCheckBox* check_wmainshowhouses;
    wxCheckBox* check_wmainshowhousepos;
    wxStaticText* label_wcalc_aya;
    AyanamsaChoice* choice_waya;
    wxStaticText* label_wcalc_house;
    wxChoice* choice_whouse;
    wxStaticText* label_wcalc_node;
    wxChoice* choice_wnode;
    // end wxGlade
};


#endif // CONFWESTERNPANEL_H
