/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           ConfigDialog.cpp
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifdef __GNUG__
	#pragma implementation "ConfigDialog.h"
#endif

#include "ConfigDialog.h"

#include <wx/app.h>
#include <wx/button.h>
#include <wx/imaglist.h>
#include <wx/listbook.h>
#include <wx/notebook.h>
#include <wx/sizer.h>
#include <wx/statline.h>

#include "ConfAppearancePanel.h"
#include "ConfGeneralPanel.h"
#include "ConfVedicCalcPanel.h"
#include "ConfVedicPanel.h"
#include "ConfWesternPanel.h"
#include "ConfMidpointPanel.h"
#include "ConfExpertPanel.h"

#include "LocationDialog.h"
#include "Base.h"
#include "IconProvider.h"

#include "func.h"

IMPLEMENT_CLASS( ConfigDialog, wxDialog )
BEGIN_EVENT_TABLE( ConfigDialog, wxDialog )
  EVT_BUTTON( wxID_APPLY, ConfigDialog::OnApply )
  EVT_BUTTON( wxID_OK, ConfigDialog::OnOK )
  EVT_BUTTON( wxID_CANCEL, ConfigDialog::OnCancel )
END_EVENT_TABLE()

DEFINE_EVENT_TYPE( CONFIG_CHANGED )

int ConfigDialog::selected = 0;

/*****************************************************
**
**   ConfigDialog   ---   Constructor 
**
******************************************************/
ConfigDialog::ConfigDialog(wxWindow* parent )
  :  wxDialog(parent, CONFIG_DIALOG, wxT( "Configuration" ), wxDefaultPosition, wxDefaultSize, DEFAULT_DIALOG_STYLE )
{
    // begin wxGlade: ConfigDialog::ConfigDialog
    //notebook = new wxNotebook(this, -1, wxDefaultPosition, wxDefaultSize, 0);
    notebook = new wxListbook(this, -1, wxDefaultPosition, wxDefaultSize, wxLB_DEFAULT ); //wxLB_TOP );
    notebook_pane_7 = new wxPanel(notebook, -1);
    notebook_pane_6 = new wxPanel(notebook, -1);
    notebook_pane_5 = new wxPanel(notebook, -1);
    notebook_pane_4 = new wxPanel(notebook, -1);
    notebook_pane_3 = new wxPanel(notebook, -1);
    notebook_pane_2 = new wxPanel(notebook, -1);
    notebook_pane_1 = new wxPanel(notebook, -1);
    panel_general = new ConfGeneralPanel(notebook_pane_1, -1);
    panel_appearance = new ConfAppearancePanel(notebook_pane_2, -1);
    panel_vedic = new ConfVedicPanel(notebook_pane_3, -1);
    panel_vedic_calc = new ConfVedicCalcPanel(notebook_pane_4, -1);
    panel_western = new ConfWesternPanel(notebook_pane_5, -1);
    panel_midpoint = new ConfMidpointPanel(notebook_pane_6, -1);
    panel_expert = new ConfExpertPanel(notebook_pane_7, -1);
    static_line_bottom = new wxStaticLine(this, -1);
    okbutton = new wxButton(this, wxID_OK, _("OK"));
    applybutton = new wxButton(this, wxID_APPLY, _("Apply"));
    cancelbutton = new wxButton(this, wxID_CANCEL, _("Cancel"));

    set_properties();
    do_layout();
    // end wxGlade
		SetIcon( IconProvider::getIcon( BITMAP_CONFIG ));
		moveWindow2Center( this );
		setData();
		notebook->SetSelection( selected );
}

/*****************************************************
**
**   ConfigDialog   ---   setData 
**
******************************************************/
void ConfigDialog::setData()
{
	panel_general->setData();
	panel_appearance->setData();
	panel_vedic->setData();
	panel_vedic_calc->setData();
	panel_western->setData();
	panel_midpoint->setData();
	panel_expert->setData();
}

/*****************************************************
**
**   ConfigDialog   ---   saveData 
**
******************************************************/
bool ConfigDialog::saveData()
{
	selected = notebook->GetSelection();
	if ( ! panel_general->saveData()) return false;
	if ( ! panel_appearance->saveData()) return false;
	if ( ! panel_vedic->saveData()) return false;
	if ( ! panel_vedic_calc->saveData()) return false;
	if ( ! panel_western->saveData()) return false;
	if ( ! panel_midpoint->saveData()) return false;
	return panel_expert->saveData();
}

/*****************************************************
**
**   ConfigDialog   ---   OnApply 
**
******************************************************/
void ConfigDialog::OnApply( wxCommandEvent &event )
{
	saveData();
	wxCommandEvent e( CONFIG_CHANGED, GetId() );
	wxPostEvent( GetParent(), e );
	//GetParent()->ProcessEvent( e );
}

/*****************************************************
**
**   ConfigDialog   ---   OnOK 
**
******************************************************/
void ConfigDialog::OnOK( wxCommandEvent &event )
{
	if ( ! saveData() ) return;
	wxCommandEvent e( CONFIG_CHANGED, GetId() );
	wxPostEvent( GetParent(), e );
	//GetParent()->ProcessEvent( e );
	wxDialog::OnOK( event );
}

/*****************************************************
**
**   ConfigDialog   ---   OnCancel 
**
******************************************************/
void ConfigDialog::OnCancel( wxCommandEvent &event )
{
	wxDialog::OnCancel( event );
}

/*****************************************************
**
**   ConfigDialog   ---   set_properties 
**
******************************************************/
void ConfigDialog::set_properties()
{
    // begin wxGlade: ConfigDialog::set_properties
    SetTitle(_("Configuration"));
    // end wxGlade
}


/*****************************************************
**
**   ConfigDialog   ---   do_layout 
**
******************************************************/
void ConfigDialog::do_layout()
{
	wxImageList *imagelist = new wxImageList( 24, 24, true );
	imagelist->Add( IconProvider::getBitmap( BITMAP_CONFIG ));
	imagelist->Add( IconProvider::getBitmap( BITMAP_APPEARANCE ));
	imagelist->Add( IconProvider::getBitmap( BITMAP_EAST_SEL ));
	imagelist->Add( IconProvider::getBitmap( BITMAP_CALCULATION ));
	imagelist->Add( IconProvider::getBitmap( BITMAP_WEST_SEL ));
	imagelist->Add( IconProvider::getBitmap( BITMAP_MIDPOINT ));
	imagelist->Add( IconProvider::getBitmap( BITMAP_EXPERT ));
	notebook->AssignImageList( imagelist );

    // begin wxGlade: ConfigDialog::do_layout
    wxFlexGridSizer* sizer_main = new wxFlexGridSizer(3, 1, 3, 3);
    wxFlexGridSizer* buttonsizer = new wxFlexGridSizer(1, 5, 0, 0);
    wxBoxSizer* sizer_expert = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_midpoint = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_western = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_vedic_calc = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_vedic = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_appearance = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_general = new wxBoxSizer(wxHORIZONTAL);
    sizer_general->Add(panel_general, 1, wxALL|wxEXPAND, 3);
    notebook_pane_1->SetAutoLayout(true);
    notebook_pane_1->SetSizer(sizer_general);
    sizer_general->Fit(notebook_pane_1);
    sizer_general->SetSizeHints(notebook_pane_1);
    sizer_appearance->Add(panel_appearance, 1, wxALL|wxEXPAND, 3);
    notebook_pane_2->SetAutoLayout(true);
    notebook_pane_2->SetSizer(sizer_appearance);
    sizer_appearance->Fit(notebook_pane_2);
    sizer_appearance->SetSizeHints(notebook_pane_2);
    sizer_vedic->Add(panel_vedic, 1, wxALL|wxEXPAND, 3);
    notebook_pane_3->SetAutoLayout(true);
    notebook_pane_3->SetSizer(sizer_vedic);
    sizer_vedic->Fit(notebook_pane_3);
    sizer_vedic->SetSizeHints(notebook_pane_3);
    sizer_vedic_calc->Add(panel_vedic_calc, 1, wxALL|wxEXPAND, 3);
    notebook_pane_4->SetAutoLayout(true);
    notebook_pane_4->SetSizer(sizer_vedic_calc);
    sizer_vedic_calc->Fit(notebook_pane_4);
    sizer_vedic_calc->SetSizeHints(notebook_pane_4);
    sizer_western->Add(panel_western, 1, wxALL|wxEXPAND, 3);
    notebook_pane_5->SetAutoLayout(true);
    notebook_pane_5->SetSizer(sizer_western);
    sizer_western->Fit(notebook_pane_5);
    sizer_western->SetSizeHints(notebook_pane_5);
    sizer_midpoint->Add(panel_midpoint, 1, wxALL|wxEXPAND, 3);
    notebook_pane_6->SetAutoLayout(true);
    notebook_pane_6->SetSizer(sizer_midpoint);
    sizer_midpoint->Fit(notebook_pane_6);
    sizer_midpoint->SetSizeHints(notebook_pane_6);
    sizer_expert->Add(panel_expert, 1, wxALL|wxEXPAND, 3);
    notebook_pane_7->SetAutoLayout(true);
    notebook_pane_7->SetSizer(sizer_expert);
    sizer_expert->Fit(notebook_pane_7);
    sizer_expert->SetSizeHints(notebook_pane_7);
    notebook->AddPage(notebook_pane_1, _("General"),false, 0);
    notebook->AddPage(notebook_pane_2, _("Appearance"), false, 1);
    notebook->AddPage(notebook_pane_3, _("Vedic"), false, 2);
    notebook->AddPage(notebook_pane_4, _("Vedic Calculation"), false,3);
    notebook->AddPage(notebook_pane_5, _("Western"), false, 4);
    notebook->AddPage(notebook_pane_6, _("Midpoint"), false, 5);
    notebook->AddPage(notebook_pane_7, _("Advanced"), false, 6);
    sizer_main->Add(notebook, 2, wxALL|wxEXPAND, 3);
    sizer_main->Add(static_line_bottom, 0, wxEXPAND, 0);
    buttonsizer->Add(okbutton, 0, wxALL, 3);
    buttonsizer->Add(applybutton, 0, wxALL, 3);
    buttonsizer->Add(cancelbutton, 0, wxALL, 3);
    sizer_main->Add(buttonsizer, 1, wxALL|wxALIGN_CENTER_HORIZONTAL, 3);
    SetAutoLayout(true);
    SetSizer(sizer_main);
    sizer_main->Fit(this);
    sizer_main->SetSizeHints(this);
    sizer_main->AddGrowableRow(0);
    sizer_main->AddGrowableCol(0);
    Layout();
    // end wxGlade
}

