/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           ConfigDialog.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/


#ifndef CONFIGDIALOG_H
#define CONFIGDIALOG_H

#ifdef __GNUG__
	#pragma interface "ConfigDialog.h"
#endif

// begin wxGlade: dependencies
// end wxGlade

#include <wx/dialog.h>

class wxButton;
class wxListbook;
class wxNotebook;
class wxPanel;
class wxStaticLine;
class ConfAppearancePanel;
class ConfGeneralPanel;
class ConfVedicPanel;
class ConfVedicCalcPanel;
class ConfWesternPanel;
class ConfMidpointPanel;
class ConfExpertPanel;

BEGIN_DECLARE_EVENT_TYPES()
	DECLARE_EVENT_TYPE( CONFIG_CHANGED, 9500 )
END_DECLARE_EVENT_TYPES()

/*****************************************************
**
**   CLASS ConfigDialog  
**
******************************************************/
class ConfigDialog: public wxDialog
{
	DECLARE_CLASS( ConfigDialog )
public:
    // begin wxGlade: ConfigDialog::ids
    // end wxGlade

    ConfigDialog(wxWindow* parent );

	DECLARE_EVENT_TABLE()

private:
    // begin wxGlade: ConfigDialog::methods
    void set_properties();
    void do_layout();
    // end wxGlade
	void OnApply( wxCommandEvent& );
	void OnOK( wxCommandEvent& );
	void OnCancel( wxCommandEvent& );
	void setData();
	bool saveData();
	static int selected;

protected:
    // begin wxGlade: ConfigDialog::attributes
    ConfGeneralPanel* panel_general;
    wxPanel* notebook_pane_1;
    ConfAppearancePanel* panel_appearance;
    wxPanel* notebook_pane_2;
    ConfVedicPanel* panel_vedic;
    wxPanel* notebook_pane_3;
    ConfVedicCalcPanel* panel_vedic_calc;
    wxPanel* notebook_pane_4;
    ConfWesternPanel* panel_western;
    wxPanel* notebook_pane_5;
    ConfMidpointPanel* panel_midpoint;
    wxPanel* notebook_pane_6;
    ConfExpertPanel* panel_expert;
    wxPanel* notebook_pane_7;
    //wxNotebook* notebook;
    wxListbook* notebook;
    wxStaticLine* static_line_bottom;
    wxButton* okbutton;
    wxButton* applybutton;
    wxButton* cancelbutton;
    // end wxGlade
};


#endif // CONFIGDIALOG_H
