/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           DialogElements.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/


#ifndef _DIALOGELEMENTS_H_
#define _DIALOGELEMENTS_H_

#ifdef __GNUG__
	#pragma interface "DialogElements.h"
#endif

#include <wx/app.h>
#include <wx/choice.h>
#include <wx/event.h>
#include <wx/grid.h>
#include <wx/dialog.h>
#include <wx/minifram.h>
#include <wx/panel.h>
#include <wx/valtext.h>

class wxCalendarCtrl;
class wxSpinButton;
class wxSpinEvent;
class wxStaticText;
class wxTextCtrl;

BEGIN_DECLARE_EVENT_TYPES()
	DECLARE_EVENT_TYPE(COMMAND_DATE_SPIN_CHANGED, 7777)
	DECLARE_EVENT_TYPE(COMMAND_TIME_SPIN_CHANGED, 7778)
END_DECLARE_EVENT_TYPES()

/*****************************************************
**
**   CLASS MyGrid
**
******************************************************/
class MyGrid : public wxGrid
{
public:
	MyGrid( wxWindow* parent, wxWindowID id, const wxPoint& pos = wxDefaultPosition,
		const wxSize& size = wxDefaultSize, long style = wxWANTS_CHARS, const wxString& name = wxPanelNameStr);
protected:
	void OnMouseEvent( wxMouseEvent& );
	void OnKeyDown( wxKeyEvent& );

private:
	DECLARE_CLASS( ChildWindow )
	DECLARE_EVENT_TABLE()
};

/*****************************************************
**
**   CLASS FilterChoice  
**
******************************************************/
class FilterChoice : public wxChoice
{
public:
	FilterChoice( wxWindow *parent, int id, int hsSystem, int selected = 0 );
	void recreate( int hsSystem );
	int getFilter();
};

/*****************************************************
**
**   CLASS CircleDegreeChoice  
**
******************************************************/
class CircleDegreeChoice : public wxChoice
{
public:
	CircleDegreeChoice( wxWindow *parent, int id, int selected = 0 );
};

/*****************************************************
**
**   CLASS YearLengthChoice  
**
******************************************************/
class YearLengthChoice : public wxChoice
{
public:
	YearLengthChoice( wxWindow *parent, int id, const bool vedic, int selected = 0 );
	double getYearLength();

private:
	bool vedic;
};

/*****************************************************
**
**   CLASS SortChoice  
**
******************************************************/
class SortChoice : public wxChoice
{
public:
	SortChoice( wxWindow *parent, int id, int selected = 0 );
};

/*****************************************************
**
**   CLASS TransitModeChoice  
**
******************************************************/
class TransitModeChoice : public wxChoice
{
public:
	TransitModeChoice( wxWindow *parent, int id, int selected = 0 );
};

/*****************************************************
**
**   CLASS TimeSpin  
**
******************************************************/
class TimeSpin : public wxControl
{
public:
	TimeSpin( wxWindow *parent, int id = -1, double startjd = 0, const wxPoint& pos = wxDefaultPosition,
		const wxSize& size = wxDefaultSize );
	double getTime() { return time; }
	void setActual();
	virtual wxSize DoGetBestSize() const;

protected:
	double time;
	wxTextCtrl *theText;
	wxSpinButton *spin;
	void writeContents();
	void OnUp( wxSpinEvent &event );
	void OnDown( wxSpinEvent &event );
	void OnTextChanged( wxCommandEvent &event );

private:
	DECLARE_CLASS( TimeSpin )
	DECLARE_EVENT_TABLE()

};

/*****************************************************
**
**   CLASS DateInputField  
**
******************************************************/
class DateInputField : public wxTextCtrl
{
	DECLARE_CLASS( DateInputField )
public:
	DateInputField( wxWindow *parent, int id, wxString*, const wxPoint& pos = wxDefaultPosition,
	    const wxSize& size = wxDefaultSize );
	DECLARE_EVENT_TABLE()
protected:
	void OnKillFocus( wxFocusEvent& );
};

/*****************************************************
**
**   CLASS DateValidator  
**
******************************************************/
class DateValidator : public wxTextValidator
{
	DECLARE_CLASS( DateValidator )
public:
	DateValidator( wxString* );

protected:

	virtual bool Validate( wxWindow* parent );
	virtual wxObject *Clone() const { return new DateValidator(*this); }
};

/*****************************************************
**
**   CLASS DateSpin  
**
******************************************************/
class DateSpin : public wxControl
{
public:
	DateSpin( wxWindow *parent, int id = -1, double startjd = 0, const wxPoint& pos = wxDefaultPosition,
		const wxSize& size = wxDefaultSize );
	double getJD() { return jd; }
	void setActual();

protected:
	double jd;
	wxString date_value, time_value;
	DateInputField *theText;
	wxStaticText *theLabel;
	wxSpinButton *spin;
	void writeContents();
	void OnUp( wxSpinEvent& );
	void OnDown( wxSpinEvent& );
	void OnTextChanged( wxCommandEvent& );
	void OnKillFocus( wxFocusEvent& );
	virtual void OnSetFocus( wxFocusEvent& );

private:
	DECLARE_EVENT_TABLE()
	DECLARE_CLASS( DateSpin )
};

/*****************************************************
**
**   CLASS AyanamsaChoice  
**
******************************************************/
class AyanamsaChoice : public wxChoice
{
public:
	AyanamsaChoice( wxWindow *parent, int id, int ayatype );
	int getConfigIndex();
};

/*****************************************************
**
**   CLASS ToolbarLabel
**
******************************************************/
class ToolbarLabel : public wxControl
{
public:
	ToolbarLabel( wxWindow *parent, wxWindowID id, wxPoint pos, wxSize size, wxString tooltip );
	void SetLabel( wxString );
	virtual wxSize DoGetBestSize() const;

private:
	wxStaticText *theText;
	DECLARE_EVENT_TABLE()
	DECLARE_CLASS( ToolbarLabel )
};

/*****************************************************
**
**   CLASS DegreeValidator  
**
******************************************************/
class DegreeValidator : public wxTextValidator
{
public:
	DegreeValidator( wxString* );

protected:

	virtual bool Validate( wxWindow* parent );
	virtual wxObject *Clone() const { return new DegreeValidator(*this); }
};

/*****************************************************
**
**   CLASS DoubleValidator  
**
******************************************************/
class DoubleValidator : public wxTextValidator
{
public:
	DoubleValidator( wxString* );

protected:

	virtual wxObject *Clone() const { return new DoubleValidator(*this); }
};

#endif


