/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           ExportDialog.cpp
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifdef __GNUG__
	#pragma implementation "ExportDialog.h"
#endif

#include "ExportDialog.h"
#include "Base.h"

#include <wx/button.h>
#include <wx/statbox.h>
#include <wx/sizer.h>
#include <wx/spinctrl.h>
#include <wx/statline.h>
#include <wx/stattext.h>

IMPLEMENT_CLASS( ExportDialog, wxDialog )
BEGIN_EVENT_TABLE( ExportDialog, wxDialog )
	//EVT_BUTTON( wxID_OK, wxDialog::OnOK )
END_EVENT_TABLE()


/*****************************************************
**
**   ExportDialog   ---   Constructor
**
******************************************************/
ExportDialog::ExportDialog(wxWindow* parent, const int &x, const int &y )
 :  wxDialog(parent, -1, wxT( "--"  ), wxDefaultPosition, wxDefaultSize, DEFAULT_DIALOG_STYLE)
{
		sizex = x;
		sizey = y;
    // begin wxGlade: ExportDialog::ExportDialog
    sizer_size_staticbox = new wxStaticBox(this, -1, _("Size"));
    label_x = new wxStaticText(this, -1, _("Horizontal Size"));
    spin_x = new wxSpinCtrl(this, -1, wxT(""), wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 1, 100000);
    label_y = new wxStaticText(this, -1, _("Vertical Size"));
    spin_y = new wxSpinCtrl(this, -1, wxT(""), wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 1, 100000);
    static_line_1 = new wxStaticLine(this, -1);
    button_ok = new wxButton(this, wxID_OK, _("OK"));
    button_cancel = new wxButton(this, wxID_CANCEL, _("Cancel"));

    set_properties();
    do_layout();
    // end wxGlade
}

/*****************************************************
**
**   ExportDialog   ---   getSizes
**
******************************************************/
void ExportDialog::getSizes( int &x, int &y )
{
	x = spin_x->GetValue();
	y = spin_y->GetValue();
}

/*****************************************************
**
**   ExportDialog   ---   set_properties
**
******************************************************/
void ExportDialog::set_properties()
{
    // begin wxGlade: ExportDialog::set_properties
    SetTitle(_("Export Graphic"));
    label_x->SetMinSize(wxSize(120, 25));
    spin_x->SetMinSize(wxSize(80, 25));
    label_y->SetMinSize(wxSize(120, 25));
    spin_y->SetMinSize(wxSize(80, 25));
    // end wxGlade
		spin_x->SetValue( sizex );
		spin_y->SetValue( sizey );
}

/*****************************************************
**
**   ExportDialog   ---   do_layout(
**
******************************************************/
void ExportDialog::do_layout()
{
    // begin wxGlade: ExportDialog::do_layout
    wxFlexGridSizer* sizer_main = new wxFlexGridSizer(3, 1, 0, 0);
    wxBoxSizer* sizer_buttons = new wxBoxSizer(wxHORIZONTAL);
    wxStaticBoxSizer* sizer_size = new wxStaticBoxSizer(sizer_size_staticbox, wxVERTICAL);
    wxGridSizer* sizer_size_grid = new wxGridSizer(2, 2, 3, 3);
    sizer_size_grid->Add(label_x, 0, wxALL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    sizer_size_grid->Add(spin_x, 0, wxALL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    sizer_size_grid->Add(label_y, 0, wxALL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    sizer_size_grid->Add(spin_y, 0, wxALL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    sizer_size->Add(sizer_size_grid, 1, wxEXPAND, 0);
    sizer_main->Add(sizer_size, 1, wxALIGN_CENTER_HORIZONTAL, 0);
    sizer_main->Add(static_line_1, 0, wxALL|wxEXPAND, 3);
    sizer_buttons->Add(button_ok, 0, wxALL, 3);
    sizer_buttons->Add(button_cancel, 0, wxALL, 3);
    sizer_main->Add(sizer_buttons, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 3);
    SetAutoLayout(true);
    SetSizer(sizer_main);
    sizer_main->Fit(this);
    sizer_main->SetSizeHints(this);
    sizer_main->AddGrowableCol(0);
    Layout();
    // end wxGlade
}

