/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           LocationDialog.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifndef LOCATIONDIALOG_H
#define LOCATIONDIALOG_H

#ifdef __GNUG__
	#pragma interface "LocationDialog.h"
#endif

#include "Base.h"
#include "DataSet.h"

#include <wx/dialog.h>
#include <wx/statline.h>
#include <list>

// begin wxGlade: dependencies
// end wxGlade

class MyGrid;
class wxButton;
class wxChoice;
class wxGridEvent;
class wxProgressDialog;
class wxStaticBox;
class wxStaticText;

using namespace std;

/*****************************************************
**
**   CLASS LocationDialog  
**
******************************************************/
class LocationDialog: public wxDialog
{
public:
    // begin wxGlade: LocationDialog::ids
    // end wxGlade

	LocationDialog(wxWindow* parent );
	Location* getSelectedLocation();

private:
    // begin wxGlade: LocationDialog::methods
    void set_properties();
    void do_layout();
    // end wxGlade

	wxProgressDialog *progressdialog;
	list<wxString> countries;
	list<wxString> fav_countries;
	list<LocationEntry> entries;
	bool doSetup();
	void updateGrid();
	void OnSelectCell( wxGridEvent& );
	void OnSelectLabel( wxGridEvent& );
	void OnCellChange( wxGridEvent& );
	void OnCellDClick( wxGridEvent& );
	void OnApplyFilter( wxCommandEvent& );
	void OnResetFilter( wxCommandEvent& );
	void OnAddEntry( wxCommandEvent& );
	void OnDeleteEntry( wxCommandEvent& );
	void OnEditEntry( wxCommandEvent& );
	void OnFilterChanged( wxCommandEvent& );
	void OnCountryChoice( wxCommandEvent& );
	void OnAddCountry( wxCommandEvent& );
	void OnDelCountry( wxCommandEvent& );
	void updateLocationData();
	wxString filename;
	LocationEntry *selectedEntry;
	Location selectedLocation;
	bool dirty;
	bool saveDB();
	void OnOK( wxCommandEvent &event );
	void OnCancel( wxCommandEvent &event );
	void OnSaveDB( wxCommandEvent &event );
	void setDirty( const bool& );
	void updateCountryChoice();
	void saveFavouriteContries();
	DECLARE_EVENT_TABLE()

protected:
    // begin wxGlade: LocationDialog::attributes
    wxStaticBox* sizer_entry_staticbox;
    wxStaticBox* sizer_datadetails_staticbox;
    wxStaticBox* sizer_country_edit_staticbox;
    wxStaticBox* sizer_actions_staticbox;
    wxStaticBox* sizer_filter_staticbox;
    wxStaticText* label_filtermatch;
    wxTextCtrl* filter_edit;
    wxStaticText* label_filtercountry;
    wxChoice* country_choice;
    wxButton* applyfilterbutton;
    wxButton* resetbutton;
    wxButton* button_addcountry;
    wxButton* button_delcountry;
    MyGrid* locgrid;
    wxStaticText* match_label;
    wxStaticLine* static_line_match;
    wxStaticText* label_showname;
    wxStaticText* label_name;
    wxStaticText* label_showcountry;
    wxStaticText* label_country;
    wxStaticText* label_showstate;
    wxStaticText* label_state;
    wxStaticText* label_showlong;
    wxStaticText* label_lon;
    wxStaticText* label_showlat;
    wxStaticText* label_lat;
    wxButton* addbutton;
    wxButton* button_mod;
    wxButton* delbutton;
    wxStaticLine* static_line_button;
    wxButton* okbutton;
    wxButton* cacelbutton;
    wxButton* button_save;
    // end wxGlade
};


#endif // LOCATIONDIALOG_H
