/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           LocationEditDialog.cpp
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifdef __GNUG__
	#pragma implementation "LocationEditDialog.h"
#endif

#include "LocationEditDialog.h"

#include <math.h>

#include <wx/button.h>  
#include <wx/choice.h>
#include <wx/event.h>
#include <wx/sizer.h>
#include <wx/sizer.h>
#include <wx/statbox.h>
#include <wx/statline.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>

#include "Base.h"
#include "IconProvider.h"

#include "Conf.h"
#include "constants.h"
#include "func.h"
#include "Lang.h"

IMPLEMENT_CLASS( LocationEditDialog, wxDialog )
BEGIN_EVENT_TABLE( LocationEditDialog, wxDialog )
	EVT_BUTTON( wxID_OK, LocationEditDialog::OnOK )
END_EVENT_TABLE()

extern Config *config;

/*****************************************************
**
**   LocationEditDialog   ---   Constructor 
**
******************************************************/
LocationEditDialog::LocationEditDialog(wxWindow* parent, const wxString& title, LocationEntry *e )
{
	LocationEditDialog( parent, -1, title, wxDefaultPosition, wxDefaultSize, DEFAULT_DIALOG_STYLE );
	setEntry( e );
}

/*****************************************************
**
**   LocationEditDialog   ---   Constructor 
**
******************************************************/
LocationEditDialog::LocationEditDialog(wxWindow* parent, int id, const wxString& title, const wxPoint& pos,
	const wxSize& size, long style):
    wxDialog(parent, id, title, pos, size, DEFAULT_DIALOG_STYLE )
{
    // begin wxGlade: LocationEditDialog::LocationEditDialog
    sizer_data_staticbox = new wxStaticBox(this, -1, _("Data"));
    label_name = new wxStaticText(this, -1, _("Name"));
    name_edit = new wxTextCtrl(this, -1, wxT(""));
    label_country = new wxStaticText(this, -1, _("Country"));
    country_edit = new wxTextCtrl(this, -1, wxT(""));
    label_state = new wxStaticText(this, -1, _("State"));
    state_edit = new wxTextCtrl(this, -1, wxT(""));
    label_long = new wxStaticText(this, -1, _("Longitude"));
    long_edit = new wxTextCtrl(this, -1, wxT(""));
    const wxString choice_ew_choices[] = {
        _("East"),
        _("West")
    };
    choice_ew = new wxChoice(this, -1, wxDefaultPosition, wxDefaultSize, 2, choice_ew_choices, 0);
    label_lat = new wxStaticText(this, -1, _("Latitude"));
    lat_edit = new wxTextCtrl(this, -1, wxT(""));
    const wxString choice_ns_choices[] = {
        _("North"),
        _("South")
    };
    choice_ns = new wxChoice(this, -1, wxDefaultPosition, wxDefaultSize, 2, choice_ns_choices, 0);
    label_tz = new wxStaticText(this, -1, _("Time Zone"));
    text_tz = new wxTextCtrl(this, -1, wxT(""));
    const wxString choice_tzew_choices[] = {
        _("East"),
        _("West")
    };
    choice_tzew = new wxChoice(this, -1, wxDefaultPosition, wxDefaultSize, 2, choice_tzew_choices, 0);
    button_ok = new wxButton(this, wxID_OK, _("OK"));
    button_cancel = new wxButton(this, wxID_CANCEL, _("Cancel"));

    set_properties();
    do_layout();
    // end wxGlade
		moveWindow2Center( this );
		SetIcon( IconProvider::getIcon( BITMAP_WORLD ));
}

/*****************************************************
**
**   LocationEditDialog   ---   setEntry 
**
******************************************************/
void LocationEditDialog::setEntry( LocationEntry *e )
{
	wxString s;
  Formatter *formatter = Formatter::get();

	if ( e )
	{
		entry = *e;
		name_edit->SetValue( entry.name.c_str() );
		country_edit->SetValue( entry.country.c_str() );
		state_edit->SetValue( entry.state.c_str() );

		long_edit->SetValue( formatter->getDegreesFormated( fabs( entry.longitude ) ) );
		choice_ew->SetSelection( ( entry.longitude > 0 ? 0 : 1 ));

		lat_edit->SetValue( formatter->getDegreesFormated( fabs( entry.latitude ) ) );
		choice_ns->SetSelection( ( entry.latitude > 0 ? 0 : 1 ));

		s.Printf( wxT( "%2.1f" ),  ::fabs( entry.timeZone ));
		text_tz->SetValue( s );
		choice_tzew->SetSelection( entry.timeZone < 0 );
	}
	else
	{
		name_edit->SetValue( config->defaultLocation.getLocName() );
		country_edit->SetValue( wxT( "" ));
		state_edit->SetValue( wxT( "" ));

		long_edit->SetValue( formatter->getDegreesFormated( fabs( config->defaultLocation.getLongitude() )));
		choice_ew->SetSelection( config->defaultLocation.getLongitude() > 0 ? 0 : 1 );

		lat_edit->SetValue( formatter->getDegreesFormated( fabs( config->defaultLocation.getLatitude() )));
		choice_ns->SetSelection( config->defaultLocation.getLatitude() > 0 ? 0 : 1 );

		text_tz->SetValue( printfDouble( ::fabs( config->defaultLocation.getTimeZone() )) );
		choice_tzew->SetSelection( config->defaultLocation.getTimeZone() < 0 );
	}
}

/*****************************************************
**
**   LocationEditDialog   ---   OnOK 
**
******************************************************/
void LocationEditDialog::OnOK( wxCommandEvent &event )
{
	Formatter *formatter = Formatter::get();
	int ldeg, lmin, lsec, bdeg, bmin, bsec;

	entry.name = name_edit->GetValue();
	entry.country = country_edit->GetValue();
	entry.state = state_edit->GetValue();

	if ( ! formatter->getDegreeIntsFromString( (const wxChar*)long_edit->GetValue(), ldeg, lmin, lsec ))
	{
		doMessageBox( this, _("Longitude field invalid"), wxOK | wxICON_ERROR | wxCENTRE );
		return;
	}

	if ( ! formatter->getDegreeIntsFromString( (const wxChar*)lat_edit->GetValue(), bdeg, bmin, bsec ))
	{
		doMessageBox( this, _("Latitude field invalid"), wxOK | wxICON_ERROR | wxCENTRE );
		return;
	}

  entry.longitude = 3600 * ldeg + 60 * lmin + lsec;
	entry.longitude /= 3600;
	if ( choice_ew->GetSelection() ) entry.longitude *= -1;

  entry.latitude = 3600 * bdeg + 60 * bmin + bsec;
	entry.latitude /= 3600;
	if ( choice_ns->GetSelection() ) entry.latitude *= -1;

	entry.timeZone = myatof( text_tz->GetValue() );
	if ( choice_tzew->GetSelection() ) entry.timeZone *= -1;

	wxDialog::OnOK( event );
}

/*****************************************************
**
**   LocationEditDialog   ---   set_properties 
**
******************************************************/
void LocationEditDialog::set_properties()
{
    // begin wxGlade: LocationEditDialog::set_properties
    SetTitle(_("Edit Location"));
    label_name->SetMinSize(wxSize(80, 16));
    name_edit->SetMinSize(wxSize(200, 22));
    label_country->SetMinSize(wxSize(80, 16));
    country_edit->SetMinSize(wxSize(200, 22));
    label_state->SetMinSize(wxSize(80, 16));
    state_edit->SetMinSize(wxSize(200, 22));
    label_long->SetMinSize(wxSize(80, 16));
    long_edit->SetMinSize(wxSize(105, 22));
    choice_ew->SetSelection(0);
    label_lat->SetMinSize(wxSize(80, 16));
    lat_edit->SetMinSize(wxSize(105, 22));
    choice_ns->SetSelection(0);
    label_tz->SetMinSize(wxSize(80, 16));
    text_tz->SetMinSize(wxSize(105, 22));
    choice_tzew->SetSelection(0);
    // end wxGlade
}


/*****************************************************
**
**   LocationEditDialog   ---   do_layout 
**
******************************************************/
void LocationEditDialog::do_layout()
{
    // begin wxGlade: LocationEditDialog::do_layout
    wxFlexGridSizer* sizer_main = new wxFlexGridSizer(1, 3, 0, 0);
    wxBoxSizer* sizer_button = new wxBoxSizer(wxVERTICAL);
    wxStaticBoxSizer* sizer_data = new wxStaticBoxSizer(sizer_data_staticbox, wxVERTICAL);
    wxFlexGridSizer* sizer_tz = new wxFlexGridSizer(1, 3, 0, 0);
    wxFlexGridSizer* sizer_lat = new wxFlexGridSizer(1, 3, 0, 0);
    wxFlexGridSizer* sizer_long = new wxFlexGridSizer(1, 3, 0, 0);
    wxFlexGridSizer* sizer_state = new wxFlexGridSizer(1, 2, 0, 0);
    wxFlexGridSizer* sizer_country = new wxFlexGridSizer(1, 2, 0, 0);
    wxFlexGridSizer* sizer_name = new wxFlexGridSizer(1, 2, 0, 0);
    sizer_name->Add(label_name, 0, wxALL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    sizer_name->Add(name_edit, 0, wxALL|wxEXPAND|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    sizer_name->AddGrowableCol(1);
    sizer_data->Add(sizer_name, 1, wxALL|wxEXPAND, 3);
    sizer_country->Add(label_country, 0, wxALL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    sizer_country->Add(country_edit, 0, wxALL|wxEXPAND|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    sizer_country->AddGrowableCol(1);
    sizer_data->Add(sizer_country, 1, wxALL|wxEXPAND, 3);
    sizer_state->Add(label_state, 0, wxALL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    sizer_state->Add(state_edit, 0, wxALL|wxEXPAND|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    sizer_state->AddGrowableCol(1);
    sizer_data->Add(sizer_state, 1, wxALL|wxEXPAND, 3);
    sizer_long->Add(label_long, 0, wxALL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    sizer_long->Add(long_edit, 0, wxALL|wxEXPAND|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    sizer_long->Add(choice_ew, 0, wxALL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    sizer_long->AddGrowableCol(1);
    sizer_data->Add(sizer_long, 1, wxALL|wxEXPAND, 3);
    sizer_lat->Add(label_lat, 0, wxALL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    sizer_lat->Add(lat_edit, 0, wxALL|wxEXPAND|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    sizer_lat->Add(choice_ns, 0, wxALL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    sizer_lat->AddGrowableCol(1);
    sizer_data->Add(sizer_lat, 1, wxALL|wxEXPAND, 3);
    sizer_tz->Add(label_tz, 0, wxALL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    sizer_tz->Add(text_tz, 0, wxALL|wxEXPAND|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    sizer_tz->Add(choice_tzew, 0, wxLEFT|wxRIGHT|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    sizer_tz->AddGrowableCol(1);
    sizer_data->Add(sizer_tz, 1, wxALL|wxEXPAND, 3);
    sizer_main->Add(sizer_data, 1, wxALL|wxEXPAND, 8);
    wxStaticLine* static_line_button = new wxStaticLine(this, -1, wxDefaultPosition, wxDefaultSize, wxLI_VERTICAL);
    sizer_main->Add(static_line_button, 0, wxLEFT|wxRIGHT|wxEXPAND, 8);
    sizer_button->Add(button_ok, 0, wxALL|wxALIGN_CENTER_HORIZONTAL, 3);
    sizer_button->Add(button_cancel, 0, wxALL|wxALIGN_CENTER_HORIZONTAL, 3);
    sizer_main->Add(sizer_button, 1, wxALL|wxALIGN_CENTER_VERTICAL, 3);
    SetAutoLayout(true);
    SetSizer(sizer_main);
    sizer_main->Fit(this);
    sizer_main->SetSizeHints(this);
    sizer_main->AddGrowableCol(0);
    Layout();
    // end wxGlade
}

