/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           LocationEditDialog.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifndef LOCATIONEDITDIALOG_H
#define LOCATIONEDITDIALOG_H

#ifdef __GNUG__
	#pragma interface "LocationEditDialog.h"
#endif

#include "DataSet.h"

#include <wx/dialog.h>

class wxButton;
class wxChoice;
class wxStaticBox;
class wxStaticLine;
class wxStaticText;
class wxTextCtrl;

// begin wxGlade: dependencies
// end wxGlade

/*****************************************************
**
**   CLASS LocationEditDialog  
**
******************************************************/
class LocationEditDialog: public wxDialog
{
	DECLARE_CLASS( LocationEditDialog )
public:
    // begin wxGlade: LocationEditDialog::ids
    // end wxGlade

	LocationEditDialog(wxWindow* parent, int id, const wxString& title, const wxPoint& pos=wxDefaultPosition,
		const wxSize& size=wxDefaultSize, long style=wxDEFAULT_DIALOG_STYLE);
	LocationEditDialog(wxWindow* parent, const wxString& title, LocationEntry* );
	void setEntry( LocationEntry *e );
	LocationEntry *getEntry() { return &entry; }

	DECLARE_EVENT_TABLE()
private:
    // begin wxGlade: LocationEditDialog::methods
    void set_properties();
    void do_layout();
    // end wxGlade

		void OnOK( wxCommandEvent &event );
		LocationEntry entry;

protected:
    // begin wxGlade: LocationEditDialog::attributes
    wxStaticBox* sizer_data_staticbox;
    wxStaticText* label_name;
    wxTextCtrl* name_edit;
    wxStaticText* label_country;
    wxTextCtrl* country_edit;
    wxStaticText* label_state;
    wxTextCtrl* state_edit;
    wxStaticText* label_long;
    wxTextCtrl* long_edit;
    wxChoice* choice_ew;
    wxStaticText* label_lat;
    wxTextCtrl* lat_edit;
    wxChoice* choice_ns;
    wxStaticText* label_tz;
    wxTextCtrl* text_tz;
    wxChoice* choice_tzew;
    wxButton* button_ok;
    wxButton* button_cancel;
    // end wxGlade
};


#endif // LOCATIONEDITDIALOG_H
