/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           PrintConfigurationDialog.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifndef PRINTCONFIGURATIONDIALOG_H
#define PRINTCONFIGURATIONDIALOG_H

#ifdef __GNUG__
	#pragma interface "PrintConfigurationDialog.h"
#endif

// begin wxGlade: dependencies
// end wxGlade

#include <wx/dialog.h>
#include <vector>

using namespace std;

class Horoscope;
class PrintInfo;
class wxButton;
class wxChoice;
class wxCheckBox;
class wxCommandEvent;
class wxStaticBox;
class wxStaticText;
class wxTextCtrl;

enum { PC_CHOOSEFILE = wxID_HIGHEST + 2000 };

/*****************************************************
**
**   CLASS PrintConfigurationDialog
**
******************************************************/
class PrintConfigurationDialog: public wxDialog
{
public:
    // begin wxGlade: PrintConfigurationDialog::ids
    // end wxGlade

	PrintConfigurationDialog(wxWindow* parent, Horoscope* );
	int getSelectedPrintout();
	wxString getFilename();
private:
    // begin wxGlade: PrintConfigurationDialog::methods
    void set_properties();
    void do_layout();
    // end wxGlade
	DECLARE_CLASS( PrintConfigurationDialog )
	DECLARE_EVENT_TABLE()
	void OnChoice( wxCommandEvent& );
	void OnTextChanged( wxCommandEvent& );
	void OnChooseFile( wxCommandEvent& );

protected:
	Horoscope *h;
	void setFields();
    // begin wxGlade: PrintConfigurationDialog::attributes
    wxStaticBox* sizer_1_staticbox;
    wxStaticBox* sizer_type_staticbox;
    wxChoice* choice_type;
    wxTextCtrl* text_description;
    wxButton* button_file;
    wxTextCtrl* text_file;
    wxButton* button_ok;
    wxButton* button_cancel;
    // end wxGlade
};



#endif

