/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           Ashtakavarga.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/
#ifndef _ASHTAKAVARGA_H_
#define _ASHTAKAVARGA_H_

#ifdef __GNUG__
	#pragma interface "Ashtakavarga.h"
#endif

#include<wx/string.h>

#include "Varga.h"

class Writer;

enum { REKHA, TRIKONA, EKADHI, RASISAMA, NAKSHATRASAMA };
enum { GRAHAPINDA, RASIPINDA, YOGAPINDA };

/*****************************************************
**
**   CLASS AshtakavargaExpert  
**
******************************************************/
class AshtakavargaExpert : public Expert
{
public:

	AshtakavargaExpert( VargaView *v ) : Expert( v ) {}
	void update();

	void setView( VargaView *v ) { view = v; }

	// get Ashtakavarga value for rasi
	// type is one of REKHA, TRIKONA, EKADHI, RASISAMA, NAKSHATRASAMA
	int getItem( const int &type, const int &planet, const int &rasi );

	// returns the pinda value, pinda is one of GRAHAPINDA, RASIPINDA, YOGAPINDA
	int getPinda( const int &type, const int &rasi );

	// returns the sums for each rasi, type is one of REKHA, TRIKONA, EKADHI, RASISAMA, NAKSHATRASAMA
	int getSarva( const int &type, const int &rasi );

	int getPlanetSarva( const int &type, const int &planet );

	// dump Ashtakavarga into a stream
	void dump( wxString& );
	void write( Writer *writer, const int = 0 );
	void writeSingleAv( Writer *writer, const int& );

private:
	void calcRekha();
	void calcSarva();
	void calcPinda();
	void calcTrikonaShodana();
	void calcEkadhipatyaPair( const int &b1, const int &b2 );
	void calcEkadhipatyaShodana();
	wxChar rekha[8][12], trikona[8][12], ekadhi[8][12];
	int sarvaRekha[12], sarvaTrikona[12], sarvaEkadhi[12];
	int psarvaRekha[8], psarvaTrikona[8], psarvaEkadhi[8];
	int grahaPinda[12], rasiPinda[12], yogaPinda[12];

	int planetNumber[12];
};

#endif

