/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           AshtottariDasa.cpp
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifdef __GNUG__
	#pragma implementation "AshtottariDasa.h"
#endif

#include "AshtottariDasa.h"

#include<wx/log.h>

#include "func.h"
#include "Calculator.h"
#include "Dasa.h"
#include "Horoscope.h"
#include "IPlanet.h"
#include "Lang.h"
#include "Session.h"
#include "Varga.h"


const int AshtottariDasaExpert::dasa_lord[8] = { ISUN, IMOON, IMARS, IMERCURY, ISATURN, IJUPITER, IRAHU, IVENUS };
const int AshtottariDasaExpert::dasa_dur[8] = { 6, 15, 8, 17, 10, 19, 12, 21  };

/*****************************************************
**
**   <-- AshtottariDasaExpert   ---   getNextLevel -->
**
******************************************************/
vector<Dasa*> AshtottariDasaExpert::getNextLevel( Dasa *dasa )
{
	vector<Dasa*> ret;
	const int lord_map[8] = { 0, 1, 2, 3, 5, 7, 4, 6 };
	
	double start_jd = dasa->getStartJD();
	double end_jd = dasa->getEndJD();
	double dasa_len = end_jd - start_jd;
	double antar_len = 0;
	int dlord = dasa->getDasaLord();
	int lordindex = lord_map[dlord];

	// Guru Venus is left handed
	lordindex -= 1;
	if ( lordindex < 0 ) lordindex = 7;
	dlord = dasa_lord[lordindex];

	for( int i = 0; i < 8; i++ )
	{
		antar_len = ( dasa_len * dasa_dur[lordindex] ) / 108;
		end_jd = start_jd + antar_len;
		ret.push_back( new DasaImpl( this, dlord, start_jd, end_jd, 0, dasa ));
	
		lordindex -= 1;
		if ( lordindex < 0 ) lordindex = 7;
		dlord = dasa_lord[lordindex];
		start_jd = end_jd;
	}

	return ret;
}

/*****************************************************
**
**   <-- AshtottariDasaExpert   ---   getFirstLevel -->
**
******************************************************/
vector<Dasa*> AshtottariDasaExpert::getFirstLevel( Horoscope *h, int varga )
{
	vector<Dasa*> ret;
	VargaView view( h, varga );

	int mnak = view.getNakshatra( IMOON, N28 );
	int startn = mnak - 5;
	if ( startn < 0 ) startn += 28;

	double nportion, portion;
	//if ( varga == 0 ) nportion = h->getNakshatraPortion();
	nportion = view.getNakshatraLength( IMOON, N28 ) / 13.33333333;

	int pindex;

	// Ardra, Punarvasu, Pusyami, Ashlesha
	if ( startn < 4 )
	{
		// Sun dasa
		pindex = 0;
		portion = ( startn + nportion ) / 4;
	}
	// Makha, P.Phalguni, U.Phalguni
	else if ( startn < 7 )
	{
		// Moon dasa
		pindex = 1;
		portion = ( startn - 4 + nportion ) / 4;
	}
	// Hasta, Chitta, Swati, Vishakha
	else if ( startn < 11 )
	{
		// Mars dasa
		pindex = 2;
		portion = ( startn - 7 + nportion ) / 4;
	}
	// Anuradha, Jyeshta, Moola
	else if ( startn < 14 )
	{
		// Mercury dasa
		pindex = 3;
		portion = ( startn - 11 + nportion ) / 4;
	}
	// P.Shadha, U.Shadha, Abhijit, Sravana
	else if ( startn < 18 )
	{
		// Saturn dasa
		pindex = 4;
		portion = ( startn - 14 + nportion ) / 4;
	}
	// Dhanista, Satabhish, P.Bhadra
	else if ( startn < 21 )
	{
		// Jupiter dasa
		pindex = 5;
		portion = ( startn - 18 + nportion ) / 4;
	}
	// U.Bhadra, Revati, Aswini, Bharani
	else if ( startn < 25 )
	{
		// Rahu dasa
		pindex = 6;
		portion = ( startn - 21 + nportion ) / 4;
	}
	// Krittika, Rohini, Mrigasira
	else if ( startn < 28 )
	{
		// Venus dasa
		pindex = 7;
		portion = ( startn - 25 + nportion ) / 4;
	}
	else
	{
		wxLogError( wxT( "Error Nakshatra index in Ashtottari is %d, exiting." ), startn );
		exit(1);
	}

	int dlord = dasa_lord[pindex];
	double start_jd = h->getJD() - portion * dasa_dur[pindex] * getYearLength( true );
	double end_jd;

	for( int i = 0; i < 8; i++ )
	{
		end_jd = start_jd + dasa_dur[pindex] * getYearLength( true );
		ret.push_back( new DasaImpl( this, dlord, start_jd, end_jd, 0, 0 ));

		pindex = ( pindex + 1 ) % 8;
		dlord = dasa_lord[pindex];
		start_jd = end_jd;
	}

	return ret;
}


