/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           ColorProvider.cpp
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifdef __GNUG__
	#pragma implementation "ColorProvider.h"
#endif

#include "ColorProvider.h"

#include <wx/colour.h>
#include <wx/log.h>
#include <wx/menu.h>
#include <wx/panel.h>
#include <wx/settings.h>
#include <wx/window.h>

#include "Conf.h"

extern Config *config;

wxColour *ColorProvider::colorBg = 0;
wxColour *ColorProvider::colorBg2 = 0;
wxColour *ColorProvider::colorFg = 0;
wxColour *ColorProvider::colorFg2 = 0;
wxColour *ColorProvider::colorMarked = 0;
wxColour *ColorProvider::colorBenefic = 0;
wxColour *ColorProvider::colorMalefic = 0;

/**************************************************************
***
**   ColorProvider   ---   Constructor
***
***************************************************************/
ColorProvider::ColorProvider()
{
}

/**************************************************************
***
**   ColorProvider   ---   reinit
***
***************************************************************/
void ColorProvider::reinit()
{
	colorBg = 0;
	colorBg2 = 0;
	colorFg = 0;
	colorFg2 = 0;
	colorMarked = 0;
	colorBenefic = 0;
	colorMalefic = 0;
}

/**************************************************************
***
**   ColorProvider   ---   getRgbString
***
***************************************************************/
void ColorProvider::getRgbString( wxString &s, int c )
{
	unsigned char red, green, blue;
	wxColor *color = getColor( c );
	red = color->Red();
	green = color->Green();
	blue = color->Blue();
	s.Printf( wxT( "#%02x%02x%02x" ), red, green, blue );
}

/**************************************************************
***
**   ColorProvider   ---   initColor
***
***************************************************************/
wxColour *ColorProvider::initColor( const int cf, const int f  )
{
	unsigned char red, green, blue;
	if ( cf != -1 )
	{
		getRgbValues( cf, red, green, blue );
		return new wxColour( red, green, blue );	
	}
	else
	{
		wxWindow window( 0, -1 );
		wxPanel panel( 0, -1 );
		wxMenuBar menubar;
		switch( f )
		{
			case COLOR_BG:
				//return new wxColour( wxSystemSettings::GetColour( wxSYS_COLOUR_WINDOW ));
				//wxWindow window( 0, -1 );
				return new wxColour( window.GetBackgroundColour());

				//return new wxColour( wxSystemSettings::GetColour( wxSYS_COLOUR_BACKGROUND ));
			break;
			case COLOR_BG2:
				return new wxColour( menubar.GetBackgroundColour());
				//return new wxColour( wxSystemSettings::GetColour( wxSYS_COLOUR_WINDOW ));
				//return new wxColour( wxSystemSettings::GetColour( wxSYS_COLOUR_BTNFACE ));
				//return new wxColour( wxSystemSettings::GetColour( wxSYS_COLOUR_APPWORKSPACE ));
			break;
			case COLOR_FG:
				return new wxColour( window.GetForegroundColour());
				//return new wxColour( wxSystemSettings::GetColour( wxSYS_COLOUR_WINDOWTEXT ));
			break;
			case COLOR_FG2:
				return new wxColour( wxSystemSettings::GetColour( wxSYS_COLOUR_HIGHLIGHTTEXT ));
			break;
			case COLOR_MARKED:
				return new wxColour( *wxLIGHT_GREY );
			break;
			case COLOR_BENEFIC:
				return new wxColour( *wxGREEN );
			break;
			case COLOR_MALEFIC:
				return new wxColour( *wxRED );
			break;
			default:
				assert( false );
			break;
		}
	}
	return new wxColour( *wxWHITE );
}

/*****************************************************
**
**   getRgbValues
**
******************************************************/
void ColorProvider::getRgbValues( const int &color, unsigned char &red, unsigned char &green, unsigned char &blue )
{
	int i; 
	blue = (unsigned char)( color % 256 );
	i = ( color - blue ) / 256; 
	green = (unsigned char)(i % 256);    
	red = (unsigned char)(( i - green ) / 256 );
}

/**************************************************************
***
**   ColorProvider   ---   getColor
***
***************************************************************/
wxColour *ColorProvider::getColor( const int c )
{
	switch( c )
	{
		case COLOR_BG:
			if ( ! colorBg ) colorBg = initColor( config->color_bg, c );
			return colorBg;
			break;
			case COLOR_BG2:
				if ( ! colorBg2 ) colorBg2 = initColor( config->color_bg2, c );
				return colorBg2;
			break;
			case COLOR_FG:
				if ( ! colorFg ) colorFg = initColor( config->color_fg, c );
				return colorFg;
			break;
			case COLOR_FG2:
				if ( ! colorFg2 ) colorFg2 = initColor( config->color_fg2, c );
				return colorFg2;
			break;
			case COLOR_MARKED:
				if ( ! colorMarked ) colorMarked = initColor( config->color_marked, c );
			return colorMarked;
		break;
		case COLOR_BENEFIC:
			if ( ! colorBenefic ) colorBenefic = initColor( config->color_benefic, c );
			return colorBenefic;
		break;
		case COLOR_MALEFIC:
			if ( ! colorMalefic ) colorMalefic = initColor( config->color_malefic, c );
			return colorMalefic;
		break;
		default:
			wxLogError( wxT(  "Warning: invalid color %d returning default" ), c );
			if ( ! colorBg ) colorBg = initColor( config->color_bg, c );
			return colorBg;
		break;
	}
}

