/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           ColorProvider.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifndef _COLORPROVIDER_H_
#define _COLORPROVIDER_H_

#ifdef __GNUG__
	#pragma interface "ColorProvider.h"
#endif

#include <wx/object.h>
#include <wx/string.h>

class wxColour;

enum { COLOR_BG = 0, COLOR_BG2, COLOR_FG, COLOR_FG2, COLOR_MARKED, COLOR_BENEFIC, COLOR_MALEFIC };

/*****************************************************
**
**   CLASS ColorProvider  
**
******************************************************/
class ColorProvider : public wxObject
{
public:
	ColorProvider();
	void reinit();
	wxColour *getBgColor() { return getColor( COLOR_BG ); }
	wxColour *getBg2Color() { return getColor( COLOR_BG2 ); }
	wxColour *getFgColor() { return getColor( COLOR_FG ); }
	wxColour *getFg2Color() { return getColor( COLOR_FG2 ); }
	wxColour *getMarkedColor() { return getColor( COLOR_MARKED ); }
	wxColour *getBeneficColor() { return getColor( COLOR_BENEFIC ); }
	wxColour *getMaleficColor() { return getColor( COLOR_MALEFIC ); }
	void getRgbValues( const int &color, unsigned char &red, unsigned char &green, unsigned char &blue );
	void getRgbString( wxString &s, int c );
	wxColour *getColor( const int );

private:
	static wxColour *colorBg, *colorBg2, *colorFg, *colorFg2, *colorMarked, *colorBenefic, *colorMalefic;
	wxColour *initColor( const int cf, const int f  );
};

#endif


