/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           Conf.cpp
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifdef __GNUG__
	#pragma implementation "Conf.h"
#endif

#include "Conf.h"
#include "func.h"
#include "Session.h"

#include <wx/confbase.h>
#include <wx/defs.h>
#ifndef __WXMSW__
#include <wx/fileconf.h>
#endif
#include <wx/filename.h>
#include <wx/string.h>
#include <wx/utils.h>

/*****************************************************
**
**   Config   ---   Constructor
**
******************************************************/
Config::Config()
{
#ifdef __WXMSW__
	cfg = wxConfigBase::Get();
#else
	wxString s;
	s << Session::get()->getConfigDir();
	if ( s.Last() != wxFileName::GetPathSeparator()) s << wxFileName::GetPathSeparator();
	s << wxT( "config" );

	wxFileConfig *ccfg = new wxFileConfig( APP_NAME, VENDOR_NAME, s, wxEmptyString, wxCONFIG_USE_LOCAL_FILE );

	cfg = ccfg;
#endif
	cfg->SetRecordDefaults();
}

/*****************************************************
**
**   Config   ---   Destructor
**
******************************************************/
Config::~Config()
{
	//delete cfg;
}

/*****************************************************
**
**   Config   ---   writeDoubleEntry
**
******************************************************/
void  Config::writeDoubleEntry( wxString path, const double value )
{
	wxString s;
	s.Printf( wxT( "%.12f" ), value );
	cfg->Write( path, s );
}

/*****************************************************
**
**   Config   ---   readDoubleEntry
**
******************************************************/
double Config::readDoubleEntry( wxString path, const double def )
{
	wxString s;
	wxString dd;
	dd.Printf( wxT( "%.12f" ), def );
	cfg->Read( path, &s, dd );
	return myatof( s );
}

/*****************************************************
**
**   Config   ---   readAll
**
******************************************************/
void Config::readAll()
{
	wxString locationName;
	double lon, lat, tz, dst;

	cfg->Read( wxT( "/General/logMode" ), &logMode, 0l );
	cfg->Read( wxT( "/General/preferVedic" ), &preferVedic, true );
	cfg->Read( wxT( "/General/preferHtml2Text" ), &preferHtml2Text, true );
	cfg->Read( wxT( "/General/maxRecentFiles" ), &maxRecentFiles, 12 );
	cfg->Read( wxT( "/General/askOnQuit" ), &askOnQuit, false );
	cfg->Read( wxT( "/General/openNewDocOnStart" ), &openNewDocOnStart, true );
	cfg->Read( wxT( "/General/animateInterval" ), &animateInterval, 5 );
	cfg->Read( wxT( "/General/animateMode" ), &animateMode, 0 );
	cfg->Read( wxT( "/General/animateStepLength" ), &animateStepLength, 5 );
	cfg->Read( wxT( "/General/animateStepDimension" ), &animateStepDimension, 0 );
	cfg->Read( wxT( "/General/recentFileList" ), &recentFileList );
	cfg->Read( wxT( "/General/lang" ), &lang, wxT( "en" ));
	cfg->Read( wxT( "/General/langList" ), &langList, wxT( "de ru" ));
	cfg->Read( wxT( "/General/partnerStyle" ), &partnerStyle, 1 );
	cfg->Read( wxT( "/General/textStyle" ), &textStyle, 1 );
	cfg->Read( wxT( "/General/useMultipleViews" ), &useMultipleViews, false );
	cfg->Read( wxT( "/General/textWindowPage" ), &textWindowPage, 0 );
	cfg->Read( wxT( "/General/LocationBackupMode" ), &locationBackupMode, 1 );

	cfg->Read( wxT( "/General/DefaultLocation/LocationName" ), &locationName, wxT( "" ));
	lon = readDoubleEntry( wxT( "/General/DefaultLocation/Longitude" ));
	lat = readDoubleEntry( wxT( "/General/DefaultLocation/Latitude" ));
	tz = readDoubleEntry( wxT( "/General/DefaultLocation/TimeZone" ));
	dst = readDoubleEntry( wxT( "/General/DefaultLocation/Dst" ));
  defaultLocation.setLocation( locationName, lon, lat, tz, dst );

	// do we still need that ?
	cfg->Read( wxT( "/General/closeDocumentOnMainWindowClose" ), &closeDocumentOnMainWindowClose, true );

	custom_t0 = readDoubleEntry( wxT( "/Calculation/Ayanamsa/custom_t0" ), DEFAULT_T0 );
	custom_ayan_t0 = readDoubleEntry( wxT( "/Calculation/Ayanamsa/custom_ayan_t0" ),  DEFAULT_AYAN_T0 );
	custom_aya_period = readDoubleEntry( wxT( "/Calculation/Ayanamsa/custom_aya_period" ), DEFAULT_AYA_PERIOD );
	cfg->Read( wxT( "/Calculation/Ayanamsa/custom_aya_constant" ), &custom_aya_constant, false );
	cfg->Read( wxT( "/Calculation/General/sunrise_refrac" ), &sunrise_refrac, false );
	cfg->Read( wxT( "/Calculation/General/sunrise_def" ), &sunrise_def, 0 );
	cfg->Read( wxT( "/Calculation/General/ephemMode" ), &ephemMode, 0 );
	cfg->Read( wxT( "/Calculation/General/ephemTimezone" ), &ephemTimezone, 0 );

	cfg->Read( wxT( "/Calculation/General/useEphemerisTime" ), &useEphemerisTime, false );
	cfg->Read( wxT( "/Calculation/General/useTopocentric" ), &useTopocentric, false );
	cfg->Read( wxT( "/Calculation/General/useTruePositions" ), &useTruePositions, false );

	cfg->Read( wxT( "/Vedic/Calculation/Ayanamsa" ), &iAyanamsa, 1 );
	cfg->Read( wxT( "/Vedic/Calculation/HouseSystem" ), &iHouseSystem, HOUSE_SYSTEM_PORPHYRY );
	cfg->Read( wxT( "/Vedic/Calculation/HouseWestern" ), &iHouseWestern, false );
	cfg->Read( wxT( "/Vedic/Calculation/LunarNodeMode" ), &iLunarNodeMode, LUNAR_NODE_MEAN );
	cfg->Read( wxT( "/Vedic/Calculation/ArudhaMode" ), &iArudhaMode, 0 );
	cfg->Read( wxT( "/Vedic/Calculation/HoraMode" ), &iHoraMode, 0 );
	cfg->Read( wxT( "/Vedic/Calculation/DrekkanaMode" ), &iDrekkanaMode, 0 );
	cfg->Read( wxT( "/Vedic/Calculation/NakshatraMode28" ), &iNakshatraMode28, 0 );
	cfg->Read( wxT( "/Vedic/Calculation/NakshatraPortionMode" ), &iNakshatraPortionMode, 0 );
	cfg->Read( wxT( "/Vedic/Calculation/KalachakraMode" ), &iKalachakraMode, 0 );
	cfg->Read( wxT( "/Vedic/Calculation/AshtakavargaMode" ), &iAshtakavargaMode, 0 );
	cfg->Read( wxT( "/Vedic/Calculation/YearLength" ), &iYearLength, 0 );
	double a = ICUSTOM_YEAR_LEN;
	iCustomYearLength = readDoubleEntry( wxT( "/Vedic/Calculation/CustomYearLength" ), a );

	cfg->Read( wxT( "/Vedic/Appearance/MainChildStyleGraphicStyle" ), &iGraphicStyle,
		IGRAPHIC_STYLE_SOUTH_INDIAN | IGRAPHIC_STYLE_SHOW_RETRO );
	cfg->Read( wxT( "/Vedic/Appearance/MainChildStyleChartCenter" ), &iChartCenter, 1 );
	cfg->Read( wxT( "/Vedic/Appearance/MainChildStyle" ), &iMainChildStyle,
		IMAIN_CHILD_SHOW_NAVAMSA | IMAIN_CHILD_SHOW_NAKSHATRA );
	cfg->Read( wxT( "/Vedic/Appearance/DefaultDasaList" ), &iDefaultDasaList, 7 );

	cfg->Read( wxT( "/Western/Calculation/Ayanamsa" ), &wAyanamsa, 0 );
	cfg->Read( wxT( "/Western/Calculation/HouseSystem" ), &wHouseSystem, HOUSE_SYSTEM_PLACIDUS );
	cfg->Read( wxT( "/Western/Calculation/LunarNodeMode" ), &wLunarNodeMode, LUNAR_NODE_TRUE );

	cfg->Read( wxT( "/Western/Appearance/GraphicStyle" ), &wGraphicStyle,
		WGRAPHIC_STYLE_SHOW_HOUSES | WGRAPHIC_STYLE_SHOW_ASPECTS | WGRAPHIC_STYLE_SHOW_RETRO );
	cfg->Read( wxT( "/Western/Appearance/OrbisAspects" ), &wOrbisAspects, 5 );
	cfg->Read( wxT( "/Western/Appearance/MainChildStyle" ), &wMainChildStyle, WMAIN_CHILD_SHOW_HOUSEPOS );
	cfg->Read( wxT( "/Western/Appearance/UseGraphicSymbols" ), &useGraphicSymbols, true );
	// TODO
	useGraphicSymbols = false;

	// Midpoint
	cfg->Read( wxT( "/Midpoint/OrbisRadix" ), &wOrbisRadix, 90 );
	cfg->Read( wxT( "/Midpoint/OrbisTransit" ), &wOrbisTransit, 30 );
	cfg->Read( wxT( "/Midpoint/OrbisPartner" ), &wOrbisPartner, 30 );
	cfg->Read( wxT( "/Midpoint/System" ), &hsSystem, 0 ); // Ebertin
	cfg->Read( wxT( "/Midpoint/RememberOrbis" ), &hsRememberOrbis, false );
	cfg->Read( wxT( "/Midpoint/RememberGradkreis" ), &hsRememberGradkreis, false );
	cfg->Read( wxT( "/Midpoint/RememberYearLength" ), &hsRememberYearLength, false );
	cfg->Read( wxT( "/Midpoint/RememberTransitModus" ), &hsRememberTransitModus, false );
	cfg->Read( wxT( "/Midpoint/GradkreisRadix" ), &hsGradkreisRadix, GRADKREIS_45 );
	cfg->Read( wxT( "/Midpoint/GradkreisTransit" ), &hsGradkreisTransit, GRADKREIS_45 );
	cfg->Read( wxT( "/Midpoint/GradkreisPartner" ), &hsGradkreisPartner, GRADKREIS_45 );
	cfg->Read( wxT( "/Midpoint/YearLength" ), &hsYearLength, 0 );
	double b = WCUSTOM_YEAR_LEN;
	cfg->Read( wxT( "/Midpoint/CustomYearLength" ), &hsCustomYearLength, b );
	cfg->Read( wxT( "/Midpoint/hsTransitModus" ), &hsTransitModus, 0 );
	cfg->Read( wxT( "/Midpoint/UseSpecialEventSymbols" ), &hsUseSpecialEventSymbols, false );

	cfg->Read( wxT( "/Appearance/Colors/fg" ), &color_fg, 0 );
	cfg->Read( wxT( "/Appearance/Colors/fg2" ), &color_fg2, 1389713 );
	cfg->Read( wxT( "/Appearance/Colors/bg" ), &color_bg, 16777215 );
	cfg->Read( wxT( "/Appearance/Colors/bg2" ), &color_bg2, 11325153 );
	cfg->Read( wxT( "/Appearance/Colors/marked" ), &color_marked, 15592834 );
	cfg->Read( wxT( "/Appearance/Colors/benefic" ), &color_benefic, 2334755 );
	cfg->Read( wxT( "/Appearance/Colors/malefic" ), &color_malefic, 14049890 );

	cfg->Read( wxT( "/Appearance/Sizes/xMasterWindow" ), &xMasterWindow, 720 );
	cfg->Read( wxT( "/Appearance/Sizes/yMasterWindow" ), &yMasterWindow, 200 );
	cfg->Read( wxT( "/Appearance/Positions/xPosMasterWindow" ), &xPosMasterWindow, 50 );
	cfg->Read( wxT( "/Appearance/Positions/yPosMasterWindow" ), &yPosMasterWindow, 50 );

	cfg->Read( wxT( "/Appearance/Sizes/xMultipleView" ), &xMultipleView, 800 );
	cfg->Read( wxT( "/Appearance/Sizes/yMultipleView" ), &yMultipleView, 600 );

	cfg->Read( wxT( "/Appearance/Sizes/xMainWindow" ), &xMainWindow, 500 );
	cfg->Read( wxT( "/Appearance/Sizes/yMainWindow" ), &yMainWindow, 400 );

	cfg->Read( wxT( "/Appearance/Sizes/xVedicGraphicWindow" ), &xVedicGraphicWindow, 350 );
	cfg->Read( wxT( "/Appearance/Sizes/yVedicGraphicWindow" ), &yVedicGraphicWindow, 350 );

	cfg->Read( wxT( "/Appearance/Sizes/xWesternGraphicWindow" ), &xWesternGraphicWindow, 450 );
	cfg->Read( wxT( "/Appearance/Sizes/yWesternGraphicWindow" ), &yWesternGraphicWindow, 450 );

	cfg->Read( wxT( "/Appearance/Sizes/xTextWindow" ), &xTextWindow, 700 );
	cfg->Read( wxT( "/Appearance/Sizes/yTextWindow" ), &yTextWindow, 500 );

	cfg->Read( wxT( "/Appearance/Sizes/xDasaWindow" ), &xDasaWindow, 400 );
	cfg->Read( wxT( "/Appearance/Sizes/yDasaWindow" ), &yDasaWindow, 500 );

	cfg->Read( wxT( "/Appearance/Sizes/xGraphicalDasaWindow" ), &xGraphicalDasaWindow, 800 );
	cfg->Read( wxT( "/Appearance/Sizes/yGraphicalDasaWindow" ), &yGraphicalDasaWindow, 600 );

	cfg->Read( wxT( "/Appearance/Sizes/xSbcWindow" ), &xSbcWindow, 800 );
	cfg->Read( wxT( "/Appearance/Sizes/ySbcWindow" ), &ySbcWindow, 600 );

	cfg->Read( wxT( "/Appearance/Sizes/xSolarWindow" ), &xSolarWindow, 600 );
	cfg->Read( wxT( "/Appearance/Sizes/ySolarWindow" ), &ySolarWindow, 500 );

	cfg->Read( wxT( "/Appearance/Sizes/xMidpointWindow" ), &xMidpointWindow, 800 );
	cfg->Read( wxT( "/Appearance/Sizes/yMidpointWindow" ), &yMidpointWindow, 600 );

	cfg->Read( wxT( "/Appearance/Sizes/xTransitWindow" ), &xTransitWindow, 800 );
	cfg->Read( wxT( "/Appearance/Sizes/yTransitWindow" ), &yTransitWindow, 600 );

	cfg->Read( wxT( "/Appearance/Sizes/xEphemWindow" ), &xEphemWindow, 800 );
	cfg->Read( wxT( "/Appearance/Sizes/yEphemWindow" ), &yEphemWindow, 600 );

	cfg->Read( wxT( "/Appearance/Sizes/xEclipseWindow" ), &xEclipseWindow, 600 );
	cfg->Read( wxT( "/Appearance/Sizes/yEclipseWindow" ), &yEclipseWindow, 500 );

	cfg->Read( wxT( "/Appearance/Sizes/xHoraWindow" ), &xHoraWindow, 600 );
	cfg->Read( wxT( "/Appearance/Sizes/yHoraWindow" ), &yHoraWindow, 500 );

	cfg->Read( wxT( "/Appearance/Sizes/xPartnerWindow" ), &xPartnerWindow, 800 );
	cfg->Read( wxT( "/Appearance/Sizes/yPartnerWindow" ), &yPartnerWindow, 600 );

	cfg->Read( wxT( "/Appearance/Signs/VedicSigns" ), &useVedicSigns, false );
	cfg->Read( wxT( "/Appearance/Signs/VedicPositions" ), &useVedicPositions, false );
	cfg->Read( wxT( "/Appearance/Signs/SignPrecision" ), &signPrecision, TMEDIUM );

	cfg->Read( wxT( "/Appearance/MainWindow/MainToolbar" ), &showMainToolbar, true );
	cfg->Read( wxT( "/Appearance/MainWindow/listStyle" ), &listStyle, 0 );
	cfg->Read( wxT( "/Appearance/MainWindow/StatusInfo" ), &showStatusInfo , true );
	cfg->Read( wxT( "/Appearance/MainWindow/StatusBar" ), &showStatusBar, false );
	cfg->Read( wxT( "/Appearance/Windows/childFrameWidth" ), &childFrameWidth, 3 );

	cfg->Read( wxT( "/General/Print/ShowPageFrame" ), &printShowPageFrame, true );
	cfg->Read( wxT( "/General/Print/ShowSelectDialog" ), &printShowSelectDialog, true );
	cfg->Read( wxT( "/General/Print/AskOnOverwrite" ), &printAskOverwrite, true );
	cfg->Read( wxT( "/General/Print/LaunchPdfViewer" ), &printLaunchPdfViewer, true );
	cfg->Read( wxT( "/General/Print/PdfViewerCommand" ), &printPdfViewerCommand, wxEmptyString );
	cfg->Read( wxT( "/General/Print/DefaultPrintout" ), &printDefaultPrintout, 0 );
	cfg->Read( wxT( "/General/Print/PaperFormat" ), &printPaperFormat, wxPAPER_A4 );

	cfg->Read( wxT( "/General/defOpenPath" ), &defOpenPath );
	cfg->Read( wxT( "/General/defSavePath" ), &defSavePath );
	if ( defSavePath == wxEmptyString ) defSavePath = wxGetHomeDir();
	cfg->Read( wxT( "/General/defExportPath" ), &defExportPath );
	if ( defExportPath == wxEmptyString ) defExportPath = wxGetHomeDir();
	cfg->Read( wxT( "/General/sePath" ), &sePath );
	cfg->Read( wxT( "/General/favouriteCountries" ), &favouriteCountries );

	cfg->Read( wxT( "/Appearance/Fonts/Default" ), &fontDefault );
	cfg->Read( wxT( "/Appearance/Fonts/Header" ), &fontHeader );
	cfg->Read( wxT( "/Appearance/Fonts/Graphic" ), &fontGraphic );
	cfg->Read( wxT( "/Appearance/Fonts/Text" ), &fontText );
	cfg->Read( wxT( "/Appearance/Fonts/Symbol" ), &fontSymbol );

	cfg->Read( wxT( "/General/defaultView" ), &defaultView, wxT( "view1" ) );
}

/*****************************************************
**
**   Config   ---   writeAll
**
******************************************************/
void Config::writeAll()
{
	cfg->Write( wxT( "/General/logMode" ), logMode );
	cfg->Write( wxT( "/General/preferVedic" ), preferVedic );
	cfg->Write( wxT( "/General/preferHtml2Text" ), preferHtml2Text );
	cfg->Write( wxT( "/General/maxRecentFiles" ), maxRecentFiles );
	cfg->Write( wxT( "/General/askOnQuit" ), askOnQuit );
	cfg->Write( wxT( "/General/openNewDocOnStart" ), openNewDocOnStart );
	cfg->Write( wxT( "/General/animateInterval" ), animateInterval );
	cfg->Write( wxT( "/General/animateMode" ), animateMode );
	cfg->Write( wxT( "/General/animateStepLength" ), animateStepLength );
	cfg->Write( wxT( "/General/animateStepDimension" ), animateStepDimension );
	cfg->Write( wxT( "/General/recentFileList" ), recentFileList );
	cfg->Write( wxT( "/General/lang" ), lang );
	cfg->Write( wxT( "/General/langList" ), langList );
	cfg->Write( wxT( "/General/partnerStyle" ), partnerStyle );
	cfg->Write( wxT( "/General/textStyle" ), textStyle );
	cfg->Write( wxT( "/General/useMultipleViews" ), useMultipleViews );
	cfg->Write( wxT( "/General/textWindowPage" ), textWindowPage );
	cfg->Write( wxT( "/General/LocationBackupMode" ), locationBackupMode );

	cfg->Write( wxT( "/General/DefaultLocation/LocationName" ), defaultLocation.getLocName() );
	writeDoubleEntry( wxT( "/General/DefaultLocation/Longitude" ), defaultLocation.getLongitude() );
	writeDoubleEntry( wxT( "/General/DefaultLocation/Latitude" ), defaultLocation.getLatitude() );
	writeDoubleEntry( wxT( "/General/DefaultLocation/TimeZone" ), defaultLocation.getTimeZone() );
	writeDoubleEntry( wxT( "/General/DefaultLocation/Dst" ), defaultLocation.getDST() );

	// ???
	cfg->Write( wxT( "/General/closeDocumentOnMainWindowClose" ), &closeDocumentOnMainWindowClose );
	writeDoubleEntry( wxT( "/Calculation/Ayanamsa/custom_t0" ), custom_t0 );
	writeDoubleEntry( wxT( "/Calculation/Ayanamsa/custom_ayan_t0" ), custom_ayan_t0 );
	writeDoubleEntry( wxT( "/Calculation/Ayanamsa/custom_aya_period" ), custom_aya_period );
	cfg->Write( wxT( "/Calculation/Ayanamsa/custom_aya_constant" ), custom_aya_constant );
	cfg->Write( wxT( "/Calculation/General/sunrise_refrac" ), sunrise_refrac );
	cfg->Write( wxT( "/Calculation/General/sunrise_def" ), sunrise_def );
	cfg->Write( wxT( "/Calculation/General/ephemMode" ), ephemMode );
	cfg->Write( wxT( "/Calculation/General/ephemTimezone" ), ephemTimezone );

	cfg->Write( wxT( "/Calculation/General/useEphemerisTime" ), useEphemerisTime );
	cfg->Write( wxT( "/Calculation/General/useTopocentric" ), useTopocentric );
	cfg->Write( wxT( "/Calculation/General/useTruePositions" ), useTruePositions );

	cfg->Write( wxT( "/Vedic/Calculation/Ayanamsa" ), iAyanamsa );
	cfg->Write( wxT( "/Vedic/Calculation/HouseSystem" ), iHouseSystem );
	cfg->Write( wxT( "/Vedic/Calculation/HouseWestern" ), iHouseWestern );
	cfg->Write( wxT( "/Vedic/Calculation/LunarNodeMode" ), iLunarNodeMode );
	cfg->Write( wxT( "/Vedic/Calculation/ArudhaMode" ), iArudhaMode );
	cfg->Write( wxT( "/Vedic/Calculation/HoraMode" ), iHoraMode );
	cfg->Write( wxT( "/Vedic/Calculation/DrekkanaMode" ), iDrekkanaMode );
	cfg->Write( wxT( "/Vedic/Calculation/NakshatraMode28" ), iNakshatraMode28 );
	cfg->Write( wxT( "/Vedic/Calculation/NakshatraPortionMode" ), iNakshatraPortionMode );
	cfg->Write( wxT( "/Vedic/Calculation/KalachakraMode" ), iKalachakraMode );
	cfg->Write( wxT( "/Vedic/Calculation/AshtakavargaMode" ), iAshtakavargaMode );
	cfg->Write( wxT( "/Vedic/Calculation/YearLength" ), iYearLength );
	writeDoubleEntry( wxT( "/Vedic/Calculation/CustomYearLength" ), iCustomYearLength );

	cfg->Write( wxT( "/Vedic/Appearance/MainChildStyleGraphicStyle" ), iGraphicStyle );
	cfg->Write( wxT( "/Vedic/Appearance/MainChildStyleChartCenter" ), iChartCenter );
	cfg->Write( wxT( "/Vedic/Appearance/MainChildStyle" ), iMainChildStyle );
	cfg->Write( wxT( "/Vedic/Appearance/DefaultDasaList" ), iDefaultDasaList );

	cfg->Write( wxT( "/Appearance/Sizes/xMasterWindow" ), xMasterWindow );
	cfg->Write( wxT( "/Appearance/Sizes/yMasterWindow" ), yMasterWindow );
	cfg->Write( wxT( "/Appearance/Positions/xPosMasterWindow" ), xPosMasterWindow );
	cfg->Write( wxT( "/Appearance/Positions/yPosMasterWindow" ), yPosMasterWindow );

	cfg->Write( wxT( "/Appearance/Sizes/xMultipleView" ), xMultipleView );
	cfg->Write( wxT( "/Appearance/Sizes/yMultipleView" ), yMultipleView );

	cfg->Write( wxT( "/Appearance/Sizes/xMainWindow" ), xMainWindow );
	cfg->Write( wxT( "/Appearance/Sizes/yMainWindow" ), yMainWindow );

	cfg->Write( wxT( "/Appearance/Sizes/xVedicGraphicWindow" ), xVedicGraphicWindow );
	cfg->Write( wxT( "/Appearance/Sizes/yVedicGraphicWindow" ), yVedicGraphicWindow );

	cfg->Write( wxT( "/Appearance/Sizes/xWesternGraphicWindow" ), xWesternGraphicWindow );
	cfg->Write( wxT( "/Appearance/Sizes/yWesternGraphicWindow" ), yWesternGraphicWindow );

	cfg->Write( wxT( "/Appearance/Sizes/xTextWindow" ), xTextWindow );
	cfg->Write( wxT( "/Appearance/Sizes/yTextWindow" ), yTextWindow );

	cfg->Write( wxT( "/Appearance/Sizes/xDasaWindow" ), xDasaWindow );
	cfg->Write( wxT( "/Appearance/Sizes/yDasaWindow" ), yDasaWindow );

	cfg->Write( wxT( "/Appearance/Sizes/xGraphicalDasaWindow" ), xGraphicalDasaWindow );
	cfg->Write( wxT( "/Appearance/Sizes/yGraphicalDasaWindow" ), yGraphicalDasaWindow );

	cfg->Write( wxT( "/Appearance/Sizes/xSbcWindow" ), xSbcWindow );
	cfg->Write( wxT( "/Appearance/Sizes/ySbcWindow" ), ySbcWindow );

	cfg->Write( wxT( "/Appearance/Sizes/xSolarWindow" ), xSolarWindow );
	cfg->Write( wxT( "/Appearance/Sizes/ySolarWindow" ), ySolarWindow );

	cfg->Write( wxT( "/Appearance/Sizes/xMidpointWindow" ), xMidpointWindow );
	cfg->Write( wxT( "/Appearance/Sizes/yMidpointWindow" ), yMidpointWindow );

	cfg->Write( wxT( "/Appearance/Sizes/xTransitWindow" ), xTransitWindow );
	cfg->Write( wxT( "/Appearance/Sizes/yTransitWindow" ), yTransitWindow );

	cfg->Write( wxT( "/Appearance/Sizes/xEphemWindow" ), xEphemWindow );
	cfg->Write( wxT( "/Appearance/Sizes/yEphemWindow" ), yEphemWindow );

	cfg->Write( wxT( "/Appearance/Sizes/xEclipseWindow" ), xEclipseWindow );
	cfg->Write( wxT( "/Appearance/Sizes/yEclipseWindow" ), yEclipseWindow );

	cfg->Write( wxT( "/Appearance/Sizes/xHoraWindow" ), xHoraWindow );
	cfg->Write( wxT( "/Appearance/Sizes/yHoraWindow" ), yHoraWindow );

	cfg->Write( wxT( "/Appearance/Sizes/xPartnerWindow" ), xPartnerWindow );
	cfg->Write( wxT( "/Appearance/Sizes/yPartnerWindow" ), yPartnerWindow );

	cfg->Write( wxT( "/Appearance/Signs/VedicSigns" ), useVedicSigns );
	cfg->Write( wxT( "/Appearance/Signs/VedicPositions" ), useVedicPositions );
	cfg->Write( wxT( "/Appearance/Signs/SignPrecision" ), signPrecision );

	cfg->Write( wxT( "/Western/Calculation/Ayanamsa" ), wAyanamsa );
	cfg->Write( wxT( "/Western/Calculation/HouseSystem" ), wHouseSystem );
	cfg->Write( wxT( "/Western/Calculation/LunarNodeMode" ), wLunarNodeMode );

	cfg->Write( wxT( "/Western/Appearance/GraphicStyle" ), wGraphicStyle );
	cfg->Write( wxT( "/Western/Appearance/OrbisAspects" ), wOrbisAspects );
	cfg->Write( wxT( "/Western/Appearance/MainChildStyle" ), wMainChildStyle );
	// TODO
	//cfg->Write( wxT( "/Western/Appearance/UseGraphicSymbols" ), useGraphicSymbols );

	// Midpoint
	cfg->Write( wxT( "/Midpoint/OrbisRadix" ), wOrbisRadix );
	cfg->Write( wxT( "/Midpoint/OrbisTransit" ), wOrbisTransit );
	cfg->Write( wxT( "/Midpoint/OrbisPartner" ), wOrbisPartner );
	cfg->Write( wxT( "/Midpoint/System" ), hsSystem );
	cfg->Write( wxT( "/Midpoint/RememberOrbis" ), hsRememberOrbis );
	cfg->Write( wxT( "/Midpoint/RememberGradkreis" ), hsRememberGradkreis );
	cfg->Write( wxT( "/Midpoint/RememberYearLength" ), hsRememberYearLength );
	cfg->Write( wxT( "/Midpoint/RememberTransitModus" ), hsRememberTransitModus );
	cfg->Write( wxT( "/Midpoint/GradkreisRadix" ), hsGradkreisRadix );
	cfg->Write( wxT( "/Midpoint/GradkreisTransit" ), hsGradkreisTransit );
	cfg->Write( wxT( "/Midpoint/GradkreisPartner" ), hsGradkreisPartner );
	cfg->Write( wxT( "/Midpoint/YearLength" ), hsYearLength );
	cfg->Write( wxT( "/Midpoint/CustomYearLength" ), hsCustomYearLength );
	cfg->Write( wxT( "/Midpoint/hsTransitModus" ), hsTransitModus );
	cfg->Write( wxT( "/Midpoint/UseSpecialEventSymbols" ), hsUseSpecialEventSymbols );

	cfg->Write( wxT( "/Appearance/Colors/fg" ), color_fg );
	cfg->Write( wxT( "/Appearance/Colors/fg2" ), color_fg2 );
	cfg->Write( wxT( "/Appearance/Colors/bg" ), color_bg );
	cfg->Write( wxT( "/Appearance/Colors/bg2" ), color_bg2 );
	cfg->Write( wxT( "/Appearance/Colors/marked" ), color_marked );
	cfg->Write( wxT( "/Appearance/Colors/benefic" ), color_benefic );
	cfg->Write( wxT( "/Appearance/Colors/malefic" ), color_malefic );

	cfg->Write( wxT( "/Appearance/MainWindow/MainToolbar" ), showMainToolbar );
	cfg->Write( wxT( "/Appearance/MainWindow/listStyle" ), listStyle );
	cfg->Write( wxT( "/Appearance/MainWindow/StatusInfo" ), showStatusInfo  );
	cfg->Write( wxT( "/Appearance/MainWindow/StatusBar" ), showStatusBar );
	cfg->Write( wxT( "/Appearance/Windows/childFrameWidth" ), childFrameWidth );

	cfg->Write( wxT( "/General/Print/ShowPageFrame" ), printShowPageFrame );
	cfg->Write( wxT( "/General/Print/ShowSelectDialog" ), printShowSelectDialog );
	cfg->Write( wxT( "/General/Print/PdfViewerCommand" ), printPdfViewerCommand );
	cfg->Write( wxT( "/General/Print/AskOnOverwrite" ), printAskOverwrite );
	cfg->Write( wxT( "/General/Print/LaunchPdfViewer" ), printLaunchPdfViewer );
	cfg->Write( wxT( "/General/Print/DefaultPrintout" ), printDefaultPrintout );
	cfg->Write( wxT( "/General/Print/PaperFormat" ), printPaperFormat );

	cfg->Write( wxT( "/General/defOpenPath" ), defOpenPath );
	cfg->Write( wxT( "/General/defSavePath" ), defSavePath );
	cfg->Write( wxT( "/General/defExportPath" ), defExportPath );
	cfg->Write( wxT( "/General/sePath" ), sePath );
	cfg->Write( wxT( "/General/favouriteCountries" ), favouriteCountries );

	cfg->Write( wxT( "/Appearance/Fonts/Default" ), fontDefault );
	cfg->Write( wxT( "/Appearance/Fonts/Header" ), fontHeader );
	cfg->Write( wxT( "/Appearance/Fonts/Graphic" ), fontGraphic );
	cfg->Write( wxT( "/Appearance/Fonts/Text" ), fontText );
	cfg->Write( wxT( "/Appearance/Fonts/Symbol" ), fontSymbol );

	cfg->Write( wxT( "/General/defaultView" ), defaultView );
	cfg->Flush();
}

