/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           Conf.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/
#ifndef _CONFIG_H_
#define _CONFIG_H_

#ifdef __GNUG__
	#pragma interface "Conf.h"
#endif

#include <wx/string.h>

#include "DataSet.h"

class wxConfigBase;

/*****************************************************
**
**   CLASS Config  
**
******************************************************/
class Config
{
public:
	Config();
	~Config();

	void readAll();
	void writeAll();

	int logMode;
	int textStyle;
	int childFrameWidth;
	bool preferVedic;
	bool preferHtml2Text;
	int maxRecentFiles;
	int listStyle;
	bool openNewDocOnStart;
	bool askOnQuit;
	int animateInterval;
	int animateMode;
	int animateStepLength;
	int animateStepDimension;
	bool closeDocumentOnMainWindowClose;
	bool showStatusInfo;
	bool showStatusBar;
	bool useMultipleViews;
	Location defaultLocation;
	int locationBackupMode;
	bool useEphemerisTime;
	bool useTopocentric;
	bool useTruePositions;
	double custom_t0;
	double custom_ayan_t0;
	double custom_aya_period;
	bool custom_aya_constant;
	bool sunrise_refrac;
	int sunrise_def;
	int ephemTimezone;
	int ephemMode;
	int partnerStyle;

	int iAyanamsa;
	int iGraphicStyle;
	int iChartCenter;
	int iHouseSystem;
	bool iHouseWestern;
	int iLunarNodeMode;
	int iArudhaMode;
	int iHoraMode;
	int iDrekkanaMode;
	int iNakshatraMode28;
	int iNakshatraPortionMode;
	int iKalachakraMode;
	int iAshtakavargaMode;
	int iMainChildStyle;
	int iYearLength;
	int iDefaultDasaList;
	double iCustomYearLength;

	int wAyanamsa;
	int wHouseSystem;
	int wGraphicStyle;
	int wLunarNodeMode;
	int wOrbisAspects;
	int wMainChildStyle;
	bool useGraphicSymbols;

	// Uranian
	int hsSystem;
	bool hsRememberOrbis, hsRememberGradkreis, hsRememberYearLength, hsRememberTransitModus;
	int hsGradkreisRadix, hsGradkreisTransit, hsGradkreisPartner;
	int hsYearLength;
	double hsCustomYearLength;
	int hsTransitModus;
	bool hsUseSpecialEventSymbols;

	int wOrbisRadix;
	int wOrbisTransit;
	int wOrbisPartner;

	bool printShowPageFrame;
	bool printShowSelectDialog;
	int printDefaultPrintout;
	int printPaperFormat;
	bool printLaunchPdfViewer;
	bool printAskOverwrite;
	wxString printPdfViewerCommand;

	int color_fg;
	int color_fg2;
	int color_bg;
	int color_bg2;
	int color_marked;
	int color_benefic;
	int color_malefic;

	int xMasterWindow, yMasterWindow, xPosMasterWindow, yPosMasterWindow;

	int xMultipleView, yMultipleView;
	int xMainWindow, yMainWindow;
	int xVedicGraphicWindow, yVedicGraphicWindow;
	int xWesternGraphicWindow, yWesternGraphicWindow;
	int xTextWindow, yTextWindow;
	int xDasaWindow, yDasaWindow;
	int xGraphicalDasaWindow, yGraphicalDasaWindow;
	int xSbcWindow, ySbcWindow;
	int xSolarWindow, ySolarWindow;
	int xMidpointWindow, yMidpointWindow;
	int xTransitWindow, yTransitWindow;
	bool useVedicSigns;
	bool useVedicPositions;
	int signPrecision;

	int xEphemWindow, yEphemWindow;
	int xEclipseWindow, yEclipseWindow;
	int xHoraWindow, yHoraWindow;
	int xPartnerWindow, yPartnerWindow;

	bool showMainToolbar;

	wxString lang;
	wxString langList;
	int textWindowPage;

	wxString fontDefault, fontHeader, fontGraphic, fontText, fontSymbol;
	wxString recentFileList;
	wxString defOpenPath, defSavePath, defExportPath, sePath, favouriteCountries, defaultView;

private:
	wxConfigBase *cfg;
	double readDoubleEntry( wxString path, const double def = 0 );
	void writeDoubleEntry( wxString path, const double value );
};



#endif

