/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           Dasa.cpp
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/


#ifdef __GNUG__
	#pragma implementation "Dasa.h"
#endif

#include "Dasa.h"

#include <wx/string.h>

#include "Varga.h"
#include "constants.h"
#include "func.h"
#include "Lang.h"
#include "Horoscope.h"
#include "Writer.h"

/*****************************************************
**
**   DasaImpl   ---   Constructor 
**
******************************************************/
DasaImpl::DasaImpl( DasaExpert *e, const int lrd, const double stjd, const double ejd, const wxChar *etext, Dasa *prt )
{
	extraText = etext;
	expert = e;
	lord = lrd;
	start_jd = stjd;
	end_jd = ejd;
	parent = prt;
}

/*****************************************************
**
**   DasaImpl   ---   dump 
**
******************************************************/
void DasaImpl::dump(wxString &o)
{
	Formatter *f = Formatter::get();

	if ( expert->getType() == DASA_TYPE_SIGN )
		o << Lang::get()->getSignName( lord );
	else
		o <<  Lang::get()->getObjectName(lord,TMEDIUM);

	o	<< wxT( " " ) << f->getDateStringFromJD( getStartJD() ) << wxT( " - " ) << f->getDateStringFromJD( getEndJD() ) << Endl;
}

/*****************************************************
**
**   RasiDasaImpl   ---   Constructor 
**
******************************************************/
RasiDasaImpl::RasiDasaImpl( DasaExpert *expert, VargaView *v, const int &lrd, const double &stjd, const double &ejd, const wxChar *etext,
	Dasa *prt )
	: DasaImpl( expert, lrd, stjd, ejd, etext, prt )
{
	view = new VargaView( v->getHoroscope(), v->getDivision());
}

/*****************************************************
**
**   RasiDasaImpl   ---   Destructor 
**
******************************************************/
RasiDasaImpl::~RasiDasaImpl()
{
	delete view;
}

/*****************************************************
**
**   DasaExpert   ---   write
**
******************************************************/
void DasaExpert::write( Writer *writer, Horoscope *horoscope, int varga )
{
	Formatter *formatter = Formatter::get();
	double startjd;
	unsigned int i;
	wxString s, lord;
 
	VargaExpert vexpert;
	s.Printf( wxT( "%s %s" ), getName(), _( "Dasa" ) );
  writer->writeHeader2( s );

	vector<Dasa*> v = getFirstLevel( horoscope, varga );
	vector<Dasa*> w;

	for( i = 0; i < v.size(); i++ )
	{
		if ( getType() == DASA_TYPE_SIGN ) lord = Lang::get()->getSignName( v[i]->getDasaLord(), TLARGE );
		else lord =  Lang::get()->getObjectName(v[i]->getDasaLord(), TLARGE);

		startjd = Max( v[i]->getStartJD(), horoscope->getJD() );
		if ( v[i]->getExtraText() && v[i]->getExtraText() != wxT( "" ) )
		{
			s.Printf( wxT( "%s (%s): %s - %s" ), lord.c_str(), v[i]->getExtraText().c_str(),
				formatter->getDateStringFromJD( startjd ).c_str(),
				formatter->getDateStringFromJD( v[i]->getEndJD() ).c_str());
		}
		else
		{
			s.Printf( wxT( "%s: %s - %s" ), lord.c_str(),
				formatter->getDateStringFromJD( startjd ).c_str(),
				formatter->getDateStringFromJD( v[i]->getEndJD() ).c_str());
		}
		writer->writeHeader3( s );
		s.Clear();

		w = getNextLevel( v[i] );
		if ( w.size() == 0 ) continue;
		
		startjd = Max( w[0]->getStartJD(), horoscope->getJD() );
		s << wxT( " * " ) << formatter->getDateStringFromJD( startjd ) << wxT( " " );

		for( unsigned int j = 0; j < w.size(); j++ )
		{
			if ( w[j]->getEndJD() >= horoscope->getJD())
			{
				if ( getType() == DASA_TYPE_SIGN ) 
					s << Lang::get()->getSignName(w[j]->getDasaLord() );
				else
					s <<  Lang::get()->getObjectName(w[j]->getDasaLord(), TLARGE)
						<< wxT( " " ) << formatter->getDateStringFromJD( w[j]->getEndJD() ) << wxT( " " );
			}
			delete w[j];
		}
		writer->writeLine( s );
		s.Clear();
	}
	for( i = 0; i < v.size(); i++ ) delete v[i];
}

/*****************************************************
**
**   DasaExpert   ---   writeMore
**
******************************************************/
void DasaExpert::writeMore( Writer *writer, Horoscope *horoscope, int varga )
{
	Formatter *formatter = Formatter::get();
	double startjd;
	unsigned int i;
	wxString s, s1, lord;
 
	VargaExpert vexpert;
	s.Printf( wxT( "%s %s" ), getName(), _( "Dasa" ) );
  writer->writeHeader1( s );

	vector<Dasa*> v = getFirstLevel( horoscope, varga );
	vector<Dasa*> w;

	for( i = 0; i < v.size(); i++ )
	{
		if ( getType() == DASA_TYPE_SIGN ) lord = Lang::get()->getSignName( v[i]->getDasaLord(), TLARGE );
		else lord =  Lang::get()->getObjectName(v[i]->getDasaLord(), TLARGE);
		s.Printf( wxT( "%d. %s %s" ), i+1, _( "Mahadasa" ), lord.c_str() );
		writer->writeHeader2( s );

		if ( v[i]->getExtraText() && v[i]->getExtraText() != wxT( "" ) )
			{ writer->writeLine( v[i]->getExtraText() ); }

		startjd = Max( v[i]->getStartJD(), horoscope->getJD() );
		s.Printf( wxT( "%s: %s" ), _( "Start Date" ), formatter->getDateStringFromJD( startjd ).c_str() );
		writer->writeLine( s );
		s.Printf( wxT( "%s: %s" ), _( "End Date" ), formatter->getDateStringFromJD( v[i]->getEndJD() ).c_str() );
		writer->writeLine( s );
		getDasaDuration( s1, v[i]->getEndJD() - v[i]->getStartJD() );
		s.Printf( wxT( "%s: %s" ), _( "Duration" ), s1.c_str() );
		writer->writeLine( s );

		w = getNextLevel( v[i] );
		if ( w.size() == 0 ) continue;
		
		writer->writeHeader3( _( "Antardasas" ) );

		// Get the number of lines
		int lines = 1;
		for( unsigned int j = 0; j < w.size(); j++ )
		{
			if ( w[j]->getEndJD() >= horoscope->getJD()) lines++;
		}

		Table table( 4, lines );
		table.setHeader( 0, _( "Lord" ));
		table.setHeader( 1,  _( "Start Date" ));
		table.setHeader( 2,  _( "Final Date" ));
		table.setHeader( 3,  _( "Duration" ));

		int line = 1;
		for( unsigned int j = 0; j < w.size(); j++ )
		{
			if ( w[j]->getEndJD() >= horoscope->getJD())
			{
				if ( getType() == DASA_TYPE_SIGN ) lord = Lang::get()->getSignName(w[j]->getDasaLord(), TLARGE );
				else lord = Lang::get()->getObjectName(w[j]->getDasaLord(), TLARGE);
				table.setEntry( 0, line, lord );

				startjd = Max( w[j]->getStartJD(), horoscope->getJD() );
				table.setEntry( 1, line, formatter->getDateStringFromJD( startjd ) );
				
				table.setEntry( 2, line, formatter->getDateStringFromJD( w[j]->getEndJD() ) );

				getDasaDuration( s, w[j]->getEndJD() - w[j]->getStartJD() );
				table.setEntry( 3, line, s );
				line++;
			}
			delete w[j];
		}
		writer->writeTable( table );
	}
	for( i = 0; i < v.size(); i++ ) delete v[i];
}

/*****************************************************
**
**   DasaExpert   ---   getKPEventList
**
******************************************************/
vector<KPEvent> DasaExpert::getKPEventList( const double &startlen, const double &Endlen, const double &startjd )
{
	vector<KPEvent> v;
	return v;
}


