/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           Dasa.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/
#ifndef _DASA_H_
#define _DASA_H_

#ifdef __GNUG__
	#pragma interface "Dasa.h"
#endif

#include "constants.h"

#include <vector>
#include <wx/string.h>

class Dasa;
class Horoscope;
class VargaView;
class DasaExpert;
class Writer;

using namespace std;

/*****************************************************
**
**   CLASS Dasa  
**
******************************************************/
class Dasa
{
public:
	virtual ~Dasa() {}

	// the jd's for start and end of the dasa
	virtual double getStartJD() = 0;
	virtual double getEndJD() = 0;

	// the jd of birth (because dasa dates before birth have to be faded out)
	virtual double getBirthJD() = 0;

	// the lord: either a planet or a sign
	virtual int getDasaLord() = 0;

	// the parent: o for mahadasa, > 0 for Antardasas, etc.
	virtual Dasa *getParent() = 0;
	virtual void setParent( Dasa* ) = 0;

	// some extra information about the dasa like the dehas and jeevas for kalachakra dasa
	virtual const wxString getExtraText() = 0;
};

/*****************************************************
**
**   CLASS DasaImpl  
**
******************************************************/
class DasaImpl : public Dasa
{
public:

	DasaImpl( DasaExpert*, const int lord, const double startjd, const double endjd, const wxChar *extraText, Dasa* );
	~DasaImpl() {}

	virtual double getStartJD() { return start_jd; }
	virtual double getEndJD() { return end_jd; }
	virtual double getBirthJD() { return birth_jd; }
	virtual int getDasaLord() { return lord; }
	virtual Dasa *getParent() { return parent; }
	virtual const wxString getExtraText() { return extraText; }
	virtual void setParent( Dasa *d ) { parent = d; }
	virtual void dump( wxString& );

protected:
	DasaImpl() {}
	DasaExpert *expert;
	double start_jd, end_jd, birth_jd;
	int lord;
	Dasa *parent;
	wxString extraText;
};

/*****************************************************
**
**   CLASS RasiDasaImpl  
**
******************************************************/
class RasiDasaImpl : public DasaImpl
{
public:
	RasiDasaImpl( DasaExpert*, VargaView*, const int &lord, const double &startjd, const double &endjd, const wxChar *eText, Dasa* );
	~RasiDasaImpl();

	virtual VargaView *getVargaView() { return view; }

protected:
	RasiDasaImpl() {}
	VargaView *view;
};

/*****************************************************
**
**   CLASS KPEvent  
**
******************************************************/
class KPEvent
{
public:
	KPEvent( int l, int sl, double ll, double jjd, const int &index )
		{ lord = l; sublord = sl; len = ll; jd = jjd; dasaindex = index; }
	int lord, sublord, dasaindex;
	double len, jd;
};

/*****************************************************
**
**   CLASS DasaExpert  
**
******************************************************/
class DasaExpert
{
public:
	virtual ~DasaExpert() {}
	virtual vector<Dasa*> getFirstLevel( Horoscope*, const int varga = 0 ) = 0;
	virtual vector<Dasa*> getNextLevel( Dasa* ) = 0;
	virtual const int getType() = 0;
	virtual const wxChar *getName() = 0;
	void write( Writer*, Horoscope *horoscope, const int varga = 0 );
	void writeMore( Writer*, Horoscope *horoscope, const int varga = 0 );
	virtual bool hasKpFeatures() { return false; }
  virtual vector<KPEvent> getKPEventList( const double &startlen, const double &Endlen, const double &startjd );
	virtual void getKPLord( const double &len, int &lord, int &sublord ) {}
};

/*****************************************************
**
**   CLASS GrahaDasaExpert  
**
******************************************************/
class GrahaDasaExpert : public DasaExpert
{
public:
	virtual const int getType() { return DASA_TYPE_PLANET; }
};

/*****************************************************
**
**   CLASS RasiDasaExpert  
**
******************************************************/
class RasiDasaExpert : public DasaExpert
{
public:
	virtual const int getType() { return DASA_TYPE_SIGN; }
};

#endif

