/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           DataSet.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/
#ifndef _DATA_SET_
#define _DATA_SET_

#ifdef __GNUG__
	#pragma interface "DataSet.h"
#endif

#include <wx/string.h>
#include <wx/textfile.h>

#include "constants.h"

/*****************************************************
**
**   CLASS JDate  
**
******************************************************/
class JDate
{
public:

	JDate();
	JDate( const double& );
	JDate( const JDate & );

	void setActualDate();
	double getJD() { return jd; }
	int getWeekDay() { return week_day; }
	void setDate( const double& );
	void setDate( const int &day, const int &month, const int &year, const double &time );
	void operator=( const JDate& date );
	void dump( wxString& );

private:
	double jd;
	int week_day;
	void updateJD( const int &day, const int &month, const int &year, const double &time );
};

/*****************************************************
**
**   CLASS Location  
**
******************************************************/
class Location
{
public:

  Location();
  Location( const Location & );

  void operator=( const Location& );
  void setLocation( const wxString &locName, const double &longitude, const double &latitude,
		const double &timeZone, const double &dst );
  double getLongitude() { return longitude; }
  double getLatitude() { return latitude; }
  wxString getLocName() { return locName; }
  double getTimeZone() { return tz; }
  double getDST() { return dst; }
  void dump(wxString&);

private:
  double latitude, longitude;
  double tz;
  double dst;
  wxString locName;
};

/*****************************************************
**
**   CLASS DataSet  
**
******************************************************/
class DataSet
{
public:

	DataSet();
	DataSet( const Location& );
	DataSet( const DataSet & );
	~DataSet();

  void operator=( const DataSet& );
	void setDate( const double& );
	JDate *getDate() { return date; }
	void setDate( const int &day, const int &month, const int &year, const double &time );
	void setActualDate();
	double getJD() const { return date->getJD(); }
	int getWeekDay() { return date->getWeekDay(); }
	void setLocation( const wxString &locName, const double &longitude, const double &latitute,
		const double &timeZone, const double &dst );
	void setLocation( const Location& );
	Location *getLocation() { return location; }
	wxString &getName() { return name; }
	void setName( const wxString& );
	wxString getRemark() { return remark; }
	void setRemark( const wxString& );
	void dump(wxString&);

protected:
	wxString remark;

private:
	wxString name;
	JDate *date;
	Location *location;
};

/*****************************************************
**
**   CLASS FileDataSet  
**
******************************************************/
class FileDataSet : public DataSet
{
public:

	FileDataSet();
	FileDataSet( const Location& );
	~FileDataSet();

	bool openFile( const wxString&, bool isAtxFile = true );
	bool saveAs( const wxString& );
	bool save();
	const wxString getFilename() { return filename; }

private:
	bool readJhdFile();
	bool readAtxFile();
	bool readMtxFile();
	wxString filename;
	wxTextFile theFile;
};

/*****************************************************
**
**   CLASS LocationEntry  
**
******************************************************/
class LocationEntry
{
public:
  LocationEntry();
  LocationEntry( const wxChar* name, const wxChar *country, const wxChar *state,
		const double &lon, const double &lat, const double &tz );
	LocationEntry( const wxString& );
	void operator=( const LocationEntry& );
	bool operator==( const LocationEntry& );

	wxString name, state, country;
	double longitude, latitude, timeZone;
	int row;
};

#endif


