/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           Eclipse.cpp
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifdef __GNUG__
	#pragma implementation "Eclipse.h"
#endif

#include "Eclipse.h"

#include "Calculator.h"
#include "Session.h"
#include "DataSet.h"
#include "func.h"
#include "constants.h"
#include "Lang.h"
#include "Writer.h"

/*****************************************************
**
**   CLASS EclipseDataSort  
**
******************************************************/
class EclipseDataSort
{
public:
  bool operator()( EclipseData *e1, EclipseData *e2 ) const
  {
    return ( e1->jd < e2->jd );
  }
};

/*****************************************************
**
**   EclipseExpert   ---   Constructor 
**
******************************************************/
EclipseExpert::EclipseExpert()
{
}

/*****************************************************
**
**   EclipseExpert   ---   Destructor 
**
******************************************************/
EclipseExpert::~EclipseExpert()
{
  list<EclipseData*>::iterator iter;
  for( iter = data.begin(); iter != data.end(); iter++ )
  {
    delete (*iter);
  }
}

/*****************************************************
**
**   EclipseExpert   ---   update 
**
******************************************************/
void EclipseExpert::update( const double &startjd, const double &endjd, const int &planet, const int &type, const bool &vedic )
{
	Calculator *calculator = Session::get()->getCalculator();
	EclipseData d;
	int count = 0;

	if ( startjd >= endjd ) return;

	if ( planet == 0 || planet == 1 )
	{
		d.jd = startjd;
		while( d.jd < endjd && count < 100 )
		{
			d = calculator->calcNextEclipse( d.jd, OSUN, 0, vedic );
			d.planet = OSUN;
			if ( d.jd <= endjd ) data.push_back( new EclipseData( d ));
			count++;
		}
	}
	if ( planet == 0 || planet == 2 )
	{
		count = 0;
		d.jd = startjd;
		while( d.jd < endjd && count < 100 )
		{
			d = calculator->calcNextEclipse( d.jd, OMOON, 0, vedic );
			d.planet = OMOON;
			if ( d.jd <= endjd ) data.push_back( new EclipseData( d ));
			count++;
		}
	}
	data.sort( EclipseDataSort() );
}

/*****************************************************
**
**   EclipseExpert   ---   write
**
******************************************************/
void EclipseExpert::write( Writer *writer )
{
	EclipseData* e;
	Formatter *formatter = Formatter::get();
  list<EclipseData*>::iterator iter;
	wxString type;

	writer->writeHeader1( _( "Eclipses" ));
	Table table( 4, data.size()+1 );
	table.setHeader( 0, _( "Type" ));
	table.setHeader( 1, _( "Date and Time (GT)" ));
	table.setHeader( 2, _( "Sun" ));
	table.setHeader( 3, _( "Moon" ));

	int i = 1;
  for( iter = data.begin(); iter != data.end(); iter++ )
  {
    e = (*iter);
		if ( e->planet == OSUN ) type = _( "Solar"  );
		else type = _( "Lunar" );
		type << wxT( " " ) << e->description;
		table.setEntry( 0, i, type );
		table.setEntry( 1, i, formatter->getFullDateStringFromJD( e->jd ));
		table.setEntry( 2, i, formatter->getPosFormatted( e->sunpos ));
		table.setEntry( 3, i, formatter->getPosFormatted( e->moonpos ));
		i++;
	}
	writer->writeTable( table );
}



