/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           Ephemeris.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifndef _EPHEMERIS_H_
#define _EPHEMERIS_H_

#ifdef __GNUG__
	#pragma interface "Ephemeris.h"
#endif

#include <wx/string.h>
#include <list>
#include <vector>

#include "constants.h"
#include "GenericDasa.h"

class DataSet;
class Writer;
using namespace std;

/*****************************************************
**
**   CLASS IngressEvent  
**
******************************************************/
class IngressEvent
{
public:
	IngressEvent( double _jd, int _planet, int _which, int _type )
		{ jd = _jd; planet = _planet; which = _which; type = _type; }

	double jd;
	int planet, which, type;
};

/*****************************************************
**
**   CLASS IngressEvent  
**
******************************************************/
class LunarEvent {
	
public:
	LunarEvent( const double &a, const double &j, const double& s, const double &m  )
		{  angle = a; jd  = j; slen = s; mlen = m; }
	double angle, jd, mlen, slen;
};


/*****************************************************
**
**   CLASS EphemExpert  
**
******************************************************/
class EphemExpert
{
	friend class EphemHtmlWriter;
public:

	EphemExpert();
	~EphemExpert();

	void setPreferVedic( const bool& );
	void prepareMonth( const int &month, const int &year, const bool &isLocaltime );

	void writeIngress( Writer*, const int filter = 1 );
	void writeKp( Writer*, const int& );
	void writeDetails( Writer* );
	void writeDefaultEphemeris( Writer*, const int filter = 1 );
	void writeLunar( Writer* );


	int getNumberOfDays() { return nb_days; }
	double getLength( const int &planet, const int &day );
	double getSpeed( const int &planet, const int &day );
	bool getRetro( const int &planet, const int &day );
	void calcMonth();
	int getPlanetaryIndex( const int &index );
	int getMonth() { return month; }
	int getYear() { return year; }

private:
	void init();
	void calcLength();
	void calcDetails();
	void calcIngress( const int filter = 1 );
	void calcKP( const int& );
	void calcLunar();

	void testIngressEvent( const int& t1, const int &t2, const int &planet, const int &type, const bool &r );
	void writeHeaderInfo( Writer* );
	void addLunarEvent( const int &stdate, const double& target, const double& sdiff, const double &ediff );
	void addLunarSpecialEvent( const int &stdate, const double& target, const double& sdiff, const double &ediff );

	DataSet *d;
	int nb_days, year, month;
	bool retro[OPOSEIDON+1][32], clen, cingress, ckp, cdetails, clunar, preferVedic, localtime;
	double len[OPOSEIDON+1][32], speed[OPOSEIDON+1][32], jd[32], st[32], sunrise[32], sunset[32], tz;
	int rasi[OPOSEIDON+1][32], nakshatra[OPOSEIDON+1][32], weekday[32], tithi[32], mydasa;

  vector<KPEvent> kpevents;
	list<IngressEvent> ingressEvents;
	list<LunarEvent> lunarEvents;

	const static wxChar *month_name[12];
	//const static wxChar *day[7];
};

#endif


